/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.platform.scripting.scriptmanager;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.script.ScriptException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.jaxrs.utils.RedirectUtil;
import org.apache.clerezza.jaxrs.utils.TrailingSlash;
import org.apache.clerezza.jaxrs.utils.form.FormFile;
import org.apache.clerezza.jaxrs.utils.form.MultiPartBody;
import org.apache.clerezza.platform.content.DiscobitsHandler;
import org.apache.clerezza.platform.globalmenu.GlobalMenuItem;
import org.apache.clerezza.platform.globalmenu.GlobalMenuItemsProvider;
import org.apache.clerezza.platform.graphprovider.content.ContentGraphProvider;
import org.apache.clerezza.platform.scripting.NoEngineException;
import org.apache.clerezza.platform.scripting.ScriptExecution;
import org.apache.clerezza.platform.scripting.ScriptLanguageDescription;
import org.apache.clerezza.platform.scripting.scriptmanager.ScriptManagerAppPermission;
import org.apache.clerezza.platform.scripting.scriptmanager.ontology.SCRIPTMANAGER;
import org.apache.clerezza.platform.typerendering.RenderletManager;
import org.apache.clerezza.platform.typerendering.scalaserverpages.ScalaServerPagesRenderlet;
import org.apache.clerezza.platform.typerendering.seedsnipe.SeedsnipeRenderlet;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.LockableMGraph;
import org.apache.clerezza.rdf.core.access.security.TcPermission;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.ontologies.DCTERMS;
import org.apache.clerezza.rdf.ontologies.PLATFORM;
import org.apache.clerezza.rdf.ontologies.RDF;
import org.apache.clerezza.rdf.ontologies.SCRIPT;
import org.apache.clerezza.rdf.utils.GraphNode;
import org.apache.clerezza.rdf.utils.RdfList;
import org.apache.clerezza.rdf.utils.UnionMGraph;
import org.apache.clerezza.web.fileserver.BundlePathNode;
import org.apache.clerezza.web.fileserver.FileServer;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wymiwyg.commons.util.dirbrowser.PathNode;

@Path(value="/admin/scripting")
public class ScriptManager
implements GlobalMenuItemsProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RenderletManager renderletManager;
    private ContentGraphProvider cgProvider;
    private DiscobitsHandler contentHandler;
    private ScriptExecution scriptExecution;
    private FileServer fileServer;

    protected void activate(ComponentContext componentContext) throws IOException, URISyntaxException {
        this.logger.info("Script Manager activated.");
        Bundle bundle = componentContext.getBundleContext().getBundle();
        URL resourceDir = this.getClass().getResource("staticweb");
        BundlePathNode pathNode = new BundlePathNode(bundle, resourceDir.getPath());
        this.logger.info("Initializing file server for {} ({})", (Object)resourceDir, (Object)resourceDir.getFile());
        this.fileServer = new FileServer((PathNode)pathNode);
        URL renderlet = this.getClass().getResource("scriptmanager-script-overview.ssp");
        this.renderletManager.registerRenderlet(ScalaServerPagesRenderlet.class.getName(), new UriRef(renderlet.toURI().toString()), SCRIPTMANAGER.ScriptManagerOverviewPage, "naked", MediaType.APPLICATION_XHTML_XML_TYPE, true);
        renderlet = this.getClass().getResource("scriptmanager-script-list.xhtml");
        this.renderletManager.registerRenderlet(SeedsnipeRenderlet.class.getName(), new UriRef(renderlet.toURI().toString()), SCRIPTMANAGER.ScriptList, "naked", MediaType.APPLICATION_XHTML_XML_TYPE, true);
        renderlet = this.getClass().getResource("scriptmanager-script-install.ssp");
        this.renderletManager.registerRenderlet(ScalaServerPagesRenderlet.class.getName(), new UriRef(renderlet.toURI().toString()), SCRIPTMANAGER.ScriptManagerInstallPage, "naked", MediaType.APPLICATION_XHTML_XML_TYPE, true);
        renderlet = this.getClass().getResource("scriptmanager-execution-uri-overview.ssp");
        this.renderletManager.registerRenderlet(ScalaServerPagesRenderlet.class.getName(), new UriRef(renderlet.toURI().toString()), SCRIPTMANAGER.ExecutionUriOverviewPage, "naked", MediaType.APPLICATION_XHTML_XML_TYPE, true);
        renderlet = this.getClass().getResource("scriptmanager-execution-uri-list.xhtml");
        this.renderletManager.registerRenderlet(SeedsnipeRenderlet.class.getName(), new UriRef(renderlet.toURI().toString()), SCRIPTMANAGER.ExecutionUriList, "naked", MediaType.APPLICATION_XHTML_XML_TYPE, true);
        renderlet = this.getClass().getResource("scriptmanager-script-information.xhtml");
        this.renderletManager.registerRenderlet(SeedsnipeRenderlet.class.getName(), new UriRef(renderlet.toURI().toString()), SCRIPTMANAGER.SelectedScript, "naked", MediaType.APPLICATION_XHTML_XML_TYPE, true);
    }

    @GET
    public Response redirectToOverviewPage(@Context UriInfo uriInfo) {
        if (uriInfo.getAbsolutePath().toString().endsWith("/")) {
            return RedirectUtil.createSeeOtherResponse((String)"script-overview", (UriInfo)uriInfo);
        }
        return RedirectUtil.createSeeOtherResponse((String)"scripting/script-overview", (UriInfo)uriInfo);
    }

    @GET
    @Path(value="script-overview")
    public GraphNode overview(@QueryParam(value="script") UriRef script) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        BNode resultResource = new BNode();
        SimpleMGraph resultGraph = new SimpleMGraph();
        GraphNode scriptNode = null;
        if (script != null) {
            scriptNode = this.getScript(script);
            resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, SCRIPTMANAGER.script, scriptNode.getNode()));
        }
        resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, RDF.type, (Resource)PLATFORM.HeadedPage));
        resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, RDF.type, (Resource)SCRIPTMANAGER.ScriptManagerOverviewPage));
        GraphNode scriptList = this.getScriptList((NonLiteral)resultResource);
        UnionMGraph unionGraph = null;
        unionGraph = scriptNode != null ? new UnionMGraph(new TripleCollection[]{resultGraph, scriptList.getGraph(), scriptNode.getGraph(), contentGraph}) : new UnionMGraph(new TripleCollection[]{resultGraph, scriptList.getGraph(), contentGraph});
        return new GraphNode((Resource)resultResource, (TripleCollection)unionGraph);
    }

    @GET
    @Path(value="get-script")
    @Produces(value={"text/plain"})
    public GraphNode getScript(@QueryParam(value="script") UriRef scriptUri) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        BNode resource = new BNode();
        SimpleMGraph resultGraph = new SimpleMGraph();
        resultGraph.add((Object)new TripleImpl((NonLiteral)resource, SCRIPTMANAGER.script, (Resource)scriptUri));
        resultGraph.add((Object)new TripleImpl((NonLiteral)resource, RDF.type, (Resource)SCRIPTMANAGER.SelectedScript));
        resultGraph.add((Object)new TripleImpl((NonLiteral)scriptUri, SCRIPTMANAGER.code, (Resource)new PlainLiteralImpl(new String(this.contentHandler.getData(scriptUri)))));
        GraphNode scriptLanguageList = this.getScriptLanguageList((NonLiteral)resource);
        return new GraphNode((Resource)resource, (TripleCollection)new UnionMGraph(new TripleCollection[]{resultGraph, this.cgProvider.getContentGraph(), scriptLanguageList.getGraph()}));
    }

    @GET
    @Path(value="script-list")
    @Produces(value={"text/plain"})
    public GraphNode getScriptList(@QueryParam(value="resource") UriRef uriRef) {
        return this.getScriptList((NonLiteral)uriRef);
    }

    private GraphNode getScriptList(@QueryParam(value="resource") NonLiteral resource) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        if (resource == null) {
            resource = new BNode();
        }
        BNode resultResource = new BNode();
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        SimpleMGraph additionGraph = new SimpleMGraph();
        UnionMGraph resultGraph = new UnionMGraph(new TripleCollection[]{additionGraph, contentGraph});
        RdfList list = RdfList.createEmptyList((NonLiteral)resultResource, (TripleCollection)additionGraph);
        resultGraph.add((Triple)new TripleImpl(resource, SCRIPTMANAGER.scriptList, (Resource)resultResource));
        resultGraph.add((Triple)new TripleImpl((NonLiteral)resultResource, RDF.type, (Resource)SCRIPTMANAGER.ScriptList));
        Iterator it = contentGraph.filter(null, RDF.type, (Resource)SCRIPT.Script);
        while (it.hasNext()) {
            list.add((Object)((Triple)it.next()).getSubject());
        }
        return new GraphNode((Resource)resultResource, (TripleCollection)new UnionMGraph(new TripleCollection[]{resultGraph, contentGraph}));
    }

    @GET
    @Path(value="script-install")
    public GraphNode install() {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        BNode resultResource = new BNode();
        SimpleMGraph resultGraph = new SimpleMGraph();
        resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, RDF.type, (Resource)SCRIPTMANAGER.ScriptManagerInstallPage));
        resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, RDF.type, (Resource)PLATFORM.HeadedPage));
        GraphNode languageList = this.getScriptLanguageList((NonLiteral)resultResource);
        GraphNode scriptList = this.getScriptList((NonLiteral)resultResource);
        UnionMGraph unionGraph = new UnionMGraph(new TripleCollection[]{resultGraph, scriptList.getGraph(), languageList.getGraph(), contentGraph});
        return new GraphNode((Resource)resultResource, (TripleCollection)unionGraph);
    }

    private GraphNode getScriptLanguageList(NonLiteral resource) {
        SimpleMGraph resultGraph = new SimpleMGraph();
        Iterator it = this.scriptExecution.getInstalledScriptLanguages();
        while (it.hasNext()) {
            BNode languageDescription = new BNode();
            ScriptLanguageDescription sld = (ScriptLanguageDescription)it.next();
            resultGraph.add((Object)new TripleImpl(resource, SCRIPTMANAGER.scriptLanguageDescription, (Resource)languageDescription));
            resultGraph.add((Object)new TripleImpl((NonLiteral)languageDescription, SCRIPT.scriptLanguage, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)sld.getLanguage())));
            resultGraph.add((Object)new TripleImpl((NonLiteral)languageDescription, SCRIPT.scriptLanguageVersion, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)sld.getVersion())));
        }
        return new GraphNode((Resource)resource, (TripleCollection)resultGraph);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="install-script")
    public Response installScript(MultiPartBody form, @Context UriInfo uriInfo) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        TrailingSlash.enforceNotPresent((UriInfo)uriInfo);
        URI absolutePath = uriInfo.getAbsolutePath();
        String baseUriString = absolutePath.getScheme() + "://" + absolutePath.getAuthority() + "/scripts/" + UUID.randomUUID().toString();
        UriRef scriptUri = new UriRef(baseUriString);
        int counter = 0;
        while (this.contentHandler.getData(scriptUri) != null) {
            scriptUri = new UriRef(baseUriString + "." + ++counter);
        }
        String scriptExecutionUri = form.getTextParameterValues("scriptExecutionUri")[0];
        String scriptLanguageAndVersion = form.getTextParameterValues("scriptLanguage")[0];
        String mediaType = form.getTextParameterValues("mediaType")[0];
        String producedType = form.getTextParameterValues("producedType")[0];
        ScriptLanguageDescription sld = this.extractLanguageAndVersion(scriptLanguageAndVersion);
        String fileChoice = form.getTextParameterValues("fileChoice")[0];
        String scriptName = "unnamed";
        byte[] scriptFileBytes = new byte[]{};
        if (fileChoice.equals("file")) {
            FormFile formFile = form.getFormFileParameterValues("scriptFile")[0];
            scriptFileBytes = formFile.getContent();
            if (scriptFileBytes == null || scriptFileBytes.length == 0) {
                String message = "no script uploaded";
                this.logger.warn(message);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build());
            }
            scriptName = formFile.getFileName();
            if (mediaType.trim().equals("")) {
                mediaType = formFile.getMediaType().toString();
            }
        } else if (fileChoice.equals("text")) {
            if (form.getTextParameterValues("scriptCode").length > 0) {
                scriptFileBytes = form.getTextParameterValues("scriptCode")[0].getBytes();
            }
            if (form.getTextParameterValues("scriptName").length > 0 && (scriptName = form.getTextParameterValues("scriptName")[0]).trim().equals("")) {
                scriptName = "unnamed";
            }
            if (mediaType.trim().equals("")) {
                mediaType = "text/plain";
            }
        }
        if (!scriptExecutionUri.trim().equals("") && !this.saveExecutionUri(scriptExecutionUri, scriptUri)) {
            this.logger.warn("The execution URI {} is already used.", (Object)scriptExecutionUri);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.saveScript(scriptUri, scriptFileBytes, scriptName, sld.getLanguage(), sld.getVersion(), mediaType, producedType);
        return RedirectUtil.createSeeOtherResponse((String)"script-overview", (UriInfo)uriInfo);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="update-script")
    public Response updateScript(MultiPartBody form, @Context UriInfo uriInfo) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        UriRef scriptUri = new UriRef(form.getTextParameterValues("scriptUri")[0]);
        String scriptName = form.getTextParameterValues("fileName")[0];
        String scriptLanguageAndVersion = form.getTextParameterValues("scriptLanguage")[0];
        String mediaType = form.getTextParameterValues("mediaType")[0];
        String producedType = form.getTextParameterValues("producedType")[0];
        String scriptCode = form.getTextParameterValues("scriptCode")[0];
        ScriptLanguageDescription sld = this.extractLanguageAndVersion(scriptLanguageAndVersion);
        FormFile formFile = form.getFormFileParameterValues("scriptFile")[0];
        byte[] scriptFileBytes = formFile.getContent();
        if (scriptFileBytes == null || scriptFileBytes.length == 0) {
            scriptFileBytes = scriptCode.getBytes();
            if (mediaType.trim().equals("")) {
                mediaType = "text/plain";
            }
        } else {
            if (mediaType.trim().equals("")) {
                mediaType = formFile.getMediaType().toString();
            }
            scriptName = formFile.getFileName();
        }
        this.saveScript(scriptUri, scriptFileBytes, scriptName, sld.getLanguage(), sld.getVersion(), mediaType, producedType);
        return RedirectUtil.createSeeOtherResponse((String)("script-overview?script=" + scriptUri.getUnicodeString()), (UriInfo)uriInfo);
    }

    @POST
    @Path(value="delete")
    public Response deleteScript(@FormParam(value="script") String script) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        UriRef scriptUri = new UriRef(script);
        Set<NonLiteral> scriptGeneratedResources = this.getScriptGeneratedResources((NonLiteral)scriptUri);
        for (NonLiteral scriptGenratedResource : scriptGeneratedResources) {
            this.deleteExecutionUri(scriptGenratedResource, scriptUri);
        }
        this.deleteScript(scriptUri);
        this.logger.info("script {} deleted", (Object)scriptUri);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private void saveScript(UriRef scriptUri, byte[] scriptFileBytes, String scriptName, String scriptLanguage, String scriptLanguageVersion, String mediaTypeString, String producedTypeString) {
        try {
            MediaType mediaType = MediaType.valueOf((String)mediaTypeString);
            LockableMGraph contentGraph = this.cgProvider.getContentGraph();
            this.contentHandler.put(scriptUri, mediaType, scriptFileBytes);
            GraphNode scriptNode = new GraphNode((Resource)scriptUri, (TripleCollection)contentGraph);
            scriptNode.deleteProperties(DCTERMS.title);
            scriptNode.deleteProperties(SCRIPT.scriptLanguage);
            scriptNode.deleteProperties(SCRIPT.scriptLanguageVersion);
            scriptNode.deleteProperties(SCRIPT.producedType);
            scriptNode.addProperty(RDF.type, (Resource)SCRIPT.Script);
            scriptNode.addProperty(DCTERMS.title, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)scriptName));
            scriptNode.addProperty(SCRIPT.scriptLanguage, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)scriptLanguage));
            scriptNode.addProperty(SCRIPT.scriptLanguageVersion, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)scriptLanguageVersion));
            if (!producedTypeString.equals("")) {
                scriptNode.addProperty(SCRIPT.producedType, (Resource)LiteralFactory.getInstance().createTypedLiteral((Object)MediaType.valueOf((String)producedTypeString).toString()));
            }
        }
        catch (IllegalArgumentException ex) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getMessage()).build());
        }
    }

    private void deleteScript(UriRef scriptUri) {
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        this.contentHandler.remove((NonLiteral)scriptUri);
        GraphNode scriptNode = new GraphNode((Resource)scriptUri, (TripleCollection)contentGraph);
        scriptNode.deleteProperty(RDF.type, (Resource)SCRIPT.Script);
        scriptNode.deleteProperties(DCTERMS.title);
        scriptNode.deleteProperties(SCRIPT.scriptLanguage);
        scriptNode.deleteProperties(SCRIPT.scriptLanguageVersion);
        scriptNode.deleteProperties(SCRIPT.producedType);
    }

    private boolean saveExecutionUri(String scriptExecutionUri, UriRef scriptUri) {
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        if (!scriptExecutionUri.equals("")) {
            UriRef generatedResourceUri = new UriRef(scriptExecutionUri);
            if (!contentGraph.filter((NonLiteral)generatedResourceUri, RDF.type, (Resource)SCRIPT.ScriptGeneratedResource).hasNext()) {
                GraphNode generatedResourceNode = new GraphNode((Resource)generatedResourceUri, (TripleCollection)contentGraph);
                generatedResourceNode.addProperty(RDF.type, (Resource)SCRIPT.ScriptGeneratedResource);
                generatedResourceNode.addProperty(SCRIPT.scriptSource, (Resource)scriptUri);
            } else {
                return false;
            }
        }
        return true;
    }

    private void deleteExecutionUri(NonLiteral scriptGeneratedResource, UriRef scriptUri) {
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        GraphNode generatedResourceNode = new GraphNode((Resource)scriptGeneratedResource, (TripleCollection)contentGraph);
        generatedResourceNode.deleteProperty(RDF.type, (Resource)SCRIPT.ScriptGeneratedResource);
        generatedResourceNode.deleteProperty(SCRIPT.scriptSource, (Resource)scriptUri);
    }

    private ScriptLanguageDescription extractLanguageAndVersion(String str) {
        int begin = str.indexOf(" (");
        int end = str.lastIndexOf(41);
        String scriptLanguage = str.substring(0, begin);
        String scriptLanguageVersion = str.substring(begin + 2, end);
        return new ScriptLanguageDescription(scriptLanguage, scriptLanguageVersion);
    }

    @GET
    @Path(value="execution-uri-overview")
    public GraphNode getExecutionUriOverview() {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        BNode resultResource = new BNode();
        SimpleMGraph resultGraph = new SimpleMGraph();
        resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, RDF.type, (Resource)PLATFORM.HeadedPage));
        resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, RDF.type, (Resource)SCRIPTMANAGER.ExecutionUriOverviewPage));
        GraphNode scriptList = this.getScriptList((NonLiteral)resultResource);
        UnionMGraph unionGraph = new UnionMGraph(new TripleCollection[]{resultGraph, scriptList.getGraph(), contentGraph});
        return new GraphNode((Resource)resultResource, (TripleCollection)unionGraph);
    }

    @GET
    @Path(value="get-execution-uri")
    @Produces(value={"text/plain"})
    public GraphNode getExecutionUris(@QueryParam(value="script") UriRef script) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        BNode resultResource = new BNode();
        SimpleMGraph resultGraph = new SimpleMGraph();
        Iterator<NonLiteral> executionUris = this.getScriptGeneratedResources((NonLiteral)script).iterator();
        while (executionUris.hasNext()) {
            resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, SCRIPTMANAGER.executionUri, (Resource)executionUris.next()));
        }
        resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, SCRIPTMANAGER.script, (Resource)script));
        resultGraph.add((Object)new TripleImpl((NonLiteral)resultResource, RDF.type, (Resource)SCRIPTMANAGER.ExecutionUriList));
        return new GraphNode((Resource)resultResource, (TripleCollection)new UnionMGraph(new TripleCollection[]{resultGraph, this.cgProvider.getContentGraph()}));
    }

    @POST
    @Path(value="add-execution-uri")
    public Response addExecutionUri(@FormParam(value="scriptUri") UriRef scriptUri, @FormParam(value="executionUri") String generatedResourceUri, @Context UriInfo uriInfo) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        if (!this.saveExecutionUri(generatedResourceUri, scriptUri)) {
            this.logger.warn("Execution URI {} already used.", (Object)generatedResourceUri);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return RedirectUtil.createSeeOtherResponse((String)"execution-uri-overview", (UriInfo)uriInfo);
    }

    @POST
    @Path(value="delete-executionUri")
    public Response deleteExecutionUri(@FormParam(value="scriptUri") UriRef scriptUri, @FormParam(value="executionUri") UriRef generatedResourceUri) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        this.deleteExecutionUri((NonLiteral)generatedResourceUri, scriptUri);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private Set<NonLiteral> getScriptGeneratedResources(NonLiteral scriptResource) {
        LockableMGraph contentGraph = this.cgProvider.getContentGraph();
        Iterator it = contentGraph.filter(null, SCRIPT.scriptSource, (Resource)scriptResource);
        HashSet<NonLiteral> resources = new HashSet<NonLiteral>();
        while (it.hasNext()) {
            resources.add(((Triple)it.next()).getSubject());
        }
        return resources;
    }

    @GET
    @Path(value="execute")
    public Object executeScript(@QueryParam(value="script") String script) {
        AccessController.checkPermission(new ScriptManagerAppPermission());
        try {
            return this.scriptExecution.execute((NonLiteral)new UriRef(script));
        }
        catch (NoEngineException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        catch (ScriptException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Exception executing script: ");
            if (ex.getLineNumber() != -1 || ex.getColumnNumber() != -1) {
                pw.print("at line number" + ex.getLineNumber() + " ");
                pw.print("at column number" + ex.getColumnNumber() + ": ");
            }
            pw.println(ex.getMessage());
            ex.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }
    }

    @GET
    @Path(value="{path:.+}")
    public PathNode getStaticFile(@PathParam(value="path") String path) {
        PathNode node = this.fileServer.getNode(path);
        this.logger.debug("Serving static {}", (Object)node);
        return node;
    }

    public Set<GlobalMenuItem> getMenuItems() {
        HashSet<GlobalMenuItem> items = new HashSet<GlobalMenuItem>();
        try {
            AccessController.checkPermission((Permission)new TcPermission("urn:x-localinstance:/content.graph", "readwrite"));
            AccessController.checkPermission(new ScriptManagerAppPermission());
        }
        catch (AccessControlException e) {
            return items;
        }
        items.add(new GlobalMenuItem("/admin/scripting/", "SCM", "Scripting", 1, "Development"));
        return items;
    }

    protected void bindRenderletManager(RenderletManager renderletManager) {
        this.renderletManager = renderletManager;
    }

    protected void unbindRenderletManager(RenderletManager renderletManager) {
        if (this.renderletManager == renderletManager) {
            this.renderletManager = null;
        }
    }

    protected void bindCgProvider(ContentGraphProvider contentGraphProvider) {
        this.cgProvider = contentGraphProvider;
    }

    protected void unbindCgProvider(ContentGraphProvider contentGraphProvider) {
        if (this.cgProvider == contentGraphProvider) {
            this.cgProvider = null;
        }
    }

    protected void bindContentHandler(DiscobitsHandler discobitsHandler) {
        this.contentHandler = discobitsHandler;
    }

    protected void unbindContentHandler(DiscobitsHandler discobitsHandler) {
        if (this.contentHandler == discobitsHandler) {
            this.contentHandler = null;
        }
    }

    protected void bindScriptExecution(ScriptExecution scriptExecution) {
        this.scriptExecution = scriptExecution;
    }

    protected void unbindScriptExecution(ScriptExecution scriptExecution) {
        if (this.scriptExecution == scriptExecution) {
            this.scriptExecution = null;
        }
    }
}

