/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.imageprocessing;

import java.awt.Color;
import java.awt.image.BufferedImage;

public abstract class ImageProcessor {
    public abstract BufferedImage makeImageTranslucent(BufferedImage var1, float var2);

    public abstract BufferedImage makeColorTransparent(BufferedImage var1, Color var2);

    public abstract BufferedImage flip(BufferedImage var1, int var2);

    public abstract BufferedImage rotate(BufferedImage var1, int var2);

    public abstract BufferedImage resize(BufferedImage var1, int var2, int var3);

    public abstract BufferedImage resizeProportional(BufferedImage var1, int var2, int var3);

    public abstract BufferedImage resizeRelative(BufferedImage var1, float var2, float var3);

    public abstract BufferedImage resizeRelativeProportional(BufferedImage var1, float var2);

    public BufferedImage makeAThumbnail(BufferedImage image, int width, int height) {
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        if (imgWidth <= width && imgHeight <= height) {
            return image;
        }
        float propWidth = (float)width / (float)imgWidth;
        float propHeight = (float)height / (float)imgHeight;
        float factor = propWidth < propHeight ? propWidth : propHeight;
        BufferedImage img = this.resizeRelativeProportional(image, factor);
        return img;
    }
}

