/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.imageprocessing;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.clerezza.utils.imageprocessing.ImageReader;
import org.osgi.service.component.ComponentContext;

public class ImageReaderService
implements ImageReader {
    private ComponentContext componentContext;

    public ImageReader getImageReader() {
        if (this.componentContext != null) {
            ImageReader ret = (ImageReader)this.componentContext.locateService("imageReaders");
            return ret;
        }
        throw new RuntimeException(String.format("%s is not initialized correctly.", ImageReaderService.class.getSimpleName()));
    }

    @Override
    public BufferedImage getBufferedImage(File file) throws IOException {
        return this.getImageReader().getBufferedImage(file);
    }

    @Override
    public BufferedImage getBufferedImage(InputStream in) throws IOException {
        return this.getImageReader().getBufferedImage(in);
    }

    @Override
    public BufferedImage getBufferedImage(URL url) throws IOException {
        return this.getImageReader().getBufferedImage(url);
    }

    protected void activate(ComponentContext context) {
        this.componentContext = context;
    }

    protected void deactivate(ComponentContext context) {
        this.componentContext = null;
    }
}

