/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.imageprocessing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import org.apache.clerezza.utils.imageprocessing.ImageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaGraphicsProvider
extends ImageProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public BufferedImage makeImageTranslucent(BufferedImage image, float translucency) {
        BufferedImage img = new BufferedImage(image.getWidth(), image.getHeight(), 3);
        Graphics2D g2D = img.createGraphics();
        g2D.setComposite(AlphaComposite.getInstance(3, translucency));
        g2D.drawImage(image, null, 0, 0);
        g2D.dispose();
        return img;
    }

    @Override
    public BufferedImage makeColorTransparent(BufferedImage image, Color color) {
        BufferedImage img = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2D = img.createGraphics();
        g2D.setComposite(AlphaComposite.Src);
        g2D.drawImage(image, null, 0, 0);
        g2D.dispose();
        for (int i = 0; i < img.getHeight(); ++i) {
            for (int j = 0; j < img.getWidth(); ++j) {
                if (img.getRGB(j, i) != color.getRGB()) continue;
                img.setRGB(j, i, 9378844);
            }
        }
        return img;
    }

    @Override
    public BufferedImage flip(BufferedImage image, int direction) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage img = new BufferedImage(width, height, this.getType(image));
        Graphics2D g2D = img.createGraphics();
        if (direction == 0) {
            g2D.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        } else {
            g2D.drawImage(image, 0, 0, width, height, 0, height, width, 0, null);
        }
        g2D.dispose();
        return img;
    }

    private int getType(BufferedImage image) {
        if (image.getType() != 0) {
            return image.getType();
        }
        ColorModel imageColorModel = image.getColorModel();
        Class<?> imageColorModelClass = imageColorModel.getClass();
        int imageColorSpaceType = imageColorModel.getColorSpace().getType();
        switch (image.getSampleModel().getDataType()) {
            case 0: {
                switch (imageColorModel.getPixelSize()) {
                    case 1: 
                    case 2: 
                    case 4: {
                        if (IndexColorModel.class.isAssignableFrom(imageColorModelClass)) {
                            return 12;
                        }
                        this.logger.debug("Unsupported 1-, 2-, or 4-bit type for data type TYPE_BYTE");
                        return 0;
                    }
                    case 8: {
                        if (ComponentColorModel.class.isAssignableFrom(imageColorModelClass) && imageColorSpaceType == 6) {
                            return 10;
                        }
                        if (IndexColorModel.class.isAssignableFrom(imageColorModelClass)) {
                            return 13;
                        }
                        this.logger.debug("Unsupported 1-byte type for data type TYPE_BYTE");
                        return 0;
                    }
                    case 24: {
                        if (ComponentColorModel.class.isAssignableFrom(imageColorModelClass) && imageColorSpaceType == 5 && !imageColorModel.hasAlpha()) {
                            return 5;
                        }
                        this.logger.debug("Unsupported 3-byte type for data type TYPE_BYTE");
                        return 0;
                    }
                    case 32: {
                        if (ComponentColorModel.class.isAssignableFrom(imageColorModelClass) && imageColorSpaceType == 5 && imageColorModel.hasAlpha()) {
                            if (imageColorModel.isAlphaPremultiplied()) {
                                return 7;
                            }
                            return 6;
                        }
                        this.logger.debug("Unsupported 4-byte type for data type TYPE_BYTE");
                        return 0;
                    }
                }
                this.logger.debug("Unsupported pixel size for data type TYPE_BYTE");
                return 0;
            }
            case 1: {
                switch (imageColorModel.getPixelSize()) {
                    case 16: {
                        if (ComponentColorModel.class.isAssignableFrom(imageColorModelClass) && imageColorSpaceType == 6) {
                            return 11;
                        }
                        this.logger.debug("Unsupported 2-byte type for data type TYPE_USHORT");
                        return 0;
                    }
                    case 32: {
                        if (DirectColorModel.class.isAssignableFrom(imageColorModelClass) && imageColorSpaceType == 5 && !imageColorModel.hasAlpha()) {
                            int[] componentSize = imageColorModel.getComponentSize();
                            if (componentSize[1] == 5) {
                                return 9;
                            }
                            if (componentSize[1] == 6) {
                                return 8;
                            }
                        }
                        this.logger.debug("Unsupported 4-byte type for data type TYPE_USHORT");
                        return 0;
                    }
                }
                this.logger.debug("Unsupported pixel size for data type TYPE_USHORT");
                return 0;
            }
            case 3: {
                if (DirectColorModel.class.isAssignableFrom(imageColorModelClass) && imageColorModel.hasAlpha()) {
                    if (image.getColorModel().isAlphaPremultiplied()) {
                        return 3;
                    }
                    return 2;
                }
                if (PackedColorModel.class.isAssignableFrom(imageColorModelClass) && !imageColorModel.hasAlpha()) {
                    PackedColorModel pcm = (PackedColorModel)imageColorModel;
                    int[] masks = pcm.getMasks();
                    if (masks[0] == 255) {
                        return 4;
                    }
                    return 1;
                }
                this.logger.debug("Unsupported type for data type TYPE_INT");
                return 0;
            }
        }
        this.logger.debug("Unsupported data type of sample model");
        return 0;
    }

    @Override
    public BufferedImage rotate(BufferedImage image, int angle) {
        int width = image.getWidth();
        int height = image.getHeight();
        if (Math.abs(angle) == 90 || Math.abs(angle) == 270) {
            int tempH = height;
            height = width;
            width = tempH;
        }
        BufferedImage img = new BufferedImage(width, height, this.getType(image));
        Graphics2D g2D = img.createGraphics();
        g2D.rotate(Math.toRadians(angle), width >>> 1, height >>> 1);
        g2D.drawImage(image, null, (width >>> 1) - (image.getWidth() >>> 1), (height >>> 1) - (image.getHeight() >>> 1));
        g2D.dispose();
        return img;
    }

    @Override
    public BufferedImage resize(BufferedImage image, int newWidth, int newHeight) {
        return this.resizeBufferedImage(image, newWidth, newHeight, image.getWidth(), image.getHeight());
    }

    private BufferedImage resizeBufferedImage(BufferedImage image, int newWidth, int newHeight, int width, int height) {
        BufferedImage img = new BufferedImage(newWidth, newHeight, this.getType(image));
        Graphics2D g2D = img.createGraphics();
        g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2D.drawImage(image, 0, 0, newWidth, newHeight, 0, 0, width, height, null);
        return img;
    }

    @Override
    public BufferedImage resizeProportional(BufferedImage image, int newWidth, int newHeight) {
        if (newWidth == 0 && newHeight == 0) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (newWidth != 0) {
            newHeight = (int)((float)height * (float)newWidth / (float)width);
        } else {
            newWidth = (int)((float)width * (float)newHeight / (float)height);
        }
        return this.resizeBufferedImage(image, newWidth, newHeight, width, height);
    }

    @Override
    public BufferedImage resizeRelative(BufferedImage image, float resizeFactorWidth, float resizeFactorHeight) {
        int width = image.getWidth();
        int height = image.getHeight();
        int newWidth = (int)((float)width * resizeFactorWidth);
        int newHeight = (int)((float)height * resizeFactorHeight);
        return this.resizeBufferedImage(image, newWidth, newHeight, width, height);
    }

    @Override
    public BufferedImage resizeRelativeProportional(BufferedImage image, float resizeFactor) {
        int width = image.getWidth();
        int height = image.getHeight();
        int newWidth = (int)((float)width * resizeFactor);
        int newHeight = (int)((float)height * resizeFactor);
        return this.resizeBufferedImage(image, newWidth, newHeight, width, height);
    }
}

