/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.imageprocessing.metadataprocessing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSet {
    static final HashMap<DataSetFormatPair, DataSetSerializer> conversionMap = new HashMap();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract String getValue();

    public abstract void set(String var1);

    public abstract String getKey();

    public String toString() {
        return "(" + this.getKey() + ") " + this.getValue();
    }

    static class DataSetSerializer
    extends DataSetFormatPair {
        DataSetSerializer(String key, String formatName) {
            super(key, formatName);
        }

        String serialize(List<? extends DataSet> dataSets) {
            String str = "";
            Iterator<? extends DataSet> it = dataSets.iterator();
            if (it.hasNext()) {
                str = str + it.next();
            }
            while (it.hasNext()) {
                str = str + ", " + it.next().getValue();
            }
            return str;
        }
    }

    static class DataSetFormatPair {
        final String key;
        final String formatName;

        DataSetFormatPair(String key, String formatName) {
            this.key = key;
            this.formatName = formatName;
        }

        public int hashCode() {
            return (this.key + this.formatName).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj.getClass().getName().equals(this.getClass().getName())) {
                DataSetFormatPair o = (DataSetFormatPair)obj;
                return this.key.equals(o.key) && this.formatName.equals(o.formatName);
            }
            return false;
        }
    }
}

