/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.imageprocessing.metadataprocessing;

import java.lang.reflect.Field;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.DataSet;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.XmpSchemaDefinitions;

public class ExifTagDataSet
extends DataSet {
    static final String EXIF_FORMAT_NAME = "EXIF";
    private final String tagName;
    private final int tagNumber;
    private String value;
    public static final int ExifVersion = 36864;
    public static final int FlashPixVersion = 40960;
    public static final int ColorSpace = 40961;
    public static final int ComponentsConfiguration = 37121;
    public static final int CompressedBitsPerPixel = 37122;
    public static final int PixelXDimension = 40962;
    public static final int PixelYDimension = 40963;
    public static final int MakerNote = 37500;
    public static final int UserComment = 37510;
    public static final int RelatedSoundFile = 40964;
    public static final int DateTimeOriginal = 36867;
    public static final int DateTimeDigitized = 36868;
    public static final int SubSecTime = 37520;
    public static final int SubSecTimeOriginal = 37521;
    public static final int SubSecTimeDigitized = 37522;
    public static final int ImageUniqueID = 42016;
    public static final int ExposureTime = 33434;
    public static final int FNumber = 33437;
    public static final int ExposureProgram = 34850;
    public static final int SpectralSensitivity = 34852;
    public static final int ISOSpeedRatings = 34855;
    public static final int OECF = 34856;
    public static final int ShutterSpeedValue = 37377;
    public static final int ApertureValue = 37378;
    public static final int BrightnessValue = 37379;
    public static final int ExposureBiasValue = 37380;
    public static final int MaxApertureValue = 37381;
    public static final int SubjectDistance = 37382;
    public static final int MeteringMode = 37383;
    public static final int LightSource = 37384;
    public static final int Flash = 37385;
    public static final int FocalLength = 37386;
    public static final int SubjectArea = 37396;
    public static final int FlashEnergy = 41483;
    public static final int SpatialFrequencyResponse = 41484;
    public static final int FocalPlaneXResolution = 41486;
    public static final int FocalPlaneYResolution = 41487;
    public static final int FocalPlaneResolutionUnit = 41488;
    public static final int SubjectLocation = 41492;
    public static final int ExposureIndex = 41493;
    public static final int SensingMethod = 41495;
    public static final int FileSource = 41728;
    public static final int SceneType = 41729;
    public static final int CFAPattern = 41730;
    public static final int CustomRendered = 41985;
    public static final int ExposureMode = 41986;
    public static final int WhiteBalance = 41987;
    public static final int DigitalZoomRatio = 41988;
    public static final int FocalLengthIn35mmFilm = 41989;
    public static final int SceneCaptureType = 41990;
    public static final int GainControl = 41991;
    public static final int Contrast = 41992;
    public static final int Saturation = 41993;
    public static final int Sharpness = 41994;
    public static final int DeviceSettingDescription = 41995;
    public static final int SubjectDistanceRange = 41996;
    public static final int ImageWidth = 256;
    public static final int ImageLength = 257;
    public static final int BitsPerSample = 258;
    public static final int Compression = 259;
    public static final int PhotometricInterpretation = 262;
    public static final int ImageDescription = 270;
    public static final int Make = 271;
    public static final int Model = 272;
    public static final int StripOffsets = 273;
    public static final int Orientation = 274;
    public static final int SamplesPerPixel = 277;
    public static final int RowsPerStrip = 278;
    public static final int StripByteCounts = 279;
    public static final int XResolution = 282;
    public static final int YResolution = 283;
    public static final int PlanarConfiguration = 284;
    public static final int ResolutionUnit = 296;
    public static final int TransferFunction = 301;
    public static final int Software = 305;
    public static final int DateTime = 306;
    public static final int Artist = 315;
    public static final int WhitePoint = 318;
    public static final int PrimaryChromaticities = 319;
    public static final int JPEGInterchangeFormat = 513;
    public static final int JPEGInterchangeFormatLength = 514;
    public static final int YCbCrCoefficients = 529;
    public static final int YCbCrSubSampling = 530;
    public static final int YCbCrPositioning = 531;
    public static final int ReferenceBlackWhite = 532;
    public static final int Copyright = 33432;
    public static final int GPSVersionID = 0;
    public static final int GPSLatitudeRef = 1;
    public static final int GPSLatitude = 2;
    public static final int GPSLongitudeRef = 3;
    public static final int GPSLongitude = 4;
    public static final int GPSAltitudeRef = 5;
    public static final int GPSAltitude = 6;
    public static final int GPSTimeStamp = 7;
    public static final int GPSSatellites = 8;
    public static final int GPSStatus = 9;
    public static final int GPSMeasureMode = 10;
    public static final int GPSDOP = 11;
    public static final int GPSSpeedRef = 12;
    public static final int GPSSpeed = 13;
    public static final int GPSTrackRef = 14;
    public static final int GPSTrack = 15;
    public static final int GPSImgDirectionRef = 16;
    public static final int GPSImgDirection = 17;
    public static final int GPSMapDatum = 18;
    public static final int GPSDestLatitudeRef = 19;
    public static final int GPSDestLatitude = 20;
    public static final int GPSDestLongitudeRef = 21;
    public static final int GPSDestLongitude = 22;
    public static final int GPSDestBearingRef = 23;
    public static final int GPSDestBearing = 24;
    public static final int GPSDestDistanceRef = 25;
    public static final int GPSDestDistance = 26;

    public ExifTagDataSet(String tagName, String value) throws NoSuchFieldException {
        this.tagName = tagName;
        this.value = value;
        this.tagNumber = this.extractTagNumber(tagName);
    }

    public ExifTagDataSet(int tagNumber, String value) {
        this.tagNumber = tagNumber;
        this.value = value;
        this.tagName = this.extractTagName(tagNumber);
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    @Override
    public String getKey() {
        return String.valueOf(this.tagNumber);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void set(String value) {
        this.value = value;
    }

    private int extractTagNumber(String tagName) throws NoSuchFieldException {
        int tagNumber = -1;
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(tagName)) continue;
            try {
                tagNumber = field.getInt(null);
                break;
            }
            catch (RuntimeException ex) {
                this.logger.info("Can't create EXIF data set with tag name \"{}\"", (Object)tagName);
                throw ex;
            }
            catch (IllegalAccessException ex) {
                this.logger.info("Can't create EXIF data set with tag name \"{}\"", (Object)tagName);
                throw new RuntimeException(ex);
            }
        }
        if (tagNumber == -1) {
            throw new NoSuchFieldException("There is no field with name: " + tagName);
        }
        return tagNumber;
    }

    private String extractTagName(int value) {
        String name = "";
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.getType().getName().equals(Integer.TYPE.getName())) continue;
            try {
                if (field.getInt(null) != value) continue;
                name = field.getName();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return name;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass().equals(other.getClass())) {
            ExifTagDataSet o = (ExifTagDataSet)other;
            return o.tagName.equals(this.tagName) && o.value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return (this.tagName + this.value).hashCode();
    }

    static {
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(36864), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifVersion);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(40960), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFlashpixVersion);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(40961), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifColorSpace);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37121), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifComponentsConfiguration);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37122), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifCompressedBitsPerPixel);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(40962), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifPixelXDimension);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(40963), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifPixelYDimension);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37510), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifUserComment);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(40964), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifRelatedSoundFile);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(36867), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifDateTimeOriginal);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(36868), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifDateTimeDigitized);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(42016), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifImageUniqueID);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(33434), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifExposureTime);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(33437), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFNumber);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(34850), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifExposureProgram);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(34852), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSpectralSensitivity);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(34855), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifISOSpeedRatings);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(34856), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifOECF);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37377), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifShutterSpeedValue);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37378), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifApertureValue);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37379), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifBrightnessValue);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37380), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifExposureBiasValue);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37381), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifMaxApertureValue);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37382), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSubjectDistance);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37383), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifMeteringMode);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37384), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifLightSource);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37385), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFlash);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37386), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFocalLength);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(37396), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSubjectArea);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41483), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFlashEnergy);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41484), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSpatialFrequencyResponse);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41486), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFocalPlaneXResolution);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41487), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFocalPlaneYResolution);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41488), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFocalPlaneResolutionUnit);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41492), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSubjectLocation);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41493), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifExposureIndex);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41495), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSensingMethod);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41728), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFileSource);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41729), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSceneType);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41730), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifCFAPattern);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41985), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifCustomRendered);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41986), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifExposureMode);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41987), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifWhiteBalance);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41988), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifDigitalZoomRatio);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41989), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifFocalLengthIn35mmFilm);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41990), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSceneCaptureType);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41991), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGainControl);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41992), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifContrast);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41993), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSaturation);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41994), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSharpness);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41995), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifDeviceSettingDescription);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(41996), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifSubjectDistanceRange);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(256), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffImageWidth);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(257), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffImageLength);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(258), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffBitsPerSample);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(259), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffCompression);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(262), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffPhotometricInterpretation);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(270), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffImageDescription);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(271), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffMake);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(272), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffModel);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(282), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffXResolution);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(283), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffYResolution);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(284), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffPlanarConfiguration);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(296), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffResolutionUnit);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(301), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffTransferFunction);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(305), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffSoftware);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(306), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffDateTime);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(315), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffArtist);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(318), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffWhitePoint);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(319), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffPrimaryChromaticities);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(529), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffYCbCrCoefficients);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(530), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffYCbCrSubSampling);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(531), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffYCbCrPositioning);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(532), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffReferenceBlackWhite);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(33432), EXIF_FORMAT_NAME), XmpSchemaDefinitions.TiffCopyright);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(0), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSVersionID);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(2), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSLatitude);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(4), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSLongitude);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(5), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSAltitudeRef);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(6), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSAltitude);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(7), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSTimeStamp);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(8), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSSatellites);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(9), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSStatus);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(10), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSMeasureMode);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(11), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSDOP);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(12), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSSpeedRef);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(13), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSSpeed);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(14), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSTrackRef);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(15), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSTrack);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(16), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSImgDirectionRef);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(17), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSImgDirection);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(18), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSMapDatum);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(20), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSDestLatitude);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(22), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSDestLongitude);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(23), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSDestBearingRef);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(24), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSDestBearing);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(25), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSDestDistanceRef);
        conversionMap.put(new DataSet.DataSetFormatPair(String.valueOf(26), EXIF_FORMAT_NAME), XmpSchemaDefinitions.ExifGPSDestDistance);
    }
}

