/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.imageprocessing.metadataprocessing;

import java.lang.reflect.Field;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.DataSet;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.XmpSchemaDefinitions;

public class IptcDataSet
extends DataSet {
    static final String IPTC_FORMAT_NAME = "IPTC";
    private final int recordNumber;
    private final int dataSetNumber;
    private final String dataSetName;
    private String value;
    public static final String RECORD_VERSION = "2:0";
    public static final String OBJECT_TYPE_REFERENCE = "2:3";
    public static final String OBJECT_ATTRIBUTE_REFERENCE = "2:4";
    public static final String OBJECT_NAME = "2:5";
    public static final String EDIT_STATUS = "2:7";
    public static final String EDITORIAL_UPDATE = "2:8";
    public static final String URGENCY = "2:10";
    public static final String SUBJECT_REFERENCE = "2:12";
    public static final String CATEGORY = "2:15";
    public static final String SUPPLEMENTAL_CATEGORY = "2:20";
    public static final String FIXTURE_IDENTIFIER = "2:22";
    public static final String KEYWORDS = "2:25";
    public static final String CONTENT_LOCATION_CODE = "2:26";
    public static final String CONTENT_LOCATION_NAME = "2:27";
    public static final String RELEASE_DATE = "2:30";
    public static final String RELEASE_TIME = "2:35";
    public static final String EXPIRATION_DATE = "2:37";
    public static final String EXPIRATION_TIME = "2:38";
    public static final String SPECIAL_INSTRUCTIONS = "2:40";
    public static final String ACTION_ADVISED = "2:42";
    public static final String REFERENCE_SERVICE = "2:45";
    public static final String REFERENCE_DATE = "2:47";
    public static final String REFERENCE_NUMBER = "2:50";
    public static final String DATE_CREATED = "2:55";
    public static final String TIME_CREATED = "2:60";
    public static final String DIGITAL_CREATION_DATE = "2:62";
    public static final String DIGITAL_CREATION_TIME = "2:63";
    public static final String ORIGINATING_PROGRAM = "2:65";
    public static final String PROGRAM_VERSION = "2:70";
    public static final String OBJECT_CYCLE = "2:75";
    public static final String BY_LINE = "2:80";
    public static final String BY_LINE_TITLE = "2:85";
    public static final String CITY = "2:90";
    public static final String SUB_LOCATION = "2:92";
    public static final String PROVINCE = "2:95";
    public static final String COUNTRY_CODE = "2:100";
    public static final String COUNTRY_NAME = "2:101";
    public static final String ORIGINAL_TRANSMISSION_REFERENCE = "2:103";
    public static final String HEADLINE = "2:105";
    public static final String CREDIT = "2:110";
    public static final String SOURCE = "2:115";
    public static final String COPYRIGHT_NOTICE = "2:116";
    public static final String CONTACT = "2:118";
    public static final String CAPTION = "2:120";
    public static final String EDITOR = "2:122";
    public static final String RASTERIZED_CAPTION = "2:125";
    public static final String IMAGE_TYPE = "2:130";
    public static final String IMAGE_ORIENTATION = "2:131";
    public static final String LANGUAGE_IDENTIFIER = "2:135";
    public static final String AUDIO_TYPE = "2:150";
    public static final String AUDIO_SAMPLING_RATE = "2:151";
    public static final String AUDIO_SAMPLING_RESOLUTION = "2:152";
    public static final String AUDIO_DURATION = "2:153";
    public static final String AUDIO_OUTCUE = "2:154";
    public static final String OBJECTDATA_PREVIEW_FILE_FORMAT = "2:200";
    public static final String OBJECTDATA_PREVIEW_FILE_FORMAT_VERSION = "2:201";
    public static final String OBJECTDATA_PREVIEW_DATA = "2:202";

    public IptcDataSet(int recordNumber, int dataSetNumber, String value) {
        this(recordNumber + ":" + dataSetNumber, value);
    }

    public IptcDataSet(String key, String value) {
        String[] sa = key.split(":");
        this.recordNumber = Integer.parseInt(sa[0]);
        this.dataSetNumber = Integer.parseInt(sa[1]);
        this.dataSetName = this.extractDataSetName(this.getKey());
        this.value = value;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public int getDataSetNumber() {
        return this.dataSetNumber;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    private String extractDataSetName(String value) {
        String name = "";
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.getType().getName().equals(String.class.getName())) continue;
            try {
                if (!field.get(null).equals(value)) continue;
                String[] sa = field.getName().split("_");
                for (int j = 0; j < sa.length; ++j) {
                    if (j > 0) {
                        name = name + " ";
                    }
                    name = name + sa[j].substring(0, 1);
                    name = name + sa[j].substring(1).toLowerCase();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void set(String value) {
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.recordNumber + ":" + this.dataSetNumber;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass().equals(other.getClass())) {
            IptcDataSet o = (IptcDataSet)other;
            return o.recordNumber == this.recordNumber && o.dataSetNumber == this.dataSetNumber && o.value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    static {
        conversionMap.put(new DataSet.DataSetFormatPair(OBJECT_ATTRIBUTE_REFERENCE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.Iptc4XmpCoreIntellectualGenre);
        conversionMap.put(new DataSet.DataSetFormatPair(OBJECT_NAME, IPTC_FORMAT_NAME), XmpSchemaDefinitions.DcTitle);
        conversionMap.put(new DataSet.DataSetFormatPair(URGENCY, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopUrgency);
        conversionMap.put(new DataSet.DataSetFormatPair(SUBJECT_REFERENCE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.Iptc4XmpCoreSubjectCode);
        conversionMap.put(new DataSet.DataSetFormatPair(CATEGORY, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopCategory);
        conversionMap.put(new DataSet.DataSetFormatPair(SUPPLEMENTAL_CATEGORY, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopSupplementalCategories);
        conversionMap.put(new DataSet.DataSetFormatPair(KEYWORDS, IPTC_FORMAT_NAME), XmpSchemaDefinitions.DcSubject);
        conversionMap.put(new DataSet.DataSetFormatPair(SPECIAL_INSTRUCTIONS, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopInstructions);
        conversionMap.put(new DataSet.DataSetFormatPair(DATE_CREATED, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopDateCreated);
        conversionMap.put(new DataSet.DataSetFormatPair(BY_LINE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.DcCreator);
        conversionMap.put(new DataSet.DataSetFormatPair(BY_LINE_TITLE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopAuthorsPosition);
        conversionMap.put(new DataSet.DataSetFormatPair(CITY, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopCity);
        conversionMap.put(new DataSet.DataSetFormatPair(SUB_LOCATION, IPTC_FORMAT_NAME), XmpSchemaDefinitions.Iptc4XmpCoreLocation);
        conversionMap.put(new DataSet.DataSetFormatPair(PROVINCE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopState);
        conversionMap.put(new DataSet.DataSetFormatPair(COUNTRY_CODE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.Iptc4XmpCoreCountryCode);
        conversionMap.put(new DataSet.DataSetFormatPair(COUNTRY_NAME, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopCountry);
        conversionMap.put(new DataSet.DataSetFormatPair(ORIGINAL_TRANSMISSION_REFERENCE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopTransmissionReference);
        conversionMap.put(new DataSet.DataSetFormatPair(HEADLINE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopHeadline);
        conversionMap.put(new DataSet.DataSetFormatPair(CREDIT, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopCredit);
        conversionMap.put(new DataSet.DataSetFormatPair(SOURCE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopSource);
        conversionMap.put(new DataSet.DataSetFormatPair(COPYRIGHT_NOTICE, IPTC_FORMAT_NAME), XmpSchemaDefinitions.DcRights);
        conversionMap.put(new DataSet.DataSetFormatPair(CONTACT, IPTC_FORMAT_NAME), XmpSchemaDefinitions.Iptc4XmpCoreContactInfoDetails);
        conversionMap.put(new DataSet.DataSetFormatPair(CAPTION, IPTC_FORMAT_NAME), XmpSchemaDefinitions.DcDescription);
        conversionMap.put(new DataSet.DataSetFormatPair(EDITOR, IPTC_FORMAT_NAME), XmpSchemaDefinitions.PhotoshopCaptionWriter);
    }
}

