/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.imageprocessing.metadataprocessing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.serializedform.Parser;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.DataSet;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.ExifTagDataSet;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.IptcDataSet;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.MetaData;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.MultivaluedMapImpl;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.XmpSchemaDefinitions;

public abstract class MetaDataUtils {
    public static TripleCollection convertIptcToXmp(MetaData<IptcDataSet> metaData) {
        return MetaDataUtils.convertToXMP(metaData, "IPTC");
    }

    public static TripleCollection convertExifToXmp(MetaData<ExifTagDataSet> metaData) {
        return MetaDataUtils.convertToXMP(metaData, "EXIF");
    }

    private static TripleCollection convertToXMP(MetaData<? extends DataSet> metaData, String formatName) {
        MultivaluedMapImpl<String, String> nameSpaceClusters = new MultivaluedMapImpl<String, String>();
        for (List<? extends DataSet> list : metaData) {
            DataSet.DataSetFormatPair key = new DataSet.DataSetFormatPair(list.get(0).getKey(), formatName);
            if (!DataSet.conversionMap.containsKey(key)) continue;
            DataSet.DataSetSerializer xmpSerializer = DataSet.conversionMap.get(key);
            nameSpaceClusters.add(xmpSerializer.key, xmpSerializer.serialize(metaData.get(list.get(0).getKey())));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>");
        for (Map.Entry<String, String> entry : XmpSchemaDefinitions.uriToNameSpacePrefix.entrySet()) {
            if (!nameSpaceClusters.containsKey(entry.getKey())) continue;
            sb.append("<rdf:Description rdf:about='' xmlns:" + entry.getValue() + "='" + entry.getKey() + "'>");
            Iterator i$ = nameSpaceClusters.get(entry.getKey()).iterator();
            while (i$.hasNext()) {
                String serializedString = (String)i$.next();
                sb.append(serializedString);
            }
            sb.append("</rdf:Description>");
        }
        sb.append("</rdf:RDF>");
        return Parser.getInstance().parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()), "application/rdf+xml");
    }
}

