/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils.imageprocessing.metadataprocessing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.clerezza.utils.imageprocessing.metadataprocessing.DataSet;

final class XmpSchemaDefinitions {
    private static final String DC_NS_URI = "http://purl.org/dc/elements/1.1/";
    private static final String XMP_NS_URI = "http://ns.adobe.com/xap/1.0/";
    private static final String XMPIDQ_NS_URI = "http://ns.adobe.com/xmp/Identifier/qual/1.0/";
    private static final String XMPRIGHTS_NS_URI = "http://ns.adobe.com/xap/1.0/rights/";
    private static final String XMPMM_NS_URI = "http://ns.adobe.com/xap/1.0/mm/";
    private static final String XMPBJ_NS_URI = "http://ns.adobe.com/xap/1.0/bj/";
    private static final String XMPTPG_NS_URI = "http://ns.adobe.com/xap/1.0/t/pg/";
    private static final String XMPDM_NS_URI = "http://ns.adobe.com/xmp/1.0/DynamicMedia/";
    private static final String PDF_NS_URI = "http://ns.adobe.com/pdf/1.3/";
    private static final String PHOTOSHOP_NS_URI = "http://ns.adobe.com/photoshop/1.0/";
    private static final String CRS_NS_URI = "http://ns.adobe.com/camera-raw-settings/1.0/";
    private static final String TIFF_NS_URI = "http://ns.adobe.com/tiff/1.0/";
    private static final String EXIF_NS_URI = "http://ns.adobe.com/exif/1.0/";
    private static final String AUX_NS_URI = "http://ns.adobe.com/exif/1.0/aux/";
    private static final String IPTC_4_XMP_CORE_NS_URI = "http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/";
    private static final String IPTC_4_XMP_EXT_NS_URI = "http://iptc.org/std/Iptc4xmpExt/2008-02-29/";
    static HashMap<String, String> uriToNameSpacePrefix = new HashMap();
    static DataSet.DataSetSerializer DcContributor;
    static DataSet.DataSetSerializer DcCoverage;
    static DataSet.DataSetSerializer DcCreator;
    static DataSet.DataSetSerializer DcDate;
    static DataSet.DataSetSerializer DcDescription;
    static DataSet.DataSetSerializer DcFormat;
    static DataSet.DataSetSerializer DcIdentifier;
    static DataSet.DataSetSerializer DcLanguage;
    static DataSet.DataSetSerializer DcPublisher;
    static DataSet.DataSetSerializer DcRelation;
    static DataSet.DataSetSerializer DcRights;
    static DataSet.DataSetSerializer DcSource;
    static DataSet.DataSetSerializer DcSubject;
    static DataSet.DataSetSerializer DcTitle;
    static DataSet.DataSetSerializer DcType;
    static DataSet.DataSetSerializer XmpAdvisory;
    static DataSet.DataSetSerializer XmpBaseUrl;
    static DataSet.DataSetSerializer XmpCreateDate;
    static DataSet.DataSetSerializer XmpCreatorTool;
    static DataSet.DataSetSerializer XmpIdentifier;
    static DataSet.DataSetSerializer XmpLabel;
    static DataSet.DataSetSerializer XmpMetadataDate;
    static DataSet.DataSetSerializer XmpModifyDate;
    static DataSet.DataSetSerializer XmpNickname;
    static DataSet.DataSetSerializer XmpRating;
    static DataSet.DataSetSerializer XmpThumbnails;
    static DataSet.DataSetSerializer XmpidqScheme;
    static DataSet.DataSetSerializer XmpRightsCertificate;
    static DataSet.DataSetSerializer XmpRightsMarked;
    static DataSet.DataSetSerializer XmpRightsOwner;
    static DataSet.DataSetSerializer XmpRightsUsageTerms;
    static DataSet.DataSetSerializer XmpRightsWebStatement;
    static DataSet.DataSetSerializer XmpMmDerivedFrom;
    static DataSet.DataSetSerializer XmpMmDocumentID;
    static DataSet.DataSetSerializer XmpMmHistory;
    static DataSet.DataSetSerializer XmpMmIngredients;
    static DataSet.DataSetSerializer XmpMmInstanceId;
    static DataSet.DataSetSerializer XmpMmManagedFrom;
    static DataSet.DataSetSerializer XmpMmManager;
    static DataSet.DataSetSerializer XmpMmManageTo;
    static DataSet.DataSetSerializer XmpMmManageUI;
    static DataSet.DataSetSerializer XmpMmManagerVariant;
    static DataSet.DataSetSerializer XmpMmOriginalDocumentId;
    static DataSet.DataSetSerializer XmpMmPantry;
    static DataSet.DataSetSerializer XmpMmRenditionClass;
    static DataSet.DataSetSerializer XmpMmRenditionParams;
    static DataSet.DataSetSerializer XmpMmVersionId;
    static DataSet.DataSetSerializer XmpMmVersions;
    @Deprecated
    static DataSet.DataSetSerializer XmpMmLastUrl;
    @Deprecated
    static DataSet.DataSetSerializer XmpMmRenditionOf;
    @Deprecated
    static DataSet.DataSetSerializer XmpMmSaveId;
    static DataSet.DataSetSerializer XmpBjJobRef;
    static DataSet.DataSetSerializer XmpTpgMaxPageSize;
    static DataSet.DataSetSerializer XmpTpgNPages;
    static DataSet.DataSetSerializer XmpTpgFonts;
    static DataSet.DataSetSerializer XmpTpgColorants;
    static DataSet.DataSetSerializer XmpTpgPlateNames;
    static DataSet.DataSetSerializer XmpDmAbsPeakAudioFilePath;
    static DataSet.DataSetSerializer XmpDmAlbum;
    static DataSet.DataSetSerializer XmpDmAltTapeName;
    static DataSet.DataSetSerializer XmpDmAltTimeCode;
    static DataSet.DataSetSerializer XmpDmArtist;
    static DataSet.DataSetSerializer XmpDmAudioModDate;
    static DataSet.DataSetSerializer XmpDmAudioSampleRate;
    static DataSet.DataSetSerializer XmpDmAudioSampleType;
    static DataSet.DataSetSerializer XmpDmAudioChannelType;
    static DataSet.DataSetSerializer XmpDmAudioCompressor;
    static DataSet.DataSetSerializer XmpDmBeatSpliceParams;
    static DataSet.DataSetSerializer XmpDmComposer;
    static DataSet.DataSetSerializer XmpDmContributedMedia;
    static DataSet.DataSetSerializer XmpDmCopyright;
    static DataSet.DataSetSerializer XmpDmDuration;
    static DataSet.DataSetSerializer XmpDmEngineer;
    static DataSet.DataSetSerializer XmpDmFileDataRate;
    static DataSet.DataSetSerializer XmpDmGenre;
    static DataSet.DataSetSerializer XmpDmInstrument;
    static DataSet.DataSetSerializer XmpDmIntroTime;
    static DataSet.DataSetSerializer XmpDmKey;
    static DataSet.DataSetSerializer XmpDmLongComment;
    static DataSet.DataSetSerializer XmpDmLoop;
    static DataSet.DataSetSerializer XmpDmNumberOfBeats;
    static DataSet.DataSetSerializer XmpDmMarkers;
    static DataSet.DataSetSerializer XmpDmMetadataModDate;
    static DataSet.DataSetSerializer XmpDmOutCue;
    static DataSet.DataSetSerializer XmpDmProjectRef;
    static DataSet.DataSetSerializer XmpDmPullDown;
    static DataSet.DataSetSerializer XmpDmRelativePeakAudioFilePath;
    static DataSet.DataSetSerializer XmpDmRelativeTimestamp;
    static DataSet.DataSetSerializer XmpDmReleaseDate;
    static DataSet.DataSetSerializer XmpDmResampleParams;
    static DataSet.DataSetSerializer XmpDmScaleType;
    static DataSet.DataSetSerializer XmpDmScene;
    static DataSet.DataSetSerializer XmpDmShotDate;
    static DataSet.DataSetSerializer XmpDmShotLocation;
    static DataSet.DataSetSerializer XmpDmShotName;
    static DataSet.DataSetSerializer XmpDmSpeakerPlacement;
    static DataSet.DataSetSerializer XmpDmStartTimecode;
    static DataSet.DataSetSerializer XmpDmStretchMode;
    static DataSet.DataSetSerializer XmpDmTapeName;
    static DataSet.DataSetSerializer XmpDmTempo;
    static DataSet.DataSetSerializer XmpDmTimeScaleParams;
    static DataSet.DataSetSerializer XmpDmTimeSignature;
    static DataSet.DataSetSerializer XmpDmTrackNumber;
    static DataSet.DataSetSerializer XmpDmTracks;
    static DataSet.DataSetSerializer XmpDmVideoAlphaMode;
    static DataSet.DataSetSerializer XmpDmVideoAlphaPremultipleColor;
    static DataSet.DataSetSerializer XmpDmVideoAlphaUnityIsTransparent;
    static DataSet.DataSetSerializer XmpDmVideoColorSpace;
    static DataSet.DataSetSerializer XmpDmVideoCompressor;
    static DataSet.DataSetSerializer XmpDmVideoFieldOrder;
    static DataSet.DataSetSerializer XmpDmVideoFrameRate;
    static DataSet.DataSetSerializer XmpDmVideoFrameSize;
    static DataSet.DataSetSerializer XmpDmVideoModDate;
    static DataSet.DataSetSerializer XmpDmVideoPixelDepth;
    static DataSet.DataSetSerializer XmpDmVideoPixelAspectRatio;
    static DataSet.DataSetSerializer PdfKeywords;
    static DataSet.DataSetSerializer PdfVersion;
    static DataSet.DataSetSerializer PdfProducer;
    static DataSet.DataSetSerializer PhotoshopAuthorsPosition;
    static DataSet.DataSetSerializer PhotoshopCaptionWriter;
    static DataSet.DataSetSerializer PhotoshopCategory;
    static DataSet.DataSetSerializer PhotoshopCity;
    static DataSet.DataSetSerializer PhotoshopCountry;
    static DataSet.DataSetSerializer PhotoshopCredit;
    static DataSet.DataSetSerializer PhotoshopDateCreated;
    static DataSet.DataSetSerializer PhotoshopHeadline;
    static DataSet.DataSetSerializer PhotoshopInstructions;
    static DataSet.DataSetSerializer PhotoshopSource;
    static DataSet.DataSetSerializer PhotoshopState;
    static DataSet.DataSetSerializer PhotoshopSupplementalCategories;
    static DataSet.DataSetSerializer PhotoshopTransmissionReference;
    static DataSet.DataSetSerializer PhotoshopUrgency;
    static DataSet.DataSetSerializer CrsAutoBrightness;
    static DataSet.DataSetSerializer CrsAutoContrast;
    static DataSet.DataSetSerializer CrsAutoExposure;
    static DataSet.DataSetSerializer CrsAutoShadows;
    static DataSet.DataSetSerializer CrsBlueHue;
    static DataSet.DataSetSerializer CrsBlueSaturation;
    static DataSet.DataSetSerializer CrsBrightness;
    static DataSet.DataSetSerializer CrsCameraProfile;
    static DataSet.DataSetSerializer CrsChromaticAberrationB;
    static DataSet.DataSetSerializer CrsChromaticAberrationR;
    static DataSet.DataSetSerializer CrsColorNoiseReduction;
    static DataSet.DataSetSerializer CrsContrast;
    static DataSet.DataSetSerializer CrsCropTop;
    static DataSet.DataSetSerializer CrsCropLeft;
    static DataSet.DataSetSerializer CrsCropBottom;
    static DataSet.DataSetSerializer CrsCropRight;
    static DataSet.DataSetSerializer CrsCropAngle;
    static DataSet.DataSetSerializer CrsCropWidth;
    static DataSet.DataSetSerializer CrsCropHeight;
    static DataSet.DataSetSerializer CrsCropUnits;
    static DataSet.DataSetSerializer CrsExposure;
    static DataSet.DataSetSerializer CrsGreenHue;
    static DataSet.DataSetSerializer CrsGreenSaturation;
    static DataSet.DataSetSerializer CrsHasCrop;
    static DataSet.DataSetSerializer CrsHasSettings;
    static DataSet.DataSetSerializer CrsLuminanceSmoothing;
    static DataSet.DataSetSerializer CrsRawFileName;
    static DataSet.DataSetSerializer CrsRedHue;
    static DataSet.DataSetSerializer CrsRedSaturation;
    static DataSet.DataSetSerializer CrsSaturation;
    static DataSet.DataSetSerializer CrsShadows;
    static DataSet.DataSetSerializer CrsShadowTint;
    static DataSet.DataSetSerializer CrsSharpness;
    static DataSet.DataSetSerializer CrsTemperature;
    static DataSet.DataSetSerializer CrsTint;
    static DataSet.DataSetSerializer CrsToneCurve;
    static DataSet.DataSetSerializer CrsToneCurveName;
    static DataSet.DataSetSerializer CrsVersion;
    static DataSet.DataSetSerializer CrsVignetteAmount;
    static DataSet.DataSetSerializer CrsVignetteMidpoint;
    static DataSet.DataSetSerializer CrsWhiteBalance;
    static DataSet.DataSetSerializer TiffImageWidth;
    static DataSet.DataSetSerializer TiffImageLength;
    static DataSet.DataSetSerializer TiffBitsPerSample;
    static DataSet.DataSetSerializer TiffCompression;
    static DataSet.DataSetSerializer TiffPhotometricInterpretation;
    static DataSet.DataSetSerializer TiffOrientation;
    static DataSet.DataSetSerializer TiffSamplesPerPixel;
    static DataSet.DataSetSerializer TiffPlanarConfiguration;
    static DataSet.DataSetSerializer TiffYCbCrSubSampling;
    static DataSet.DataSetSerializer TiffYCbCrPositioning;
    static DataSet.DataSetSerializer TiffXResolution;
    static DataSet.DataSetSerializer TiffYResolution;
    static DataSet.DataSetSerializer TiffResolutionUnit;
    static DataSet.DataSetSerializer TiffTransferFunction;
    static DataSet.DataSetSerializer TiffWhitePoint;
    static DataSet.DataSetSerializer TiffPrimaryChromaticities;
    static DataSet.DataSetSerializer TiffYCbCrCoefficients;
    static DataSet.DataSetSerializer TiffReferenceBlackWhite;
    static DataSet.DataSetSerializer TiffDateTime;
    static DataSet.DataSetSerializer TiffImageDescription;
    static DataSet.DataSetSerializer TiffMake;
    static DataSet.DataSetSerializer TiffModel;
    static DataSet.DataSetSerializer TiffSoftware;
    static DataSet.DataSetSerializer TiffArtist;
    static DataSet.DataSetSerializer TiffCopyright;
    static DataSet.DataSetSerializer ExifVersion;
    static DataSet.DataSetSerializer ExifFlashpixVersion;
    static DataSet.DataSetSerializer ExifColorSpace;
    static DataSet.DataSetSerializer ExifComponentsConfiguration;
    static DataSet.DataSetSerializer ExifCompressedBitsPerPixel;
    static DataSet.DataSetSerializer ExifPixelXDimension;
    static DataSet.DataSetSerializer ExifPixelYDimension;
    static DataSet.DataSetSerializer ExifUserComment;
    static DataSet.DataSetSerializer ExifRelatedSoundFile;
    static DataSet.DataSetSerializer ExifDateTimeOriginal;
    static DataSet.DataSetSerializer ExifDateTimeDigitized;
    static DataSet.DataSetSerializer ExifExposureTime;
    static DataSet.DataSetSerializer ExifFNumber;
    static DataSet.DataSetSerializer ExifExposureProgram;
    static DataSet.DataSetSerializer ExifSpectralSensitivity;
    static DataSet.DataSetSerializer ExifISOSpeedRatings;
    static DataSet.DataSetSerializer ExifOECF;
    static DataSet.DataSetSerializer ExifShutterSpeedValue;
    static DataSet.DataSetSerializer ExifApertureValue;
    static DataSet.DataSetSerializer ExifBrightnessValue;
    static DataSet.DataSetSerializer ExifExposureBiasValue;
    static DataSet.DataSetSerializer ExifMaxApertureValue;
    static DataSet.DataSetSerializer ExifSubjectDistance;
    static DataSet.DataSetSerializer ExifMeteringMode;
    static DataSet.DataSetSerializer ExifLightSource;
    static DataSet.DataSetSerializer ExifFlash;
    static DataSet.DataSetSerializer ExifFocalLength;
    static DataSet.DataSetSerializer ExifSubjectArea;
    static DataSet.DataSetSerializer ExifFlashEnergy;
    static DataSet.DataSetSerializer ExifSpatialFrequencyResponse;
    static DataSet.DataSetSerializer ExifFocalPlaneXResolution;
    static DataSet.DataSetSerializer ExifFocalPlaneYResolution;
    static DataSet.DataSetSerializer ExifFocalPlaneResolutionUnit;
    static DataSet.DataSetSerializer ExifSubjectLocation;
    static DataSet.DataSetSerializer ExifExposureIndex;
    static DataSet.DataSetSerializer ExifSensingMethod;
    static DataSet.DataSetSerializer ExifFileSource;
    static DataSet.DataSetSerializer ExifSceneType;
    static DataSet.DataSetSerializer ExifCFAPattern;
    static DataSet.DataSetSerializer ExifCustomRendered;
    static DataSet.DataSetSerializer ExifExposureMode;
    static DataSet.DataSetSerializer ExifWhiteBalance;
    static DataSet.DataSetSerializer ExifDigitalZoomRatio;
    static DataSet.DataSetSerializer ExifFocalLengthIn35mmFilm;
    static DataSet.DataSetSerializer ExifSceneCaptureType;
    static DataSet.DataSetSerializer ExifGainControl;
    static DataSet.DataSetSerializer ExifContrast;
    static DataSet.DataSetSerializer ExifSaturation;
    static DataSet.DataSetSerializer ExifSharpness;
    static DataSet.DataSetSerializer ExifDeviceSettingDescription;
    static DataSet.DataSetSerializer ExifSubjectDistanceRange;
    static DataSet.DataSetSerializer ExifImageUniqueID;
    static DataSet.DataSetSerializer ExifGPSVersionID;
    static DataSet.DataSetSerializer ExifGPSLatitude;
    static DataSet.DataSetSerializer ExifGPSLongitude;
    static DataSet.DataSetSerializer ExifGPSAltitudeRef;
    static DataSet.DataSetSerializer ExifGPSAltitude;
    static DataSet.DataSetSerializer ExifGPSTimeStamp;
    static DataSet.DataSetSerializer ExifGPSSatellites;
    static DataSet.DataSetSerializer ExifGPSStatus;
    static DataSet.DataSetSerializer ExifGPSMeasureMode;
    static DataSet.DataSetSerializer ExifGPSDOP;
    static DataSet.DataSetSerializer ExifGPSSpeedRef;
    static DataSet.DataSetSerializer ExifGPSSpeed;
    static DataSet.DataSetSerializer ExifGPSTrackRef;
    static DataSet.DataSetSerializer ExifGPSTrack;
    static DataSet.DataSetSerializer ExifGPSImgDirectionRef;
    static DataSet.DataSetSerializer ExifGPSImgDirection;
    static DataSet.DataSetSerializer ExifGPSMapDatum;
    static DataSet.DataSetSerializer ExifGPSDestLatitude;
    static DataSet.DataSetSerializer ExifGPSDestLongitude;
    static DataSet.DataSetSerializer ExifGPSDestBearingRef;
    static DataSet.DataSetSerializer ExifGPSDestBearing;
    static DataSet.DataSetSerializer ExifGPSDestDistanceRef;
    static DataSet.DataSetSerializer ExifGPSDestDistance;
    static DataSet.DataSetSerializer ExifGPSProcessingMethod;
    static DataSet.DataSetSerializer ExifGPSAreaInformation;
    static DataSet.DataSetSerializer ExifGPSDifferential;
    static DataSet.DataSetSerializer AuxLens;
    static DataSet.DataSetSerializer AuxSerialNumber;
    @Deprecated
    static DataSet.DataSetSerializer Iptc4XmpCoreCountryCode;
    static DataSet.DataSetSerializer Iptc4XmpCoreIntellectualGenre;
    static DataSet.DataSetSerializer Iptc4XmpCoreScene;
    static DataSet.DataSetSerializer Iptc4XmpCoreSubjectCode;
    @Deprecated
    static DataSet.DataSetSerializer Iptc4XmpCoreLocation;
    static DataSet.DataSetSerializer Iptc4XmpCoreCreatorContactInfo;
    static DataSet.DataSetSerializer Iptc4XmpCoreContactInfoDetails;
    static DataSet.DataSetSerializer Iptc4XmpCoreCiAdrExtadr;
    static DataSet.DataSetSerializer Iptc4XmpCoreCiAdrCity;
    static DataSet.DataSetSerializer Iptc4XmpCoreCiAdrCtry;
    static DataSet.DataSetSerializer Iptc4XmpCoreCiEmailWork;
    static DataSet.DataSetSerializer Iptc4XmpCoreCiTelWork;
    static DataSet.DataSetSerializer Iptc4XmpCoreCiAdrPcode;
    static DataSet.DataSetSerializer Iptc4XmpCoreCiAdrRegion;
    static DataSet.DataSetSerializer Iptc4XmpCoreCiUrlWork;
    static DataSet.DataSetSerializer Iptc4XmpExtAddlModelInfo;
    static DataSet.DataSetSerializer Iptc4XmpExtArtworkOrObject;
    static DataSet.DataSetSerializer Iptc4XmpExtOrganisationInImageCode;
    static DataSet.DataSetSerializer Iptc4XmpExtCVterm;
    static DataSet.DataSetSerializer Iptc4XmpExtLocationShown;
    static DataSet.DataSetSerializer Iptc4XmpExtModelAge;
    static DataSet.DataSetSerializer Iptc4XmpExtOrganisationInImageName;
    static DataSet.DataSetSerializer Iptc4XmpExtPersonInImage;
    static DataSet.DataSetSerializer Iptc4XmpExtDigImageGUID;
    @Deprecated
    static DataSet.DataSetSerializer Iptc4XmpExtDigitalSourcefileType;
    static DataSet.DataSetSerializer Iptc4XmpExtDigitalSourceType;
    static DataSet.DataSetSerializer Iptc4XmpExtEvent;
    static DataSet.DataSetSerializer Iptc4XmpExtRegistryId;
    @Deprecated
    static DataSet.DataSetSerializer Iptc4XmpExtIptcLastEdited;
    static DataSet.DataSetSerializer Iptc4XmpExtLocationCreated;
    static DataSet.DataSetSerializer Iptc4XmpExtMaxAvailHeight;
    static DataSet.DataSetSerializer Iptc4XmpExtMaxAvailWidth;
    static DataSet.DataSetSerializer Iptc4XmpExtArtworkOrObjectDetails;
    static DataSet.DataSetSerializer Iptc4XmpExtAOCopyrightNotice;
    static DataSet.DataSetSerializer Iptc4XmpExtAOCreator;
    static DataSet.DataSetSerializer Iptc4XmpExtAODateCreated;
    static DataSet.DataSetSerializer Iptc4XmpExtAOSource;
    static DataSet.DataSetSerializer Iptc4XmpExtAOSourceInvNo;
    static DataSet.DataSetSerializer Iptc4XmpExtAOTitle;
    static DataSet.DataSetSerializer Iptc4XmpExtCity;
    static DataSet.DataSetSerializer Iptc4XmpExtCountryCode;
    static DataSet.DataSetSerializer Iptc4XmpExtCountryName;
    static DataSet.DataSetSerializer Iptc4XmpExtLocationDetails;
    static DataSet.DataSetSerializer Iptc4XmpExtProvinceState;
    static DataSet.DataSetSerializer Iptc4XmpExtSublocation;
    static DataSet.DataSetSerializer Iptc4XmpExtWorldRegion;
    static DataSet.DataSetSerializer Iptc4XmpExtRegItemId;
    static DataSet.DataSetSerializer Iptc4XmpExtRegOrgId;
    static DataSet.DataSetSerializer Iptc4XmpExtRegistryEntryDetails;

    XmpSchemaDefinitions() {
    }

    private static String rdfBag(List<? extends DataSet> dataSets) {
        Iterator<? extends DataSet> it = dataSets.iterator();
        String str = "<rdf:Bag>";
        while (it.hasNext()) {
            str = str + "<rdf:li>" + it.next().getValue() + "</rdf:li>";
        }
        str = str + "</rdf:Bag>";
        return str;
    }

    private static String rdfSeq(List<? extends DataSet> dataSets) {
        Iterator<? extends DataSet> it = dataSets.iterator();
        String str = "<rdf:Seq>";
        while (it.hasNext()) {
            str = str + "<rdf:li>" + it.next().getValue() + "</rdf:li>";
        }
        str = str + "</rdf:Seq>";
        return str;
    }

    private static String rdfAlt(List<? extends DataSet> dataSets, String language) {
        String langQualifier = "";
        if (language != null) {
            langQualifier = " xml:lang='" + language + "'";
        }
        Iterator<? extends DataSet> it = dataSets.iterator();
        String str = "<rdf:Alt>";
        while (it.hasNext()) {
            str = str + "<rdf:li" + langQualifier + ">" + it.next().getValue() + "</rdf:li>";
        }
        str = str + "</rdf:Alt>";
        return str;
    }

    static {
        uriToNameSpacePrefix.put(DC_NS_URI, "dc");
        uriToNameSpacePrefix.put(XMP_NS_URI, "xmp");
        uriToNameSpacePrefix.put(XMPIDQ_NS_URI, "xmpidq");
        uriToNameSpacePrefix.put(XMPRIGHTS_NS_URI, "xmpRights");
        uriToNameSpacePrefix.put(XMPMM_NS_URI, "xmpMM");
        uriToNameSpacePrefix.put(XMPBJ_NS_URI, "xmpBJ");
        uriToNameSpacePrefix.put(XMPTPG_NS_URI, "xmpTPg");
        uriToNameSpacePrefix.put(XMPDM_NS_URI, "xmpDM");
        uriToNameSpacePrefix.put(PDF_NS_URI, "pdf");
        uriToNameSpacePrefix.put(PHOTOSHOP_NS_URI, "photoshop");
        uriToNameSpacePrefix.put(CRS_NS_URI, "crs");
        uriToNameSpacePrefix.put(TIFF_NS_URI, "tiff");
        uriToNameSpacePrefix.put(EXIF_NS_URI, "exif");
        uriToNameSpacePrefix.put(AUX_NS_URI, "aux");
        uriToNameSpacePrefix.put(IPTC_4_XMP_CORE_NS_URI, "Iptc4xmpCore");
        uriToNameSpacePrefix.put(IPTC_4_XMP_EXT_NS_URI, "Iptc4xmpExt");
        DcContributor = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:contributor>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</dc:contributor>";
            }
        };
        DcCoverage = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:coverage>" + dataSets.get(0).getValue() + "</dc:coverage>";
            }
        };
        DcCreator = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:creator>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</dc:creator>";
            }
        };
        DcDate = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:date>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</dc:date>";
            }
        };
        DcDescription = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:description>" + XmpSchemaDefinitions.rdfAlt(dataSets, "x-default") + "</dc:description>";
            }
        };
        DcFormat = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:format>" + dataSets.get(0).getValue() + "</dc:format>";
            }
        };
        DcIdentifier = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:identifier>" + dataSets.get(0).getValue() + "</dc:identifier>";
            }
        };
        DcLanguage = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:language>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</dc:language>";
            }
        };
        DcPublisher = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:publisher>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</dc:publisher>";
            }
        };
        DcRelation = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:relation>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</dc:relation>";
            }
        };
        DcRights = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:rights>" + XmpSchemaDefinitions.rdfAlt(dataSets, "x-default") + "</dc:rights>";
            }
        };
        DcSource = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:source>" + dataSets.get(0).getValue() + "</dc:source>";
            }
        };
        DcSubject = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:subject>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</dc:subject>";
            }
        };
        DcTitle = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:title>" + XmpSchemaDefinitions.rdfAlt(dataSets, "x-default") + "</dc:title>";
            }
        };
        DcType = new DataSet.DataSetSerializer(DC_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<dc:type>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</dc:type>";
            }
        };
        XmpAdvisory = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:Advisory>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</xmp:Advisory>";
            }
        };
        XmpBaseUrl = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:BaseURL>" + dataSets.get(0).getValue() + "</xmp:BaseURL>";
            }
        };
        XmpCreateDate = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:CreateDate>" + dataSets.get(0).getValue() + "</xmp:CreateDate>";
            }
        };
        XmpCreatorTool = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:CreatorTool>" + dataSets.get(0).getValue() + "</xmp:CreatorTool>";
            }
        };
        XmpIdentifier = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:Identifier>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</xmp:Identifier>";
            }
        };
        XmpLabel = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:Label>" + dataSets.get(0).getValue() + "</xmp:Label>";
            }
        };
        XmpMetadataDate = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:MetadataDate>" + dataSets.get(0).getValue() + "</xmp:MetadataDate>";
            }
        };
        XmpModifyDate = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:ModifyDate>" + dataSets.get(0).getValue() + "</xmp:ModifyDate>";
            }
        };
        XmpNickname = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:Nickname>" + dataSets.get(0).getValue() + "</xmp:Nickname>";
            }
        };
        XmpRating = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:Rating>" + dataSets.get(0).getValue() + "</xmp:Rating>";
            }
        };
        XmpThumbnails = new DataSet.DataSetSerializer(XMP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmp:Thumbnails>" + XmpSchemaDefinitions.rdfAlt(dataSets, null) + "</xmp:Thumbnails>";
            }
        };
        XmpidqScheme = new DataSet.DataSetSerializer(XMPIDQ_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpidq:Scheme>" + dataSets.get(0).getValue() + "</xmpidq:Scheme>";
            }
        };
        XmpRightsCertificate = new DataSet.DataSetSerializer(XMPRIGHTS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpRights:Certificate>" + dataSets.get(0).getValue() + "</xmpRights:Certificate>";
            }
        };
        XmpRightsMarked = new DataSet.DataSetSerializer(XMPRIGHTS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpRights:Marked>" + dataSets.get(0).getValue() + "</xmpRights:Marked>";
            }
        };
        XmpRightsOwner = new DataSet.DataSetSerializer(XMPRIGHTS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpRights:Owner>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</xmpRights:Owner>";
            }
        };
        XmpRightsUsageTerms = new DataSet.DataSetSerializer(XMPRIGHTS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpRights:UsageTerms>" + XmpSchemaDefinitions.rdfAlt(dataSets, "x-default") + "</xmpRights:UsageTerms>";
            }
        };
        XmpRightsWebStatement = new DataSet.DataSetSerializer(XMPRIGHTS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpRights:WebStatement>" + dataSets.get(0).getValue() + "</xmpRights:WebStatement>";
            }
        };
        XmpMmDerivedFrom = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:DerivedFrom>" + dataSets.get(0).getValue() + "</xmpMM:DerivedFrom>";
            }
        };
        XmpMmDocumentID = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:DocumentID>" + dataSets.get(0).getValue() + "</xmpMM:DocumentID>";
            }
        };
        XmpMmHistory = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:History>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</xmpMM:History>";
            }
        };
        XmpMmIngredients = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:Ingredients>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</xmpMM:Ingredients>";
            }
        };
        XmpMmInstanceId = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:InstanceID>" + dataSets.get(0).getValue() + "</xmpMM:InstanceID>";
            }
        };
        XmpMmManagedFrom = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:ManagedFrom>" + dataSets.get(0).getValue() + "</xmpMM:ManagedFrom>";
            }
        };
        XmpMmManager = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:Manager>" + dataSets.get(0).getValue() + "</xmpMM:Manager>";
            }
        };
        XmpMmManageTo = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:ManageTo>" + dataSets.get(0).getValue() + "</xmpMM:ManageTo>";
            }
        };
        XmpMmManageUI = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:ManageUI>" + dataSets.get(0).getValue() + "</xmpMM:ManageUI>";
            }
        };
        XmpMmManagerVariant = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:ManagerVariant>" + dataSets.get(0).getValue() + "</xmpMM:ManagerVariant>";
            }
        };
        XmpMmOriginalDocumentId = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:OriginalDocumentID>" + dataSets.get(0).getValue() + "</xmpMM:OriginalDocumentID>";
            }
        };
        XmpMmPantry = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:Pantry>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</xmpMM:Pantry>";
            }
        };
        XmpMmRenditionClass = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:RenditionClass>" + dataSets.get(0).getValue() + "</xmpMM:RenditionClass>";
            }
        };
        XmpMmRenditionParams = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:RenditionParams>" + dataSets.get(0).getValue() + "</xmpMM:RenditionParams>";
            }
        };
        XmpMmVersionId = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:VersionID>" + dataSets.get(0).getValue() + "</xmpMM:VersionID>";
            }
        };
        XmpMmVersions = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:Versions>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</xmpMM:Versions>";
            }
        };
        XmpMmLastUrl = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:LastURL>" + dataSets.get(0).getValue() + "</xmpMM:LastURL>";
            }
        };
        XmpMmRenditionOf = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:RenditionOf>" + dataSets.get(0).getValue() + "</xmpMM:RenditionOf>";
            }
        };
        XmpMmSaveId = new DataSet.DataSetSerializer(XMPMM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpMM:SaveID>" + dataSets.get(0).getValue() + "</xmpMM:SaveID>";
            }
        };
        XmpBjJobRef = new DataSet.DataSetSerializer(XMPBJ_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpBJ:JobRef>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</xmpBJ:JobRef>";
            }
        };
        XmpTpgMaxPageSize = new DataSet.DataSetSerializer(XMPTPG_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpTPg:MaxPageSize>" + dataSets.get(0).getValue() + "</xmpTPg:MaxPageSize>";
            }
        };
        XmpTpgNPages = new DataSet.DataSetSerializer(XMPTPG_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpTPg:NPages>" + dataSets.get(0).getValue() + "</xmpTPg:NPages>";
            }
        };
        XmpTpgFonts = new DataSet.DataSetSerializer(XMPTPG_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpTPg:Fonts>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</xmpTPg:Fonts>";
            }
        };
        XmpTpgColorants = new DataSet.DataSetSerializer(XMPTPG_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpTPg:Colorants>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</xmpTPg:Colorants>";
            }
        };
        XmpTpgPlateNames = new DataSet.DataSetSerializer(XMPTPG_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpTPg:PlateNames>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</xmpTPg:PlateNames>";
            }
        };
        XmpDmAbsPeakAudioFilePath = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:absPeakAudioFilePath>" + dataSets.get(0).getValue() + "</xmpDM:absPeakAudioFilePath>";
            }
        };
        XmpDmAlbum = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:album>" + dataSets.get(0).getValue() + "</xmpDM:album>";
            }
        };
        XmpDmAltTapeName = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:altTapeName>" + dataSets.get(0).getValue() + "</xmpDM:altTapeName>";
            }
        };
        XmpDmAltTimeCode = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:altTimecode>" + dataSets.get(0).getValue() + "</xmpDM:altTimecode>";
            }
        };
        XmpDmArtist = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:artist>" + dataSets.get(0).getValue() + "</xmpDM:artist>";
            }
        };
        XmpDmAudioModDate = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:audioModDate>" + dataSets.get(0).getValue() + "</xmpDM:audioModDate>";
            }
        };
        XmpDmAudioSampleRate = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:audioSampleRate>" + dataSets.get(0).getValue() + "</xmpDM:audioSampleRate>";
            }
        };
        XmpDmAudioSampleType = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:audioSampleType>" + dataSets.get(0).getValue() + "</xmpDM:audioSampleType>";
            }
        };
        XmpDmAudioChannelType = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:audioChannelType>" + dataSets.get(0).getValue() + "</xmpDM:audioChannelType>";
            }
        };
        XmpDmAudioCompressor = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:audioCompressor>" + dataSets.get(0).getValue() + "</xmpDM:audioCompressor>";
            }
        };
        XmpDmBeatSpliceParams = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:beatSpliceParams>" + dataSets.get(0).getValue() + "</xmpDM:beatSpliceParams>";
            }
        };
        XmpDmComposer = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:composer>" + dataSets.get(0).getValue() + "</xmpDM:composer>";
            }
        };
        XmpDmContributedMedia = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:contributedMedia>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</xmpDM:contributedMedia>";
            }
        };
        XmpDmCopyright = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:copyright>" + dataSets.get(0).getValue() + "</xmpDM:copyright>";
            }
        };
        XmpDmDuration = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:duration>" + dataSets.get(0).getValue() + "</xmpDM:duration>";
            }
        };
        XmpDmEngineer = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:engineer>" + dataSets.get(0).getValue() + "</xmpDM:engineer>";
            }
        };
        XmpDmFileDataRate = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:fileDataRate>" + dataSets.get(0).getValue() + "</xmpDM:fileDataRate>";
            }
        };
        XmpDmGenre = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:genre>" + dataSets.get(0).getValue() + "</xmpDM:genre>";
            }
        };
        XmpDmInstrument = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:instrument>" + dataSets.get(0).getValue() + "</xmpDM:instrument>";
            }
        };
        XmpDmIntroTime = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:introTime>" + dataSets.get(0).getValue() + "</xmpDM:introTime>";
            }
        };
        XmpDmKey = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:key>" + dataSets.get(0).getValue() + "</xmpDM:key>";
            }
        };
        XmpDmLongComment = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:logComment>" + dataSets.get(0).getValue() + "</xmpDM:logComment>";
            }
        };
        XmpDmLoop = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:loop>" + dataSets.get(0).getValue() + "</xmpDM:loop>";
            }
        };
        XmpDmNumberOfBeats = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:numberOfBeats>" + dataSets.get(0).getValue() + "</xmpDM:numberOfBeats>";
            }
        };
        XmpDmMarkers = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:markers>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</xmpDM:markers>";
            }
        };
        XmpDmMetadataModDate = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:metadataModDate>" + dataSets.get(0).getValue() + "</xmpDM:metadataModDate>";
            }
        };
        XmpDmOutCue = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:outCue>" + dataSets.get(0).getValue() + "</xmpDM:outCue>";
            }
        };
        XmpDmProjectRef = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:projectRef>" + dataSets.get(0).getValue() + "</xmpDM:projectRef>";
            }
        };
        XmpDmPullDown = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:pullDown>" + dataSets.get(0).getValue() + "</xmpDM:pullDown>";
            }
        };
        XmpDmRelativePeakAudioFilePath = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:relativePeakAudioFilePath>" + dataSets.get(0).getValue() + "</xmpDM:relativePeakAudioFilePath>";
            }
        };
        XmpDmRelativeTimestamp = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:relativeTimestamp>" + dataSets.get(0).getValue() + "</xmpDM:relativeTimestamp>";
            }
        };
        XmpDmReleaseDate = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:releaseDate>" + dataSets.get(0).getValue() + "</xmpDM:releaseDate>";
            }
        };
        XmpDmResampleParams = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:resampleParams>" + dataSets.get(0).getValue() + "</xmpDM:resampleParams>";
            }
        };
        XmpDmScaleType = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:scaleType>" + dataSets.get(0).getValue() + "</xmpDM:scaleType>";
            }
        };
        XmpDmScene = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:scene>" + dataSets.get(0).getValue() + "</xmpDM:scene>";
            }
        };
        XmpDmShotDate = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:shotDate>" + dataSets.get(0).getValue() + "</xmpDM:shotDate>";
            }
        };
        XmpDmShotLocation = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:shotLocation>" + dataSets.get(0).getValue() + "</xmpDM:shotLocation>";
            }
        };
        XmpDmShotName = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:shotName>" + dataSets.get(0).getValue() + "</xmpDM:shotName>";
            }
        };
        XmpDmSpeakerPlacement = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:speakerPlacement>" + dataSets.get(0).getValue() + "</xmpDM:speakerPlacement>";
            }
        };
        XmpDmStartTimecode = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:startTimecode>" + dataSets.get(0).getValue() + "</xmpDM:startTimecode>";
            }
        };
        XmpDmStretchMode = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:stretchMode>" + dataSets.get(0).getValue() + "</xmpDM:stretchMode>";
            }
        };
        XmpDmTapeName = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:tapeName>" + dataSets.get(0).getValue() + "</xmpDM:tapeName>";
            }
        };
        XmpDmTempo = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:tempo>" + dataSets.get(0).getValue() + "</xmpDM:tempo>";
            }
        };
        XmpDmTimeScaleParams = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:timeScaleParams>" + dataSets.get(0).getValue() + "</xmpDM:timeScaleParams>";
            }
        };
        XmpDmTimeSignature = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:timeSignature>" + dataSets.get(0).getValue() + "</xmpDM:timeSignature>";
            }
        };
        XmpDmTrackNumber = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:trackNumber>" + dataSets.get(0).getValue() + "</xmpDM:trackNumber>";
            }
        };
        XmpDmTracks = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:Tracks>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</xmpDM:Tracks>";
            }
        };
        XmpDmVideoAlphaMode = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoAlphaMode>" + dataSets.get(0).getValue() + "</xmpDM:videoAlphaMode>";
            }
        };
        XmpDmVideoAlphaPremultipleColor = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoAlphaPremultipleColor>" + dataSets.get(0).getValue() + "</xmpDM:videoAlphaPremultipleColor>";
            }
        };
        XmpDmVideoAlphaUnityIsTransparent = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoAlphaUnityIsTransparent>" + dataSets.get(0).getValue() + "</xmpDM:videoAlphaUnityIsTransparent>";
            }
        };
        XmpDmVideoColorSpace = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoColorSpace>" + dataSets.get(0).getValue() + "</xmpDM:videoColorSpace>";
            }
        };
        XmpDmVideoCompressor = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoCompressor>" + dataSets.get(0).getValue() + "</xmpDM:videoCompressor>";
            }
        };
        XmpDmVideoFieldOrder = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoFieldOrder>" + dataSets.get(0).getValue() + "</xmpDM:videoFieldOrder>";
            }
        };
        XmpDmVideoFrameRate = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoFrameRate>" + dataSets.get(0).getValue() + "</xmpDM:videoFrameRate>";
            }
        };
        XmpDmVideoFrameSize = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoFrameSize>" + dataSets.get(0).getValue() + "</xmpDM:videoFrameSize>";
            }
        };
        XmpDmVideoModDate = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoModDate>" + dataSets.get(0).getValue() + "</xmpDM:videoModDate>";
            }
        };
        XmpDmVideoPixelDepth = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoPixelDepth>" + dataSets.get(0).getValue() + "</xmpDM:videoPixelDepth>";
            }
        };
        XmpDmVideoPixelAspectRatio = new DataSet.DataSetSerializer(XMPDM_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<xmpDM:videoPixelAspectRatio>" + dataSets.get(0).getValue() + "</xmpDM:videoPixelAspectRatio>";
            }
        };
        PdfKeywords = new DataSet.DataSetSerializer(PDF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<pdf:Keywords>" + dataSets.get(0).getValue() + "</pdf:Keywords>";
            }
        };
        PdfVersion = new DataSet.DataSetSerializer(PDF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<pdf:PDFVersion>" + dataSets.get(0).getValue() + "</pdf:PDFVersion>";
            }
        };
        PdfProducer = new DataSet.DataSetSerializer(PDF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<pdf:Producer>" + dataSets.get(0).getValue() + "</pdf:Producer>";
            }
        };
        PhotoshopAuthorsPosition = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:AuthorsPosition>" + dataSets.get(0).getValue() + "</photoshop:AuthorsPosition>";
            }
        };
        PhotoshopCaptionWriter = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:CaptionWriter>" + dataSets.get(0).getValue() + "</photoshop:CaptionWriter>";
            }
        };
        PhotoshopCategory = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:Category>" + dataSets.get(0).getValue() + "</photoshop:Category>";
            }
        };
        PhotoshopCity = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:City>" + dataSets.get(0).getValue() + "</photoshop:City>";
            }
        };
        PhotoshopCountry = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:Country>" + dataSets.get(0).getValue() + "</photoshop:Country>";
            }
        };
        PhotoshopCredit = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:Credit>" + dataSets.get(0).getValue() + "</photoshop:Credit>";
            }
        };
        PhotoshopDateCreated = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:DateCreated>" + dataSets.get(0).getValue() + "</photoshop:DateCreated>";
            }
        };
        PhotoshopHeadline = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:Headline>" + dataSets.get(0).getValue() + "</photoshop:Headline>";
            }
        };
        PhotoshopInstructions = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:Instructions>" + dataSets.get(0).getValue() + "</photoshop:Instructions>";
            }
        };
        PhotoshopSource = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:Source>" + dataSets.get(0).getValue() + "</photoshop:Source>";
            }
        };
        PhotoshopState = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:State>" + dataSets.get(0).getValue() + "</photoshop:State>";
            }
        };
        PhotoshopSupplementalCategories = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:SupplementalCategories>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</photoshop:SupplementalCategories>";
            }
        };
        PhotoshopTransmissionReference = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:TransmissionReference>" + dataSets.get(0).getValue() + "</photoshop:TransmissionReference>";
            }
        };
        PhotoshopUrgency = new DataSet.DataSetSerializer(PHOTOSHOP_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<photoshop:Urgency>" + dataSets.get(0).getValue() + "</photoshop:Urgency>";
            }
        };
        CrsAutoBrightness = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:AutoBrightness>" + dataSets.get(0).getValue() + "</crs:AutoBrightness>";
            }
        };
        CrsAutoContrast = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:AutoContrast>" + dataSets.get(0).getValue() + "</crs:AutoContrast>";
            }
        };
        CrsAutoExposure = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:AutoExposure>" + dataSets.get(0).getValue() + "</crs:AutoExposure>";
            }
        };
        CrsAutoShadows = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:AutoShadows>" + dataSets.get(0).getValue() + "</crs:AutoShadows>";
            }
        };
        CrsBlueHue = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:BlueHue>" + dataSets.get(0).getValue() + "</crs:BlueHue>";
            }
        };
        CrsBlueSaturation = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:BlueSaturation>" + dataSets.get(0).getValue() + "</crs:BlueSaturation>";
            }
        };
        CrsBrightness = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:Brightness>" + dataSets.get(0).getValue() + "</crs:Brightness>";
            }
        };
        CrsCameraProfile = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:CameraProfile>" + dataSets.get(0).getValue() + "</crs:CameraProfile>";
            }
        };
        CrsChromaticAberrationB = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:ChromaticAberrationB>" + dataSets.get(0).getValue() + "</crs:ChromaticAberrationB>";
            }
        };
        CrsChromaticAberrationR = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:ChromaticAberrationR>" + dataSets.get(0).getValue() + "</crs:ChromaticAberrationR>";
            }
        };
        CrsColorNoiseReduction = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:ColorNoiseReduction>" + dataSets.get(0).getValue() + "</crs:ColorNoiseReduction>";
            }
        };
        CrsContrast = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:Contrast>" + dataSets.get(0).getValue() + "</crs:Contrast>";
            }
        };
        CrsCropTop = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:CropTop>" + dataSets.get(0).getValue() + "</crs:CropTop>";
            }
        };
        CrsCropLeft = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:CropLeft>" + dataSets.get(0).getValue() + "</crs:CropLeft>";
            }
        };
        CrsCropBottom = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:CropBottom>" + dataSets.get(0).getValue() + "</crs:CropBottom>";
            }
        };
        CrsCropRight = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:CropRight>" + dataSets.get(0).getValue() + "</crs:CropRight>";
            }
        };
        CrsCropAngle = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:CropAngle>" + dataSets.get(0).getValue() + "</crs:CropAngle>";
            }
        };
        CrsCropWidth = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:CropWidth>" + dataSets.get(0).getValue() + "</crs:CropWidth>";
            }
        };
        CrsCropHeight = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:CropHeight>" + dataSets.get(0).getValue() + "</crs:CropHeight>";
            }
        };
        CrsCropUnits = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:CropUnits>" + dataSets.get(0).getValue() + "</crs:CropUnits>";
            }
        };
        CrsExposure = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:Exposure>" + dataSets.get(0).getValue() + "</crs:Exposure>";
            }
        };
        CrsGreenHue = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:GreenHue>" + dataSets.get(0).getValue() + "</crs:GreenHue>";
            }
        };
        CrsGreenSaturation = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:GreenSaturation>" + dataSets.get(0).getValue() + "</crs:GreenSaturation>";
            }
        };
        CrsHasCrop = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:HasCrop>" + dataSets.get(0).getValue() + "</crs:HasCrop>";
            }
        };
        CrsHasSettings = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:HasSettings>" + dataSets.get(0).getValue() + "</crs:HasSettings>";
            }
        };
        CrsLuminanceSmoothing = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:LuminanceSmoothing>" + dataSets.get(0).getValue() + "</crs:LuminanceSmoothing>";
            }
        };
        CrsRawFileName = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:RawFileName>" + dataSets.get(0).getValue() + "</crs:RawFileName>";
            }
        };
        CrsRedHue = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:RedHue>" + dataSets.get(0).getValue() + "</crs:RedHue>";
            }
        };
        CrsRedSaturation = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:RedSaturation>" + dataSets.get(0).getValue() + "</crs:RedSaturation>";
            }
        };
        CrsSaturation = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:Saturation>" + dataSets.get(0).getValue() + "</crs:Saturation>";
            }
        };
        CrsShadows = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:Shadows>" + dataSets.get(0).getValue() + "</crs:Shadows>";
            }
        };
        CrsShadowTint = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:ShadowTint>" + dataSets.get(0).getValue() + "</crs:ShadowTint>";
            }
        };
        CrsSharpness = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:Sharpness>" + dataSets.get(0).getValue() + "</crs:Sharpness>";
            }
        };
        CrsTemperature = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:Temperature>" + dataSets.get(0).getValue() + "</crs:Temperature>";
            }
        };
        CrsTint = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:Tint>" + dataSets.get(0).getValue() + "</crs:Tint>";
            }
        };
        CrsToneCurve = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:ToneCurve>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</crs:ToneCurve>";
            }
        };
        CrsToneCurveName = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:ToneCurveName>" + dataSets.get(0).getValue() + "</crs:ToneCurveName>";
            }
        };
        CrsVersion = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:Version>" + dataSets.get(0).getValue() + "</crs:Version>";
            }
        };
        CrsVignetteAmount = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:VignetteAmount>" + dataSets.get(0).getValue() + "</crs:VignetteAmount>";
            }
        };
        CrsVignetteMidpoint = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:VignetteMidpoint>" + dataSets.get(0).getValue() + "</crs:VignetteMidpoint>";
            }
        };
        CrsWhiteBalance = new DataSet.DataSetSerializer(CRS_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<crs:WhiteBalance>" + dataSets.get(0).getValue() + "</crs:WhiteBalance>";
            }
        };
        TiffImageWidth = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:ImageWidth>" + dataSets.get(0).getValue() + "</tiff:ImageWidth>";
            }
        };
        TiffImageLength = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:ImageLength>" + dataSets.get(0).getValue() + "</tiff:ImageLength>";
            }
        };
        TiffBitsPerSample = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:BitsPerSample>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</tiff:BitsPerSample>";
            }
        };
        TiffCompression = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:Compression>" + dataSets.get(0).getValue() + "</tiff:Compression>";
            }
        };
        TiffPhotometricInterpretation = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:PhotometricInterpretation>" + dataSets.get(0).getValue() + "</tiff:PhotometricInterpretation>";
            }
        };
        TiffOrientation = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:Orientation>" + dataSets.get(0).getValue() + "</tiff:Orientation>";
            }
        };
        TiffSamplesPerPixel = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:SamplesPerPixel>" + dataSets.get(0).getValue() + "</tiff:SamplesPerPixel>";
            }
        };
        TiffPlanarConfiguration = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:PlanarConfiguration>" + dataSets.get(0).getValue() + "</tiff:PlanarConfiguration>";
            }
        };
        TiffYCbCrSubSampling = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:YCbCrSubSampling>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</tiff:YCbCrSubSampling>";
            }
        };
        TiffYCbCrPositioning = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:YCbCrPositioning>" + dataSets.get(0).getValue() + "</tiff:YCbCrPositioning>";
            }
        };
        TiffXResolution = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:XResolution>" + dataSets.get(0).getValue() + "</tiff:XResolution>";
            }
        };
        TiffYResolution = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:YResolution>" + dataSets.get(0).getValue() + "</tiff:YResolution>";
            }
        };
        TiffResolutionUnit = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:ResolutionUnit>" + dataSets.get(0).getValue() + "</tiff:ResolutionUnit>";
            }
        };
        TiffTransferFunction = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:TransferFunction>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</tiff:TransferFunction>";
            }
        };
        TiffWhitePoint = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:WhitePoint>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</tiff:WhitePoint>";
            }
        };
        TiffPrimaryChromaticities = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:PrimaryChromaticities>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</tiff:PrimaryChromaticities>";
            }
        };
        TiffYCbCrCoefficients = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:YCbCrCoefficients>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</tiff:YCbCrCoefficients>";
            }
        };
        TiffReferenceBlackWhite = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:ReferenceBlackWhite>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</tiff:ReferenceBlackWhite>";
            }
        };
        TiffDateTime = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:DateTime>" + dataSets.get(0).getValue() + "</tiff:DateTime>";
            }
        };
        TiffImageDescription = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:ImageDescription>" + XmpSchemaDefinitions.rdfAlt(dataSets, "x-default") + "</tiff:ImageDescription>";
            }
        };
        TiffMake = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:Make>" + dataSets.get(0).getValue() + "</tiff:Make>";
            }
        };
        TiffModel = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:Model>" + dataSets.get(0).getValue() + "</tiff:Model>";
            }
        };
        TiffSoftware = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:Software>" + dataSets.get(0).getValue() + "</tiff:Software>";
            }
        };
        TiffArtist = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:Artist>" + dataSets.get(0).getValue() + "</tiff:Artist>";
            }
        };
        TiffCopyright = new DataSet.DataSetSerializer(TIFF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<tiff:Copyright>" + XmpSchemaDefinitions.rdfAlt(dataSets, "x-default") + "</tiff:Copyright>";
            }
        };
        ExifVersion = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ExifVersion>" + dataSets.get(0).getValue() + "</exif:ExifVersion>";
            }
        };
        ExifFlashpixVersion = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:FlashpixVersion>" + dataSets.get(0).getValue() + "</exif:FlashpixVersion>";
            }
        };
        ExifColorSpace = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ColorSpace>" + dataSets.get(0).getValue() + "</exif:ColorSpace>";
            }
        };
        ExifComponentsConfiguration = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ComponentsConfiguration>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</exif:ComponentsConfiguration>";
            }
        };
        ExifCompressedBitsPerPixel = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:CompressedBitsPerPixel>" + dataSets.get(0).getValue() + "</exif:CompressedBitsPerPixel>";
            }
        };
        ExifPixelXDimension = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:PixelXDimension>" + dataSets.get(0).getValue() + "</exif:PixelXDimension>";
            }
        };
        ExifPixelYDimension = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:PixelYDimension>" + dataSets.get(0).getValue() + "</exif:PixelYDimension>";
            }
        };
        ExifUserComment = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:UserComment>" + XmpSchemaDefinitions.rdfAlt(dataSets, "x-default") + "</exif:UserComment>";
            }
        };
        ExifRelatedSoundFile = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:RelatedSoundFile>" + dataSets.get(0).getValue() + "</exif:RelatedSoundFile>";
            }
        };
        ExifDateTimeOriginal = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:DateTimeOriginal>" + dataSets.get(0).getValue() + "</exif:DateTimeOriginal>";
            }
        };
        ExifDateTimeDigitized = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:DateTimeDigitized>" + dataSets.get(0).getValue() + "</exif:DateTimeDigitized>";
            }
        };
        ExifExposureTime = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ExposureTime>" + dataSets.get(0).getValue() + "</exif:ExposureTime>";
            }
        };
        ExifFNumber = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:FNumber>" + dataSets.get(0).getValue() + "</exif:FNumber>";
            }
        };
        ExifExposureProgram = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ExposureProgram>" + dataSets.get(0).getValue() + "</exif:ExposureProgram>";
            }
        };
        ExifSpectralSensitivity = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:SpectralSensitivity>" + dataSets.get(0).getValue() + "</exif:SpectralSensitivity>";
            }
        };
        ExifISOSpeedRatings = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ISOSpeedRatings>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</exif:ISOSpeedRatings>";
            }
        };
        ExifOECF = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:OECF>" + dataSets.get(0).getValue() + "</exif:OECF>";
            }
        };
        ExifShutterSpeedValue = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ShutterSpeedValue>" + dataSets.get(0).getValue() + "</exif:ShutterSpeedValue>";
            }
        };
        ExifApertureValue = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ApertureValue>" + dataSets.get(0).getValue() + "</exif:ApertureValue>";
            }
        };
        ExifBrightnessValue = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:BrightnessValue>" + dataSets.get(0).getValue() + "</exif:BrightnessValue>";
            }
        };
        ExifExposureBiasValue = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ExposureBiasValue>" + dataSets.get(0).getValue() + "</exif:ExposureBiasValue>";
            }
        };
        ExifMaxApertureValue = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:MaxApertureValue>" + dataSets.get(0).getValue() + "</exif:MaxApertureValue>";
            }
        };
        ExifSubjectDistance = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:SubjectDistance>" + dataSets.get(0).getValue() + "</exif:SubjectDistance>";
            }
        };
        ExifMeteringMode = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:MeteringMode>" + dataSets.get(0).getValue() + "</exif:MeteringMode>";
            }
        };
        ExifLightSource = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:LightSource>" + dataSets.get(0).getValue() + "</exif:LightSource>";
            }
        };
        ExifFlash = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:Flash>" + dataSets.get(0).getValue() + "</exif:Flash>";
            }
        };
        ExifFocalLength = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:FocalLength>" + dataSets.get(0).getValue() + "</exif:FocalLength>";
            }
        };
        ExifSubjectArea = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:SubjectArea>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</exif:SubjectArea>";
            }
        };
        ExifFlashEnergy = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:FlashEnergy>" + dataSets.get(0).getValue() + "</exif:FlashEnergy>";
            }
        };
        ExifSpatialFrequencyResponse = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:SpatialFrequencyResponse>" + dataSets.get(0).getValue() + "</exif:SpatialFrequencyResponse>";
            }
        };
        ExifFocalPlaneXResolution = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:FocalPlaneXResolution>" + dataSets.get(0).getValue() + "</exif:FocalPlaneXResolution>";
            }
        };
        ExifFocalPlaneYResolution = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:FocalPlaneYResolution>" + dataSets.get(0).getValue() + "</exif:FocalPlaneYResolution>";
            }
        };
        ExifFocalPlaneResolutionUnit = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:FocalPlaneResolutionUnit>" + dataSets.get(0).getValue() + "</exif:FocalPlaneResolutionUnit>";
            }
        };
        ExifSubjectLocation = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:SubjectLocation>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</exif:SubjectLocation>";
            }
        };
        ExifExposureIndex = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ExposureIndex>" + dataSets.get(0).getValue() + "</exif:ExposureIndex>";
            }
        };
        ExifSensingMethod = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:SensingMethod>" + dataSets.get(0).getValue() + "</exif:SensingMethod>";
            }
        };
        ExifFileSource = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:FileSource>" + dataSets.get(0).getValue() + "</exif:FileSource>";
            }
        };
        ExifSceneType = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:SceneType>" + dataSets.get(0).getValue() + "</exif:SceneType>";
            }
        };
        ExifCFAPattern = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:CFAPattern>" + dataSets.get(0).getValue() + "</exif:CFAPattern>";
            }
        };
        ExifCustomRendered = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:CustomRendered>" + dataSets.get(0).getValue() + "</exif:CustomRendered>";
            }
        };
        ExifExposureMode = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ExposureMode>" + dataSets.get(0).getValue() + "</exif:ExposureMode>";
            }
        };
        ExifWhiteBalance = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:WhiteBalance>" + dataSets.get(0).getValue() + "</exif:WhiteBalance>";
            }
        };
        ExifDigitalZoomRatio = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:DigitalZoomRatio>" + dataSets.get(0).getValue() + "</exif:DigitalZoomRatio>";
            }
        };
        ExifFocalLengthIn35mmFilm = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:FocalLengthIn35mmFilm>" + dataSets.get(0).getValue() + "</exif:FocalLengthIn35mmFilm>";
            }
        };
        ExifSceneCaptureType = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:SceneCaptureType>" + dataSets.get(0).getValue() + "</exif:SceneCaptureType>";
            }
        };
        ExifGainControl = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GainControl>" + dataSets.get(0).getValue() + "</exif:GainControl>";
            }
        };
        ExifContrast = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:Contrast>" + dataSets.get(0).getValue() + "</exif:Contrast>";
            }
        };
        ExifSaturation = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:Saturation>" + dataSets.get(0).getValue() + "</exif:Saturation>";
            }
        };
        ExifSharpness = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:Sharpness>" + dataSets.get(0).getValue() + "</exif:Sharpness>";
            }
        };
        ExifDeviceSettingDescription = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:DeviceSettingDescription>" + dataSets.get(0).getValue() + "</exif:DeviceSettingDescription>";
            }
        };
        ExifSubjectDistanceRange = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:SubjectDistanceRange>" + dataSets.get(0).getValue() + "</exif:SubjectDistanceRange>";
            }
        };
        ExifImageUniqueID = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:ImageUniqueID>" + dataSets.get(0).getValue() + "</exif:ImageUniqueID>";
            }
        };
        ExifGPSVersionID = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSVersionID>" + dataSets.get(0).getValue() + "</exif:GPSVersionID>";
            }
        };
        ExifGPSLatitude = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSLatitude>" + dataSets.get(0).getValue() + "</exif:GPSLatitude>";
            }
        };
        ExifGPSLongitude = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSLongitude>" + dataSets.get(0).getValue() + "</exif:GPSLongitude>";
            }
        };
        ExifGPSAltitudeRef = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSAltitudeRef>" + dataSets.get(0).getValue() + "</exif:GPSAltitudeRef>";
            }
        };
        ExifGPSAltitude = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSAltitude>" + dataSets.get(0).getValue() + "</exif:GPSAltitude>";
            }
        };
        ExifGPSTimeStamp = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSTimeStamp>" + dataSets.get(0).getValue() + "</exif:GPSTimeStamp>";
            }
        };
        ExifGPSSatellites = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSSatellites>" + dataSets.get(0).getValue() + "</exif:GPSSatellites>";
            }
        };
        ExifGPSStatus = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSStatus>" + dataSets.get(0).getValue() + "</exif:GPSStatus>";
            }
        };
        ExifGPSMeasureMode = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSMeasureMode>" + dataSets.get(0).getValue() + "</exif:GPSMeasureMode>";
            }
        };
        ExifGPSDOP = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSDOP>" + dataSets.get(0).getValue() + "</exif:GPSDOP>";
            }
        };
        ExifGPSSpeedRef = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSSpeedRef>" + dataSets.get(0).getValue() + "</exif:GPSSpeedRef>";
            }
        };
        ExifGPSSpeed = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSSpeed>" + dataSets.get(0).getValue() + "</exif:GPSSpeed>";
            }
        };
        ExifGPSTrackRef = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSTrackRef>" + dataSets.get(0).getValue() + "</exif:GPSTrackRef>";
            }
        };
        ExifGPSTrack = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSTrack>" + dataSets.get(0).getValue() + "</exif:GPSTrack>";
            }
        };
        ExifGPSImgDirectionRef = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSImgDirectionRef>" + dataSets.get(0).getValue() + "</exif:GPSImgDirectionRef>";
            }
        };
        ExifGPSImgDirection = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSImgDirection>" + dataSets.get(0).getValue() + "</exif:GPSImgDirection>";
            }
        };
        ExifGPSMapDatum = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSMapDatum>" + dataSets.get(0).getValue() + "</exif:GPSMapDatum>";
            }
        };
        ExifGPSDestLatitude = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSDestLatitude>" + dataSets.get(0).getValue() + "</exif:GPSDestLatitude>";
            }
        };
        ExifGPSDestLongitude = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSDestLongitude>" + dataSets.get(0).getValue() + "</exif:GPSDestLongitude>";
            }
        };
        ExifGPSDestBearingRef = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSDestBearingRef>" + dataSets.get(0).getValue() + "</exif:GPSDestBearingRef>";
            }
        };
        ExifGPSDestBearing = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSDestBearing>" + dataSets.get(0).getValue() + "</exif:GPSDestBearing>";
            }
        };
        ExifGPSDestDistanceRef = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSDestDistanceRef>" + dataSets.get(0).getValue() + "</exif:GPSDestDistanceRef>";
            }
        };
        ExifGPSDestDistance = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSDestDistance>" + dataSets.get(0).getValue() + "</exif:GPSDestDistance>";
            }
        };
        ExifGPSProcessingMethod = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSProcessingMethod>" + dataSets.get(0).getValue() + "</exif:GPSProcessingMethod>";
            }
        };
        ExifGPSAreaInformation = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSAreaInformation>" + dataSets.get(0).getValue() + "</exif:GPSAreaInformation>";
            }
        };
        ExifGPSDifferential = new DataSet.DataSetSerializer(EXIF_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<exif:GPSDifferential>" + dataSets.get(0).getValue() + "</exif:GPSDifferential>";
            }
        };
        AuxLens = new DataSet.DataSetSerializer(AUX_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<aux:Lens>" + dataSets.get(0).getValue() + "</aux:Lens>";
            }
        };
        AuxSerialNumber = new DataSet.DataSetSerializer(AUX_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<aux:SerialNumber>" + dataSets.get(0).getValue() + "</aux:SerialNumber>";
            }
        };
        Iptc4XmpCoreCountryCode = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CountryCode>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CountryCode>";
            }
        };
        Iptc4XmpCoreIntellectualGenre = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:IntellectualGenre>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:IntellectualGenre>";
            }
        };
        Iptc4XmpCoreScene = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:Scene>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpCore:Scene>";
            }
        };
        Iptc4XmpCoreSubjectCode = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:SubjectCode>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpCore:SubjectCode>";
            }
        };
        Iptc4XmpCoreLocation = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:Location>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:Location>";
            }
        };
        Iptc4XmpCoreCreatorContactInfo = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CreatorContactInfo>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CreatorContactInfo>";
            }
        };
        Iptc4XmpCoreContactInfoDetails = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:ContactInfoDetails>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:ContactInfoDetails>";
            }
        };
        Iptc4XmpCoreCiAdrExtadr = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CiAdrExtadr>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CiAdrExtadr>";
            }
        };
        Iptc4XmpCoreCiAdrCity = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CiAdrCity>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CiAdrCity>";
            }
        };
        Iptc4XmpCoreCiAdrCtry = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CiAdrCtry>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CiAdrCtry>";
            }
        };
        Iptc4XmpCoreCiEmailWork = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CiEmailWork>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CiEmailWork>";
            }
        };
        Iptc4XmpCoreCiTelWork = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CiTelWork>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CiTelWork>";
            }
        };
        Iptc4XmpCoreCiAdrPcode = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CiAdrPcode>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CiAdrPcode>";
            }
        };
        Iptc4XmpCoreCiAdrRegion = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CiAdrRegion>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CiAdrRegion>";
            }
        };
        Iptc4XmpCoreCiUrlWork = new DataSet.DataSetSerializer(IPTC_4_XMP_CORE_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpCore:CiUrlWork>" + dataSets.get(0).getValue() + "</Iptc4xmpCore:CiUrlWork>";
            }
        };
        Iptc4XmpExtAddlModelInfo = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:AddlModelInfo>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:AddlModelInfo>";
            }
        };
        Iptc4XmpExtArtworkOrObject = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:ArtworkOrObject>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:ArtworkOrObject>";
            }
        };
        Iptc4XmpExtOrganisationInImageCode = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:OrganisationInImageCode>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:OrganisationInImageCode>";
            }
        };
        Iptc4XmpExtCVterm = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:CVterm>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:CVterm>";
            }
        };
        Iptc4XmpExtLocationShown = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:LocationShown>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:LocationShown>";
            }
        };
        Iptc4XmpExtModelAge = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:ModelAge>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:ModelAge>";
            }
        };
        Iptc4XmpExtOrganisationInImageName = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:OrganisationInImageName>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:OrganisationInImageName>";
            }
        };
        Iptc4XmpExtPersonInImage = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:PersonInImage>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:PersonInImage>";
            }
        };
        Iptc4XmpExtDigImageGUID = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:DigImageGUID>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:DigImageGUID>";
            }
        };
        Iptc4XmpExtDigitalSourcefileType = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:DigitalSourcefileType>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:DigitalSourcefileType>";
            }
        };
        Iptc4XmpExtDigitalSourceType = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:DigitalSourceType>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:DigitalSourceType>";
            }
        };
        Iptc4XmpExtEvent = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:Event>" + XmpSchemaDefinitions.rdfAlt(dataSets, "x-default") + "</Iptc4xmpExt:Event>";
            }
        };
        Iptc4XmpExtRegistryId = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:RegistryId>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:RegistryId>";
            }
        };
        Iptc4XmpExtIptcLastEdited = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:IptcLastEdited>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:IptcLastEdited>";
            }
        };
        Iptc4XmpExtLocationCreated = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:LocationCreated>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:LocationCreated>";
            }
        };
        Iptc4XmpExtMaxAvailHeight = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:MaxAvailHeight>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:MaxAvailHeight>";
            }
        };
        Iptc4XmpExtMaxAvailWidth = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:MaxAvailWidth>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:MaxAvailWidth>";
            }
        };
        Iptc4XmpExtArtworkOrObjectDetails = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:ArtworkOrObjectDetails>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:ArtworkOrObjectDetails>";
            }
        };
        Iptc4XmpExtAOCopyrightNotice = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:AOCopyrightNotice>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:AOCopyrightNotice>";
            }
        };
        Iptc4XmpExtAOCreator = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:AOCreator>" + XmpSchemaDefinitions.rdfSeq(dataSets) + "</Iptc4xmpExt:AOCreator>";
            }
        };
        Iptc4XmpExtAODateCreated = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:AODateCreated>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:AODateCreated>";
            }
        };
        Iptc4XmpExtAOSource = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:AOSource>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:AOSource>";
            }
        };
        Iptc4XmpExtAOSourceInvNo = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:AOSourceInvNo>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:AOSourceInvNo>";
            }
        };
        Iptc4XmpExtAOTitle = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:AOTitle>" + XmpSchemaDefinitions.rdfAlt(dataSets, "x-default") + "</Iptc4xmpExt:AOTitle>";
            }
        };
        Iptc4XmpExtCity = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:City>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:City>";
            }
        };
        Iptc4XmpExtCountryCode = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:CountryCode>" + XmpSchemaDefinitions.rdfBag(dataSets) + "</Iptc4xmpExt:CountryCode>";
            }
        };
        Iptc4XmpExtCountryName = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:CountryName>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:CountryName>";
            }
        };
        Iptc4XmpExtLocationDetails = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:LocationDetails>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:LocationDetails>";
            }
        };
        Iptc4XmpExtProvinceState = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:ProvinceState>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:ProvinceState>";
            }
        };
        Iptc4XmpExtSublocation = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:Sublocation>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:Sublocation>";
            }
        };
        Iptc4XmpExtWorldRegion = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:WorldRegion>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:WorldRegion>";
            }
        };
        Iptc4XmpExtRegItemId = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:RegItemId>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:RegItemId>";
            }
        };
        Iptc4XmpExtRegOrgId = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:RegOrgId>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:RegOrgId>";
            }
        };
        Iptc4XmpExtRegistryEntryDetails = new DataSet.DataSetSerializer(IPTC_4_XMP_EXT_NS_URI, "XMP"){

            @Override
            String serialize(List<? extends DataSet> dataSets) {
                return "<Iptc4xmpExt:RegistryEntryDetails>" + dataSets.get(0).getValue() + "</Iptc4xmpExt:RegistryEntryDetails>";
            }
        };
    }
}

