/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.samples.javaee6.converter;

import java.util.ArrayList;
import java.util.List;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.event.ActionEvent;
import org.apache.geronimo.samples.javaee6.converter.ConvertedValue;
import org.apache.geronimo.samples.javaee6.converter.Currency;

@ManagedBean(name="ConverterBean")
@RequestScoped
public class ConverterBean {
    private String inf = "Hide the rate table";
    private String msg = "Hello@ConverterBean";
    private String value = "1.0";
    private List<ConvertedValue> convertedList;
    private List<Currency> currencyList = new ArrayList();
    private Boolean render = false;

    public String getMsg() {
        return this.msg;
    }

    public Boolean getRender() {
        return this.render;
    }

    public void toggle(ActionEvent ae) {
        this.render = this.render == false;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List getConvertedList() {
        return this.convertedList;
    }

    private void setConvertedList() {
        this.convertedList = new ArrayList();
        for (Currency currency : this.currencyList) {
            ConvertedValue cv = new ConvertedValue();
            cv.setName("<" + currency.getName() + ">");
            cv.setActualVaule(Double.parseDouble(this.value) / currency.getRate());
            this.convertedList.add(cv);
        }
    }

    public List getCurrencyList() {
        return this.currencyList;
    }

    public void setCurrencyList(List currencyList) {
        this.currencyList = currencyList;
        this.setConvertedList();
    }

    public ConverterBean() {
        Currency c = new Currency("USD", 6.8269);
        this.currencyList.add(c);
        c = new Currency("HKD", 0.87887);
        this.currencyList.add(c);
        c = new Currency("JPY", 0.00754);
        this.currencyList.add(c);
        c = new Currency("EUR", 9.6734);
        this.currencyList.add(c);
        c = new Currency("GBP", 11.1009);
        this.currencyList.add(c);
        this.setConvertedList();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.setConvertedList();
    }
}

