/**
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package org.apache.geronimo.samples.javaee6.ejbtimer.sessionBean;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ejb.Schedule;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;

import org.apache.geronimo.samples.javaee6.ejbtimer.entity.Log;

@Stateless
public class scheduleTask {

    @PersistenceContext(unitName = "EJBTimerPU")
    private EntityManager em;
    
    @Schedule(minute = "*/3",hour = "*")
    public void beginNew() {
        clearLogs();
        logIntoDB("Begin new logs in the next 3 minutes.");
    }

    @Schedule(second = "*/7", minute = "*", hour = "*")
    public void test_automatic_timer() {
        logIntoDB("Every 7 seconds,backup the system");
    }

    // wake you up everyMorning at 7:50 from Monday to Friday

    @Schedule(minute = "50", hour = "7", dayOfWeek = "Mon,Tue,Wed,Thu,Fri")
    public void wakeup() {
        logIntoDB("wake you up@7:50");
    }

    @Schedule(minute = "*/2", hour = "*")
    public void backup() {
        logIntoDB("Send a mail every two minites");
    }

    @Schedule(second = "*/15", minute = "*", hour = "*")
    public void attack() {
        logIntoDB("Try to connect or attack a website every 15 seconds");
    }

    @Schedule(hour = "14", dayOfMonth = "last")
    public void cleanup() {
        logIntoDB("clean up all the dirty info in DB at 2:00pm of the end of month");
    }

    @Schedule(hour = "15/1", dayOfWeek = "Sat,Sun")
    public void nofifyFifteen() {
        logIntoDB("On Sat and Sunday,from 3:00 pm, you will get notified every hour ");
    }

    // Fool friends at each April 1st.

    @Schedule(dayOfMonth = "1", month = "Apr")
    public void foolFriends() {
        logIntoDB("Today is fool's day.All your friends will get this information");
    }

    public void logIntoDB(String event) {
        Date dt = new Date();
        DateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String nowTime = df.format(dt);
        Log log = new Log();
        log.setCreateTime(nowTime);
        log.setEvent(event);
        System.out.println("event");
        em.persist(log);
    }
    
    public void clearLogs() {
        Query query = em.createQuery("select l from Log l");
        List result = query.getResultList();
        Iterator<Log> iterator = result.iterator();
        while (iterator.hasNext()) {
            Log log = iterator.next();
            em.remove(log);
        }
        em.flush();
        logIntoDB("Logs of the last 3 minutes have been cleared.");
    }

}
