/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.centrality.betweenness;

import java.io.IOException;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.IdList;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.util.E;

public class BetweennessMessage
implements Value.CustomizeValue<BetweennessMessage> {
    private final IdList sequence;
    private final DoubleValue vote;

    public BetweennessMessage() {
        this.sequence = new IdList();
        this.vote = new DoubleValue(0.0);
    }

    public BetweennessMessage(IdList sequence) {
        this.sequence = sequence;
        this.vote = new DoubleValue();
    }

    public BetweennessMessage(DoubleValue betweenness) {
        this.sequence = new IdList();
        this.vote = betweenness;
    }

    public IdList sequence() {
        return this.sequence;
    }

    public DoubleValue vote() {
        return this.vote;
    }

    public BetweennessMessage value() {
        throw new UnsupportedOperationException();
    }

    public void read(RandomAccessInput in) throws IOException {
        this.sequence.read(in);
        this.vote.read(in);
    }

    public void write(RandomAccessOutput out) throws IOException {
        this.sequence.write(out);
        this.vote.write(out);
    }

    public int compareTo(Value value) {
        E.checkArgument((boolean)(value instanceof BetweennessMessage), (String)"The BetweennessMessage can't compare with class '%s'", (Object[])new Object[]{value.getClass()});
        BetweennessMessage other = (BetweennessMessage)value;
        E.checkArgument((this.sequence.size() != 0 ? 1 : 0) != 0, (String)"Sequence can't be empty", (Object[])new Object[0]);
        E.checkArgument((other.sequence.size() != 0 ? 1 : 0) != 0, (String)"Sequence can't be empty", (Object[])new Object[0]);
        Id selfSourceId = (Id)this.sequence.getFirst();
        Id otherSourceId = (Id)other.sequence.getFirst();
        return selfSourceId.compareTo((Object)otherSourceId);
    }
}

