/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.centrality.betweenness;

import java.io.IOException;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.IdSet;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;

public class BetweennessValue
implements Value.CustomizeValue<Double> {
    private final DoubleValue betweenness;
    private final IdSet arrivedVertices;

    public BetweennessValue() {
        this(0.0);
    }

    public BetweennessValue(double betweenness) {
        this.betweenness = new DoubleValue(betweenness);
        this.arrivedVertices = new IdSet();
    }

    public DoubleValue betweenness() {
        return this.betweenness;
    }

    public IdSet arrivedVertices() {
        return this.arrivedVertices;
    }

    public void read(RandomAccessInput in) throws IOException {
        this.betweenness.read(in);
        this.arrivedVertices.read(in);
    }

    public void write(RandomAccessOutput out) throws IOException {
        this.betweenness.write(out);
        this.arrivedVertices.write(out);
    }

    public Double value() {
        return this.betweenness.value();
    }

    public String string() {
        return this.value().toString();
    }
}

