/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.centrality.degree;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.NullValue;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;
import org.apache.hugegraph.computer.core.worker.WorkerContext;
import org.apache.hugegraph.util.NumericUtil;

public class DegreeCentrality
implements Computation<NullValue> {
    public static final String OPTION_WEIGHT_PROPERTY = "degree_centrality.weight_property";
    private boolean calculateByWeightProperty;
    private String weightProperty;

    public String name() {
        return "degree_centrality";
    }

    public String category() {
        return "centrality";
    }

    public void compute0(ComputationContext context, Vertex vertex) {
        if (!this.calculateByWeightProperty) {
            vertex.value((Value)new DoubleValue((double)vertex.numEdges()));
        } else {
            double totalWeight = 0.0;
            for (Edge edge : vertex.edges()) {
                double weight = DegreeCentrality.weightValue(edge.property(this.weightProperty));
                if (!Double.isInfinite(totalWeight += weight)) continue;
                throw new ComputerException("Calculate weight overflow, current is %s, edge '%s' is %s", new Object[]{totalWeight, edge, weight});
            }
            vertex.value((Value)new DoubleValue(totalWeight));
        }
        vertex.inactivate();
    }

    private static double weightValue(Value value) {
        if (value == null) {
            return 1.0;
        }
        switch (value.valueType()) {
            case LONG: 
            case INT: 
            case DOUBLE: 
            case FLOAT: {
                return NumericUtil.convertToNumber((Object)value).doubleValue();
            }
        }
        throw new ComputerException("The weight property can only be either Long or Int or Double or Float, but got %s", new Object[]{value.valueType()});
    }

    public void compute(ComputationContext context, Vertex vertex, Iterator<NullValue> messages) {
    }

    public void init(Config config) {
        this.weightProperty = config.getString(OPTION_WEIGHT_PROPERTY, "");
        this.calculateByWeightProperty = StringUtils.isNotEmpty((String)this.weightProperty);
    }

    public void close(Config config) {
    }

    public void beforeSuperstep(WorkerContext context) {
    }

    public void afterSuperstep(WorkerContext context) {
    }
}

