/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.centrality.pagerank;

import org.apache.hugegraph.computer.core.combiner.DoubleValueSumCombiner;
import org.apache.hugegraph.computer.core.combiner.LongValueSumCombiner;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.LongValue;
import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.master.MasterComputation;
import org.apache.hugegraph.computer.core.master.MasterComputationContext;
import org.apache.hugegraph.computer.core.master.MasterContext;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class PageRank4Master
implements MasterComputation {
    private static final Logger LOG = Log.logger(PageRank4Master.class);
    public static final String CONF_L1_NORM_DIFFERENCE_THRESHOLD_KEY = "pagerank.l1DiffThreshold";
    public static final double CONF_L1_DIFF_THRESHOLD_DEFAULT = 1.0E-5;
    public static final String AGGR_L1_NORM_DIFFERENCE_KEY = "pagerank.aggr_l1_norm_difference";
    public static final String AGGR_DANGLING_VERTICES_NUM = "pagerank.dangling_vertices_num";
    public static final String AGGR_COMULATIVE_DANGLING_PROBABILITY = "pagerank.comulative_dangling_probability";
    public static final String AGGR_COMULATIVE_PROBABILITY = "pagerank.comulative_probability";
    private double l1DiffThreshold;

    public void init(MasterContext context) {
        this.l1DiffThreshold = context.config().getDouble(CONF_L1_NORM_DIFFERENCE_THRESHOLD_KEY, 1.0E-5);
        context.registerAggregator(AGGR_DANGLING_VERTICES_NUM, ValueType.LONG, LongValueSumCombiner.class);
        context.registerAggregator(AGGR_COMULATIVE_DANGLING_PROBABILITY, ValueType.DOUBLE, DoubleValueSumCombiner.class);
        context.registerAggregator(AGGR_COMULATIVE_PROBABILITY, ValueType.DOUBLE, DoubleValueSumCombiner.class);
        context.registerAggregator(AGGR_L1_NORM_DIFFERENCE_KEY, ValueType.DOUBLE, DoubleValueSumCombiner.class);
    }

    public void close(MasterContext context) {
    }

    public boolean compute(MasterComputationContext context) {
        LongValue danglingVerticesNum = (LongValue)context.aggregatedValue(AGGR_DANGLING_VERTICES_NUM);
        DoubleValue danglingProbability = (DoubleValue)context.aggregatedValue(AGGR_COMULATIVE_DANGLING_PROBABILITY);
        DoubleValue cumulativeProbability = (DoubleValue)context.aggregatedValue(AGGR_COMULATIVE_PROBABILITY);
        DoubleValue l1NormDifference = (DoubleValue)context.aggregatedValue(AGGR_L1_NORM_DIFFERENCE_KEY);
        StringBuilder sb = new StringBuilder();
        sb.append("[Superstep ").append(context.superstep()).append("]").append(", dangling vertices num = ").append(danglingVerticesNum).append(", cumulative dangling probability = ").append(danglingProbability.value()).append(", cumulative probability = ").append(cumulativeProbability).append(", l1 norm difference = ").append(l1NormDifference.value());
        LOG.info("PageRank running status: {}", (Object)sb);
        double l1Diff = l1NormDifference.value();
        return context.superstep() <= 1 || !(l1Diff <= this.l1DiffThreshold);
    }
}

