/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.path.rings.filter;

import java.io.IOException;
import java.util.List;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.properties.DefaultProperties;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.graph.value.IdList;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;

public class RingsDetectionMessage
implements Value.CustomizeValue<List<Object>> {
    private final IdList path;
    private Properties walkEdgeProps;

    public RingsDetectionMessage() {
        GraphFactory graphFactory = ComputerContext.instance().graphFactory();
        this.path = new IdList();
        this.walkEdgeProps = new DefaultProperties(graphFactory);
    }

    public void read(RandomAccessInput in) throws IOException {
        this.path.read(in);
        this.walkEdgeProps.read(in);
    }

    public void write(RandomAccessOutput out) throws IOException {
        this.path.write(out);
        this.walkEdgeProps.write(out);
    }

    public IdList path() {
        return this.path;
    }

    public void addPath(Vertex vertex) {
        this.path.add((Value.Tvalue)vertex.id());
    }

    public Properties walkEdgeProp() {
        return this.walkEdgeProps;
    }

    public void walkEdgeProp(Properties properties) {
        this.walkEdgeProps = properties;
    }

    public List<Object> value() {
        return this.path.value();
    }
}

