/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.path.shortest;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.IdList;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;

public class SingleSourceShortestPathValue
implements Value.CustomizeValue<List<Object>> {
    private final IdList path = new IdList();
    private final DoubleValue totalWeight = new DoubleValue(0.0);

    public void read(RandomAccessInput in) throws IOException {
        this.path.read(in);
        this.totalWeight.read(in);
    }

    public void write(RandomAccessOutput out) throws IOException {
        this.path.write(out);
        this.totalWeight.write(out);
    }

    public List<Object> value() {
        return this.path.value();
    }

    public void unreachable() {
        this.totalWeight.value(Double.POSITIVE_INFINITY);
    }

    public void zeroDistance() {
        this.totalWeight.value(0.0);
    }

    public void shorterPath(Vertex vertex, IdList path, double weight) {
        this.path.clear();
        this.path.addAll((Collection)path.copy().values());
        this.path.add((Value.Tvalue)vertex.id());
        this.totalWeight.value(weight);
    }

    public void addToPath(Vertex vertex, double weight) {
        this.path.add((Value.Tvalue)vertex.id());
        this.totalWeight.value(weight);
    }

    public void addToPath(IdList path, double weight) {
        this.path.addAll((Collection)path.copy().values());
        this.totalWeight.value(weight);
    }

    public IdList path() {
        return this.path;
    }

    public double totalWeight() {
        return this.totalWeight.doubleValue();
    }

    public void copy(SingleSourceShortestPathValue value) {
        this.path.clear();
        this.path.addAll((Collection)value.path().copy().values());
        this.totalWeight.value(value.totalWeight());
    }
}

