/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import net.jodah.concurrentunit.Waiter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.python.BasePythonInterpreterTest;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.junit.Assert;
import org.junit.Test;

public class IPythonInterpreterTest
extends BasePythonInterpreterTest {
    protected Properties initIntpProperties() {
        Properties properties = new Properties();
        properties.setProperty("zeppelin.python.maxResult", "3");
        properties.setProperty("zeppelin.python.gatewayserver_address", "127.0.0.1");
        return properties;
    }

    protected void startInterpreter(Properties properties) throws InterpreterException {
        this.interpreter = new LazyOpenInterpreter((Interpreter)new IPythonInterpreter(properties));
        this.intpGroup = new InterpreterGroup();
        this.intpGroup.put("session_1", new ArrayList());
        this.intpGroup.get("session_1").add(this.interpreter);
        this.interpreter.setInterpreterGroup(this.intpGroup);
        this.interpreter.open();
    }

    @Override
    public void setUp() throws InterpreterException {
        Properties properties = this.initIntpProperties();
        this.startInterpreter(properties);
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("import sys\nsys.version_info.major", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        try {
            List messages = context.out.toInterpreterResultMessage();
            this.isPython2 = ((InterpreterResultMessage)messages.get(0)).getData().equals("2");
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
    }

    @Override
    public void tearDown() throws InterpreterException {
        this.intpGroup.close();
    }

    @Override
    public void testCodeCompletion() throws InterpreterException, IOException, InterruptedException {
        super.testCodeCompletion();
    }

    @Test
    public void testIpythonKernelCrash_shouldNotHangExecution() throws InterpreterException, IOException {
        String codeDep = "!pip install psutil";
        String codeFindPID = "from os import getpid\nimport psutil\npids = psutil.pids()\nmy_pid = getpid()\npidToKill = []\nfor pid in pids:\n    try:\n        p = psutil.Process(pid)\n        cmd = p.cmdline()\n        for arg in cmd:\n            if arg.count('ipykernel'):\n                pidToKill.append(pid)\n    except:\n        continue\nlen(pidToKill)";
        String codeKillKernel = "from os import kill\nimport signal\nfor pid in pidToKill:\n    kill(pid, signal.SIGKILL)";
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret(codeDep, context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret(codeFindPID, context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        InterpreterResultMessage output = (InterpreterResultMessage)context.out.toInterpreterResultMessage().get(0);
        int numberOfPID = Integer.parseInt(output.getData());
        TestCase.assertTrue((numberOfPID > 0 ? 1 : 0) != 0);
        context = this.getInterpreterContext();
        result = this.interpreter.interpret(codeKillKernel, context);
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        output = (InterpreterResultMessage)context.out.toInterpreterResultMessage().get(0);
        TestCase.assertTrue((String)output.getData(), (boolean)output.getData().contains("Ipython kernel has been stopped. Please check logs. It might be because of an out of memory issue."));
    }

    @Test
    public void testIPythonAdvancedFeatures() throws InterpreterException, InterruptedException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("range?", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("range(stop)"));
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("%timeit range(100)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("loops"));
        final InterpreterContext context2 = this.getInterpreterContext();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    IPythonInterpreterTest.this.interpreter.cancel(context2);
                }
                catch (InterpreterException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        result = this.interpreter.interpret("import time\ntime.sleep(10)", context2);
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        interpreterResultMessages = context2.out.toInterpreterResultMessage();
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("KeyboardInterrupt"));
    }

    @Test
    public void testIPythonPlotting() throws InterpreterException, InterruptedException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("%matplotlib inline\nimport matplotlib.pyplot as plt\ndata=[1,1,2,3,4]\nplt.figure()\nplt.plot(data)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        boolean hasImageOutput = false;
        boolean hasLineText = false;
        for (InterpreterResultMessage msg : interpreterResultMessages) {
            if (msg.getType() == InterpreterResult.Type.IMG) {
                hasImageOutput = true;
            }
            if (msg.getType() != InterpreterResult.Type.TEXT || !msg.getData().contains("matplotlib.lines.Line2D")) continue;
            hasLineText = true;
        }
        TestCase.assertTrue((String)"No Image Output", (boolean)hasImageOutput);
        TestCase.assertTrue((String)"No Line Text", (boolean)hasLineText);
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("from bokeh.io import output_notebook, show\nfrom bokeh.plotting import figure\nimport bkzep\noutput_notebook(notebook_type='zeppelin')", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        if (interpreterResultMessages.size() == 3) {
            Assert.assertEquals((long)3L, (long)interpreterResultMessages.size());
            Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
            TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(1)).getData().contains("Loading BokehJS"));
            Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(2)).getType());
            TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(2)).getData().contains("BokehJS is being loaded"));
        } else {
            Assert.assertEquals((long)2L, (long)interpreterResultMessages.size());
            Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
            TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("Loading BokehJS"));
            Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
            TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(1)).getData().contains("BokehJS is being loaded"));
        }
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("from bokeh.plotting import figure, output_file, show\nx = [1, 2, 3, 4, 5]\ny = [6, 7, 2, 4, 5]\np = figure(title=\"simple line example\", x_axis_label='x', y_axis_label='y')\np.line(x, y, legend=\"Temp.\", line_width=2)\nshow(p)", context);
        Assert.assertEquals((String)context.out.toInterpreterResultMessage().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        if (interpreterResultMessages.size() == 3) {
            Assert.assertEquals((long)3L, (long)interpreterResultMessages.size());
            Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
            Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(2)).getType());
            TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(2)).getData().contains("docs_json"));
        } else {
            Assert.assertEquals((long)2L, (long)interpreterResultMessages.size());
            Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
            Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
            TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(1)).getData().contains("docs_json"));
        }
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("import pandas as pd, numpy as np\nidx = pd.date_range('1/1/2000', periods=1000)\ndf = pd.DataFrame(np.random.randn(1000, 4), index=idx, columns=list('ABCD')).cumsum()\nimport hvplot.pandas\ndf.hvplot()", context);
        Assert.assertEquals((String)((InterpreterResultMessage)context.out.toInterpreterResultMessage().get(0)).getData(), (Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((String)context.out.toString(), (long)5L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(2)).getType());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(3)).getType());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(4)).getType());
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(4)).getData().contains("docs_json"));
    }

    public void testHtmlOutput() throws InterpreterException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("        import altair as alt\n        print(alt.renderers.active)\n        alt.renderers.enable(\"colab\")\n        import altair as alt\n        # load a simple dataset as a pandas DataFrame\n        from vega_datasets import data\n        cars = data.cars()\n        \n        alt.Chart(cars).mark_point().encode(\n            x='Horsepower',\n            y='Miles_per_Gallon',\n            color='Origin',\n        ).interactive()", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assert.assertEquals((long)2L, (long)context.out.size());
        Assert.assertEquals((Object)InterpreterResult.Type.TEXT, (Object)((InterpreterResultMessage)context.out.toInterpreterResultMessage().get(0)).getType());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)context.out.toInterpreterResultMessage().get(1)).getType());
    }

    @Test
    public void testIpython_shouldNotHang_whenCallingAutoCompleteAndInterpretConcurrently() throws InterpreterException, InterruptedException, TimeoutException, ExecutionException {
        this.tearDown();
        Properties properties = this.initIntpProperties();
        this.startInterpreter(properties);
        String code = "import time\nprint(1)\ntime.sleep(10)\nprint(2)";
        String base = "time.";
        ExecutorService pool = Executors.newFixedThreadPool(2);
        FutureTask interpretFuture = new FutureTask(new Callable(){

            public Object call() throws Exception {
                return IPythonInterpreterTest.this.interpreter.interpret("import time\nprint(1)\ntime.sleep(10)\nprint(2)", IPythonInterpreterTest.this.getInterpreterContext());
            }
        });
        FutureTask completionFuture = new FutureTask(new Callable(){

            public Object call() throws Exception {
                return IPythonInterpreterTest.this.interpreter.completion("time.", "time.".length(), IPythonInterpreterTest.this.getInterpreterContext());
            }
        });
        pool.execute(interpretFuture);
        Thread.sleep(3000L);
        pool.execute(completionFuture);
        InterpreterResult res = (InterpreterResult)interpretFuture.get(20000L, TimeUnit.MILLISECONDS);
        List autoRes = (List)completionFuture.get(3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"SUCCESS", (Object)res.code().name());
        TestCase.assertTrue((autoRes.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGrpcFrameSize() throws InterpreterException, IOException {
        this.tearDown();
        Properties properties = this.initIntpProperties();
        properties.setProperty("zeppelin.jupyter.kernel.grpc.message_size", "4000");
        this.startInterpreter(properties);
        InterpreterResult result = this.interpreter.interpret("from __future__ import print_function", this.getInterpreterContext());
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        InterpreterContext context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('1'*4000)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("exceeds maximum size 4000"));
        result = this.interpreter.interpret("print(1)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        this.tearDown();
        properties.setProperty("zeppelin.ipython.grpc.message_size", "5000");
        this.startInterpreter(properties);
        result = this.interpreter.interpret("from __future__ import print_function", this.getInterpreterContext());
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('1'*3000)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
    }

    @Test
    public void testIPythonProcessKilled() throws InterruptedException, TimeoutException {
        final Waiter waiter = new Waiter();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    InterpreterResult result = IPythonInterpreterTest.this.interpreter.interpret("import time\ntime.sleep(1000)", IPythonInterpreterTest.this.getInterpreterContext());
                    waiter.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
                    waiter.assertEquals((Object)"IPython kernel is abnormally exited, please check your code and log.", (Object)((InterpreterResultMessage)result.message().get(0)).getData());
                }
                catch (InterpreterException e) {
                    waiter.fail("Should not throw exception\n" + ExceptionUtils.getStackTrace((Throwable)e));
                }
                waiter.resume();
            }
        };
        thread.start();
        Thread.sleep(3000L);
        IPythonInterpreter iPythonInterpreter = (IPythonInterpreter)((LazyOpenInterpreter)this.interpreter).getInnerInterpreter();
        iPythonInterpreter.getKernelProcessLauncher().stop();
        waiter.await(3000L);
    }

    @Test
    public void testIPythonFailToLaunch() throws InterpreterException {
        this.tearDown();
        Properties properties = this.initIntpProperties();
        properties.setProperty("zeppelin.python", "invalid_python");
        try {
            this.startInterpreter(properties);
            Assert.fail((String)"Should not be able to start IPythonInterpreter");
        }
        catch (InterpreterException e) {
            String exceptionMsg = ExceptionUtils.getStackTrace((Throwable)e);
            TestCase.assertTrue((String)exceptionMsg, (boolean)exceptionMsg.contains("No such file or directory"));
        }
    }
}

