/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.apache.zeppelin.python.PythonInterpreterPandasSql;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class PythonInterpreterPandasSqlTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonInterpreterPandasSqlTest.class);
    private boolean useIPython;
    private InterpreterGroup intpGroup;
    private PythonInterpreterPandasSql pandasSqlInterpreter;
    private PythonInterpreter pythonInterpreter;
    private IPythonInterpreter ipythonInterpreter;
    private InterpreterContext context;

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    public PythonInterpreterPandasSqlTest(boolean useIPython) {
        this.useIPython = useIPython;
        LOGGER.info("Test PythonInterpreterPandasSqlTest while useIPython={}", (Object)useIPython);
    }

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("zeppelin.python", "python");
        p.setProperty("zeppelin.python.maxResult", "100");
        p.setProperty("zeppelin.python.useIPython", this.useIPython + "");
        p.setProperty("zeppelin.python.gatewayserver_address", "127.0.0.1");
        this.intpGroup = new InterpreterGroup();
        this.context = this.getInterpreterContext();
        InterpreterContext.set((InterpreterContext)this.context);
        this.pythonInterpreter = new PythonInterpreter(p);
        this.ipythonInterpreter = new IPythonInterpreter(p);
        this.pandasSqlInterpreter = new PythonInterpreterPandasSql(p);
        this.pythonInterpreter.setInterpreterGroup(this.intpGroup);
        this.ipythonInterpreter.setInterpreterGroup(this.intpGroup);
        this.pandasSqlInterpreter.setInterpreterGroup(this.intpGroup);
        ArrayList interpreters = Lists.newArrayList((Object[])new Interpreter[]{this.pythonInterpreter, this.ipythonInterpreter, this.pandasSqlInterpreter});
        this.intpGroup.put("session_1", (List)interpreters);
        this.pythonInterpreter.open();
        InterpreterResult ret = this.pythonInterpreter.interpret("print(\"python initialized\")\n", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        this.pandasSqlInterpreter.open();
    }

    @After
    public void afterTest() throws InterpreterException {
        this.pandasSqlInterpreter.close();
    }

    @Test
    public void dependenciesAreInstalled() throws InterpreterException {
        InterpreterResult ret = this.pythonInterpreter.interpret("import pandas\nimport pandasql\nimport numpy\n", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
    }

    @Test
    public void errorMessageIfDependenciesNotInstalled() throws InterpreterException {
        this.context = this.getInterpreterContext();
        InterpreterResult ret = this.pandasSqlInterpreter.interpret("SELECT * from something", this.context);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((String)this.context.out.toString(), (Object)InterpreterResult.Code.ERROR, (Object)ret.code());
        if (this.useIPython) {
            Assert.assertTrue((String)this.context.out.toString(), (boolean)this.context.out.toString().contains("no such table: something"));
        } else {
            Assert.assertTrue((String)ret.toString(), (boolean)ret.toString().contains("no such table: something"));
        }
    }

    @Test
    public void sqlOverTestDataPrintsTable() throws IOException, InterpreterException {
        InterpreterResult ret = this.pythonInterpreter.interpret("import pandas as pd\nimport numpy as np", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        ret = this.pythonInterpreter.interpret("df2 = pd.DataFrame({ 'age'  : np.array([33, 51, 51, 34]), 'name' : pd.Categorical(['moon','jobs','gates','park'])})", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        this.context = this.getInterpreterContext();
        ret = this.pandasSqlInterpreter.interpret("select name, age from df2 where age < 40", this.context);
        Assert.assertEquals((String)this.context.out.toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        Assert.assertEquals((String)this.context.out.toString(), (Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)this.context.out.toInterpreterResultMessage().get(0)).getType());
        Assert.assertTrue((this.context.out.toString().indexOf("moon\t33") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.context.out.toString().indexOf("park\t34") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.pandasSqlInterpreter.interpret("select case when name==\"aa\" then name else name end from df2", this.context).code());
    }

    @Test
    public void testInIPython() throws IOException, InterpreterException {
        InterpreterResult ret = this.pythonInterpreter.interpret("import pandas as pd\nimport numpy as np", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        ret = this.pythonInterpreter.interpret("df2 = pd.DataFrame({ 'age'  : np.array([33, 51, 51, 34]), 'name' : pd.Categorical(['moon','jobs','gates','park'])})", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        ret = this.pandasSqlInterpreter.interpret("select name, age from df2 where age < 40", this.context);
        Assert.assertEquals((String)this.context.out.toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        Assert.assertEquals((String)this.context.out.toString(), (Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)this.context.out.toInterpreterResultMessage().get(1)).getType());
        Assert.assertTrue((this.context.out.toString().indexOf("moon\t33") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.context.out.toString().indexOf("park\t34") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.pandasSqlInterpreter.interpret("select case when name==\"aa\" then name else name end from df2", this.context).code());
    }

    @Test
    public void badSqlSyntaxFails() throws InterpreterException {
        this.context = this.getInterpreterContext();
        InterpreterResult ret = this.pandasSqlInterpreter.interpret("select wrong syntax", this.context);
        Assert.assertNotNull((String)"Interpreter returned 'null'", (Object)ret);
        Assert.assertEquals((String)this.context.out.toString(), (Object)InterpreterResult.Code.ERROR, (Object)ret.code());
    }

    @Test
    public void showDataFrame() throws IOException, InterpreterException {
        this.pythonInterpreter.interpret("import pandas as pd", this.context);
        this.pythonInterpreter.interpret("import numpy as np", this.context);
        this.pythonInterpreter.interpret("index = pd.Index([10, 11, 12, 13], name='index_name')", this.context);
        this.pythonInterpreter.interpret("d1 = {1 : [np.nan, 1, 2, 3], 'two' : [3., 4., 5., 6.7]}", this.context);
        InterpreterResult ret = this.pythonInterpreter.interpret("df1 = pd.DataFrame(d1, index=index)", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        this.context = this.getInterpreterContext();
        ret = this.pythonInterpreter.interpret("z.show(df1, show_index=True)", this.context);
        Assert.assertEquals((String)this.context.out.toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        Assert.assertEquals((String)this.context.out.toString(), (Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)this.context.out.toInterpreterResultMessage().get(0)).getType());
        Assert.assertTrue((boolean)this.context.out.toString().contains("index_name"));
        Assert.assertTrue((boolean)this.context.out.toString().contains("nan"));
        Assert.assertTrue((boolean)this.context.out.toString().contains("6.7"));
    }

    private InterpreterContext getInterpreterContext() {
        return InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").setInterpreterOut(new InterpreterOutput()).setIntpEventClient((RemoteInterpreterEventClient)Mockito.mock(RemoteInterpreterEventClient.class)).build();
    }
}

