/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.python.PythonInterpreter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PythonInterpreterMatplotlibTest
implements InterpreterOutputListener {
    private InterpreterGroup intpGroup;
    private PythonInterpreter python;
    private InterpreterContext context;
    InterpreterOutput out;

    PythonInterpreterMatplotlibTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("zeppelin.python", "python");
        p.setProperty("zeppelin.python.maxResult", "100");
        p.setProperty("zeppelin.python.useIPython", "false");
        p.setProperty("zeppelin.python.gatewayserver_address", "127.0.0.1");
        this.intpGroup = new InterpreterGroup();
        this.python = new PythonInterpreter(p);
        this.python.setInterpreterGroup(this.intpGroup);
        LinkedList<PythonInterpreter> interpreters = new LinkedList<PythonInterpreter>();
        interpreters.add(this.python);
        this.intpGroup.put("note", interpreters);
        this.out = new InterpreterOutput((InterpreterOutputListener)this);
        this.context = InterpreterContext.builder().setInterpreterOut(this.out).setAngularObjectRegistry(new AngularObjectRegistry(this.intpGroup.getId(), null)).build();
        InterpreterContext.set((InterpreterContext)this.context);
        this.python.open();
    }

    @AfterEach
    public void afterTest() throws IOException, InterpreterException {
        this.python.close();
    }

    @Test
    void dependenciesAreInstalled() throws InterpreterException {
        InterpreterResult ret = this.python.interpret("import matplotlib", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)ret.message().toString());
        ret = this.python.interpret("import backend_zinline", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)ret.message().toString());
    }

    @Test
    void showPlot() throws IOException, InterpreterException {
        InterpreterResult ret = this.python.interpret("import matplotlib.pyplot as plt", this.context);
        ret = this.python.interpret("z.configure_mpl(interactive=False)", this.context);
        ret = this.python.interpret("plt.plot([1, 2, 3])", this.context);
        ret = this.python.interpret("plt.show()", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)new String(this.out.getOutputAt(0).toByteArray()));
        Assertions.assertEquals((Object)InterpreterResult.Type.TEXT, (Object)this.out.getOutputAt(0).getType(), (String)new String(this.out.getOutputAt(0).toByteArray()));
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)this.out.getOutputAt(1).getType(), (String)new String(this.out.getOutputAt(1).toByteArray()));
        Assertions.assertTrue((boolean)new String(this.out.getOutputAt(1).toByteArray()).contains("data:image/png;base64"));
        Assertions.assertTrue((boolean)new String(this.out.getOutputAt(1).toByteArray()).contains("<div>"));
    }

    @Test
    void testClose() throws IOException, InterpreterException {
        InterpreterResult ret = this.python.interpret("import matplotlib.pyplot as plt", this.context);
        ret = this.python.interpret("z.configure_mpl(interactive=False)", this.context);
        ret = this.python.interpret("plt.plot([1, 2, 3])", this.context);
        InterpreterResult ret1 = this.python.interpret("plt.show()", this.context);
        ret = this.python.interpret("plt.show()", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)new String(this.out.getOutputAt(0).toByteArray()));
        Assertions.assertEquals((int)0, (int)ret.message().size());
        ret = this.python.interpret("plt.plot([1, 2, 3])", this.context);
        String msg1 = new String(this.out.getOutputAt(0).toByteArray());
        InterpreterResult.Type type1 = this.out.getOutputAt(0).getType();
        InterpreterResult ret2 = this.python.interpret("plt.show()", this.context);
        String msg2 = new String(this.out.getOutputAt(0).toByteArray());
        InterpreterResult.Type type2 = this.out.getOutputAt(0).getType();
        Assertions.assertEquals((Object)msg1, (Object)msg2);
        Assertions.assertEquals((Object)type1, (Object)type2);
    }

    @Test
    void testNoClose() throws IOException, InterpreterException {
        InterpreterResult ret = this.python.interpret("import matplotlib.pyplot as plt", this.context);
        ret = this.python.interpret("z.configure_mpl(interactive=False, close=False)", this.context);
        ret = this.python.interpret("plt.plot([1, 2, 3])", this.context);
        InterpreterResult ret1 = this.python.interpret("plt.show()", this.context);
        ret = this.python.interpret("plt.show()", this.context);
        String msg1 = new String(this.out.getOutputAt(0).toByteArray());
        Assertions.assertNotSame((Object)"", (Object)msg1);
        ret = this.python.interpret("plt.plot([1, 2, 3])", this.context);
        msg1 = new String(this.out.getOutputAt(1).toByteArray());
        InterpreterResult ret2 = this.python.interpret("plt.show()", this.context);
        String msg2 = new String(this.out.getOutputAt(1).toByteArray());
        Assertions.assertNotSame((Object)msg1, (Object)msg2);
    }

    public void onUpdateAll(InterpreterOutput out) {
    }

    public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
    }

    public void onUpdate(int index, InterpreterResultMessageOutput out) {
    }
}

