/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.concurrentunit.Waiter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.python.BasePythonInterpreterTest;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPythonInterpreterTest
extends BasePythonInterpreterTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPythonInterpreterTest.class);
    protected boolean enableBokehTest = true;

    protected Properties initIntpProperties() {
        Properties properties = new Properties();
        properties.setProperty("zeppelin.python.maxResult", "3");
        properties.setProperty("zeppelin.python.gatewayserver_address", "127.0.0.1");
        return properties;
    }

    protected void startInterpreter(Properties properties) throws InterpreterException {
        this.interpreter = new LazyOpenInterpreter((Interpreter)new IPythonInterpreter(properties));
        this.intpGroup = new InterpreterGroup();
        this.intpGroup.put("session_1", new ArrayList());
        this.intpGroup.get("session_1").add(this.interpreter);
        this.interpreter.setInterpreterGroup(this.intpGroup);
        this.interpreter.open();
    }

    @Override
    @BeforeEach
    public void setUp() throws InterpreterException {
        Properties properties = this.initIntpProperties();
        this.startInterpreter(properties);
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("import sys\nsys.version_info.major", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        try {
            List messages = context.out.toInterpreterResultMessage();
            this.isPython2 = ((InterpreterResultMessage)messages.get(0)).getData().equals("2");
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws InterpreterException {
        this.intpGroup.close();
    }

    @Override
    public void testCodeCompletion() throws InterpreterException, IOException, InterruptedException {
        super.testCodeCompletion();
    }

    @Test
    void testIpythonKernelCrash_shouldNotHangExecution() throws InterpreterException, IOException {
        String codeDep = "!pip install psutil";
        String codeFindPID = "from os import getpid\nimport psutil\npids = psutil.pids()\nmy_pid = getpid()\npidToKill = []\nfor pid in pids:\n    try:\n        p = psutil.Process(pid)\n        cmd = p.cmdline()\n        for arg in cmd:\n            if arg.count('ipykernel'):\n                pidToKill.append(pid)\n    except:\n        continue\nlen(pidToKill)";
        String codeKillKernel = "from os import kill\nimport signal\nfor pid in pidToKill:\n    kill(pid, signal.SIGKILL)";
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret(codeDep, context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret(codeFindPID, context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        InterpreterResultMessage output = (InterpreterResultMessage)context.out.toInterpreterResultMessage().get(0);
        int numberOfPID = Integer.parseInt(output.getData());
        Assertions.assertTrue((numberOfPID > 0 ? 1 : 0) != 0);
        context = this.getInterpreterContext();
        result = this.interpreter.interpret(codeKillKernel, context);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        output = (InterpreterResultMessage)context.out.toInterpreterResultMessage().get(0);
        Assertions.assertTrue((boolean)output.getData().contains("Ipython kernel has been stopped. Please check logs. It might be because of an out of memory issue."), (String)output.getData());
    }

    @Test
    void testIPythonAdvancedFeatures() throws InterpreterException, InterruptedException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("range?", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("range(stop)"));
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("%timeit range(100)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("loops"));
        final InterpreterContext context2 = this.getInterpreterContext();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    IPythonInterpreterTest.this.interpreter.cancel(context2);
                }
                catch (InterpreterException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        result = this.interpreter.interpret("import time\ntime.sleep(10)", context2);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        interpreterResultMessages = context2.out.toInterpreterResultMessage();
        Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("KeyboardInterrupt"));
    }

    @Test
    void testIPythonPlotting() throws InterpreterException, InterruptedException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("%matplotlib inline\nimport matplotlib.pyplot as plt\ndata=[1,1,2,3,4]\nplt.figure()\nplt.plot(data)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        boolean hasImageOutput = false;
        boolean hasLineText = false;
        for (InterpreterResultMessage msg : interpreterResultMessages) {
            if (msg.getType() == InterpreterResult.Type.IMG) {
                hasImageOutput = true;
            }
            if (msg.getType() != InterpreterResult.Type.TEXT || !msg.getData().contains("matplotlib.lines.Line2D")) continue;
            hasLineText = true;
        }
        Assertions.assertTrue((boolean)hasImageOutput, (String)"No Image Output");
        Assertions.assertTrue((boolean)hasLineText, (String)"No Line Text");
        if (!this.enableBokehTest) {
            LOGGER.info("Bokeh test is skipped");
            return;
        }
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("from bokeh.io import output_notebook, show\nfrom bokeh.plotting import figure\noutput_notebook()", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code(), (String)context.out.toString());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        if (interpreterResultMessages.size() == 3) {
            Assertions.assertEquals((int)3, (int)interpreterResultMessages.size());
            Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
            Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(1)).getData().contains("Loading BokehJS"));
            Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(2)).getType());
            Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(2)).getData().contains("BokehJS is being loaded"));
        } else {
            Assertions.assertEquals((int)2, (int)interpreterResultMessages.size());
            Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
            Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("Loading BokehJS"));
            Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
            Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(1)).getData().contains("BokehJS is being loaded"));
        }
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("from bokeh.plotting import figure, output_file, show\nx = [1, 2, 3, 4, 5]\ny = [6, 7, 2, 4, 5]\np = figure(title=\"simple line example\", x_axis_label='x', y_axis_label='y')\np.line(x, y, legend_label=\"Temp.\", line_width=2)\nshow(p)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code(), (String)context.out.toInterpreterResultMessage().toString());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        if (interpreterResultMessages.size() == 3) {
            Assertions.assertEquals((int)3, (int)interpreterResultMessages.size());
            Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
            Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(2)).getType());
            Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(2)).getData().contains("docs_json"));
        } else {
            Assertions.assertEquals((int)2, (int)interpreterResultMessages.size());
            Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
            Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
            Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(1)).getData().contains("docs_json"));
        }
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("import pandas as pd, numpy as np\nidx = pd.date_range('1/1/2000', periods=1000)\ndf = pd.DataFrame(np.random.randn(1000, 4), index=idx, columns=list('ABCD')).cumsum()\nimport hvplot.pandas\ndf.hvplot()", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code(), (String)((InterpreterResultMessage)context.out.toInterpreterResultMessage().get(0)).getData());
        Assertions.assertTrue((boolean)context.out.toString().contains("docs_json"), (String)context.out.toString());
    }

    public void testHtmlOutput() throws InterpreterException, IOException {
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.interpreter.interpret("        import altair as alt\n        print(alt.renderers.active)\n        alt.renderers.enable(\"colab\")\n        import altair as alt\n        # load a simple dataset as a pandas DataFrame\n        from vega_datasets import data\n        cars = data.cars()\n        \n        alt.Chart(cars).mark_point().encode(\n            x='Horsepower',\n            y='Miles_per_Gallon',\n            color='Origin',\n        ).interactive()", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assertions.assertEquals((int)2, (int)context.out.size());
        Assertions.assertEquals((Object)InterpreterResult.Type.TEXT, (Object)((InterpreterResultMessage)context.out.toInterpreterResultMessage().get(0)).getType());
        Assertions.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)context.out.toInterpreterResultMessage().get(1)).getType());
    }

    @Test
    void testIpython_shouldNotHang_whenCallingAutoCompleteAndInterpretConcurrently() throws InterpreterException, InterruptedException, TimeoutException, ExecutionException {
        this.tearDown();
        Properties properties = this.initIntpProperties();
        this.startInterpreter(properties);
        String code = "import time\nprint(1)\ntime.sleep(10)\nprint(2)";
        String base = "time.";
        ExecutorService pool = Executors.newFixedThreadPool(2);
        FutureTask<InterpreterResult> interpretFuture = new FutureTask<InterpreterResult>(new Callable<InterpreterResult>(){

            @Override
            public InterpreterResult call() throws Exception {
                return IPythonInterpreterTest.this.interpreter.interpret("import time\nprint(1)\ntime.sleep(10)\nprint(2)", IPythonInterpreterTest.this.getInterpreterContext());
            }
        });
        FutureTask<List<InterpreterCompletion>> completionFuture = new FutureTask<List<InterpreterCompletion>>(new Callable<List<InterpreterCompletion>>(){

            @Override
            public List<InterpreterCompletion> call() throws Exception {
                return IPythonInterpreterTest.this.interpreter.completion("time.", "time.".length(), IPythonInterpreterTest.this.getInterpreterContext());
            }
        });
        pool.execute(interpretFuture);
        Thread.sleep(3000L);
        pool.execute(completionFuture);
        InterpreterResult res = interpretFuture.get(20000L, TimeUnit.MILLISECONDS);
        List<InterpreterCompletion> autoRes = completionFuture.get(3000L, TimeUnit.MILLISECONDS);
        Assertions.assertEquals((Object)"SUCCESS", (Object)res.code().name());
        Assertions.assertTrue((autoRes.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    void testGrpcFrameSize() throws InterpreterException, IOException {
        this.tearDown();
        Properties properties = this.initIntpProperties();
        properties.setProperty("zeppelin.jupyter.kernel.grpc.message_size", "4000");
        this.startInterpreter(properties);
        InterpreterResult result = this.interpreter.interpret("from __future__ import print_function", this.getInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        InterpreterContext context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('1'*4000)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assertions.assertEquals((int)1, (int)interpreterResultMessages.size());
        Assertions.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("exceeds maximum size 4000"));
        result = this.interpreter.interpret("print(1)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        this.tearDown();
        properties.setProperty("zeppelin.ipython.grpc.message_size", "5000");
        this.startInterpreter(properties);
        result = this.interpreter.interpret("from __future__ import print_function", this.getInterpreterContext());
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = this.getInterpreterContext();
        result = this.interpreter.interpret("print('1'*3000)", context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
    }

    @Test
    void testIPythonProcessKilled() throws InterruptedException, TimeoutException {
        final Waiter waiter = new Waiter();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    InterpreterResult result = IPythonInterpreterTest.this.interpreter.interpret("import time\ntime.sleep(1000)", IPythonInterpreterTest.this.getInterpreterContext());
                    waiter.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
                }
                catch (InterpreterException e) {
                    waiter.fail("Should not throw exception\n" + ExceptionUtils.getStackTrace((Throwable)e));
                }
                waiter.resume();
            }
        };
        thread.start();
        Thread.sleep(3000L);
        IPythonInterpreter iPythonInterpreter = (IPythonInterpreter)((LazyOpenInterpreter)this.interpreter).getInnerInterpreter();
        iPythonInterpreter.getKernelProcessLauncher().stop();
        waiter.await(3000L);
    }

    @Test
    public void testIPythonFailToLaunch() throws InterpreterException {
        this.tearDown();
        Properties properties = this.initIntpProperties();
        properties.setProperty("zeppelin.python", "invalid_python");
        try {
            this.startInterpreter(properties);
            Assertions.fail((String)"Should not be able to start IPythonInterpreter");
        }
        catch (InterpreterException e) {
            String exceptionMsg = ExceptionUtils.getStackTrace((Throwable)e);
            Assertions.assertTrue((boolean)exceptionMsg.contains("No such file or directory"), (String)exceptionMsg);
        }
    }
}

