/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.apache.zeppelin.python.PythonInterpreterPandasSql;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PythonInterpreterPandasSqlTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonInterpreterPandasSqlTest.class);
    protected boolean useIPython;
    private InterpreterGroup intpGroup;
    private PythonInterpreterPandasSql pandasSqlInterpreter;
    private PythonInterpreter pythonInterpreter;
    private IPythonInterpreter ipythonInterpreter;
    private InterpreterContext context;

    PythonInterpreterPandasSqlTest(boolean useIPython) {
        this.useIPython = useIPython;
        LOGGER.info("Test PythonInterpreterPandasSqlTest while useIPython={}", (Object)useIPython);
    }

    @BeforeEach
    public void setUp() throws InterpreterException {
        Properties p = new Properties();
        p.setProperty("zeppelin.python", "python");
        p.setProperty("zeppelin.python.maxResult", "100");
        p.setProperty("zeppelin.python.useIPython", "" + this.useIPython);
        p.setProperty("zeppelin.python.gatewayserver_address", "127.0.0.1");
        this.intpGroup = new InterpreterGroup();
        this.context = this.getInterpreterContext();
        InterpreterContext.set((InterpreterContext)this.context);
        this.pythonInterpreter = new PythonInterpreter(p);
        this.ipythonInterpreter = new IPythonInterpreter(p);
        this.pandasSqlInterpreter = new PythonInterpreterPandasSql(p);
        this.pythonInterpreter.setInterpreterGroup(this.intpGroup);
        this.ipythonInterpreter.setInterpreterGroup(this.intpGroup);
        this.pandasSqlInterpreter.setInterpreterGroup(this.intpGroup);
        List<Interpreter> interpreters = Arrays.asList(this.pythonInterpreter, this.ipythonInterpreter, this.pandasSqlInterpreter);
        this.intpGroup.put("session_1", interpreters);
        this.pythonInterpreter.open();
        InterpreterResult ret = this.pythonInterpreter.interpret("print(\"python initialized\")\n", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)ret.message().toString());
        this.pandasSqlInterpreter.open();
    }

    @AfterEach
    public void afterTest() throws InterpreterException {
        this.pandasSqlInterpreter.close();
    }

    @Test
    public void dependenciesAreInstalled() throws InterpreterException {
        InterpreterResult ret = this.pythonInterpreter.interpret("import pandas\nimport pandasql\nimport numpy\n", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)ret.message().toString());
    }

    @Test
    public void errorMessageIfDependenciesNotInstalled() throws InterpreterException {
        this.context = this.getInterpreterContext();
        InterpreterResult ret = this.pandasSqlInterpreter.interpret("SELECT * from something", this.context);
        Assertions.assertNotNull((Object)ret);
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)ret.code(), (String)this.context.out.toString());
        if (this.useIPython) {
            Assertions.assertTrue((boolean)this.context.out.toString().contains("no such table: something"), (String)this.context.out.toString());
        } else {
            Assertions.assertTrue((boolean)ret.toString().contains("no such table: something"), (String)ret.toString());
        }
    }

    @Test
    public void sqlOverTestDataPrintsTable() throws IOException, InterpreterException {
        InterpreterResult ret = this.pythonInterpreter.interpret("import pandas as pd\nimport numpy as np", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)ret.message().toString());
        ret = this.pythonInterpreter.interpret("df2 = pd.DataFrame({ 'age'  : np.array([33, 51, 51, 34]), 'name' : pd.Categorical(['moon','jobs','gates','park'])})", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)ret.message().toString());
        this.context = this.getInterpreterContext();
        ret = this.pandasSqlInterpreter.interpret("select name, age from df2 where age < 40", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)this.context.out.toString());
        Assertions.assertEquals((Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)this.context.out.toInterpreterResultMessage().get(0)).getType(), (String)this.context.out.toString());
        Assertions.assertTrue((this.context.out.toString().indexOf("moon\t33") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.context.out.toString().indexOf("park\t34") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.pandasSqlInterpreter.interpret("select case when name==\"aa\" then name else name end from df2", this.context).code());
    }

    @Test
    public void testInIPython() throws IOException, InterpreterException {
        InterpreterResult ret = this.pythonInterpreter.interpret("import pandas as pd\nimport numpy as np", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)ret.message().toString());
        ret = this.pythonInterpreter.interpret("df2 = pd.DataFrame({ 'age'  : np.array([33, 51, 51, 34]), 'name' : pd.Categorical(['moon','jobs','gates','park'])})", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)ret.message().toString());
        ret = this.pandasSqlInterpreter.interpret("select name, age from df2 where age < 40", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)this.context.out.toString());
        Assertions.assertEquals((Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)this.context.out.toInterpreterResultMessage().get(1)).getType(), (String)this.context.out.toString());
        Assertions.assertTrue((this.context.out.toString().indexOf("moon\t33") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.context.out.toString().indexOf("park\t34") > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.pandasSqlInterpreter.interpret("select case when name==\"aa\" then name else name end from df2", this.context).code());
    }

    @Test
    public void badSqlSyntaxFails() throws InterpreterException {
        this.context = this.getInterpreterContext();
        InterpreterResult ret = this.pandasSqlInterpreter.interpret("select wrong syntax", this.context);
        Assertions.assertNotNull((Object)ret, (String)"Interpreter returned 'null'");
        Assertions.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)ret.code(), (String)this.context.out.toString());
    }

    @Test
    public void showDataFrame() throws IOException, InterpreterException {
        this.pythonInterpreter.interpret("import pandas as pd", this.context);
        this.pythonInterpreter.interpret("import numpy as np", this.context);
        this.pythonInterpreter.interpret("index = pd.Index([10, 11, 12, 13], name='index_name')", this.context);
        this.pythonInterpreter.interpret("d1 = {1 : [np.nan, 1, 2, 3], 'two' : [3., 4., 5., 6.7]}", this.context);
        InterpreterResult ret = this.pythonInterpreter.interpret("df1 = pd.DataFrame(d1, index=index)", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)ret.message().toString());
        this.context = this.getInterpreterContext();
        ret = this.pythonInterpreter.interpret("z.show(df1, show_index=True)", this.context);
        Assertions.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)ret.code(), (String)this.context.out.toString());
        Assertions.assertEquals((Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)this.context.out.toInterpreterResultMessage().get(0)).getType(), (String)this.context.out.toString());
        Assertions.assertTrue((boolean)this.context.out.toString().contains("index_name"));
        Assertions.assertTrue((boolean)this.context.out.toString().contains("nan"));
        Assertions.assertTrue((boolean)this.context.out.toString().contains("6.7"));
    }

    private InterpreterContext getInterpreterContext() {
        return InterpreterContext.builder().setNoteId("noteId").setParagraphId("paragraphId").setInterpreterOut(new InterpreterOutput()).setIntpEventClient((RemoteInterpreterEventClient)Mockito.mock(RemoteInterpreterEventClient.class)).build();
    }
}

