/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterPropertyBuilder;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.python.PythonProcess;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class PythonInterpreter
extends Interpreter {
    Logger logger = LoggerFactory.getLogger(PythonInterpreter.class);
    public static final String BOOTSTRAP_PY = "/bootstrap.py";
    public static final String BOOTSTRAP_INPUT_PY = "/bootstrap_input.py";
    public static final String ZEPPELIN_PYTHON = "zeppelin.python";
    public static final String DEFAULT_ZEPPELIN_PYTHON = "python";
    private Integer port;
    private GatewayServer gatewayServer;
    private long pythonPid;
    private Boolean py4J = false;
    private InterpreterContext context;
    PythonProcess process = null;

    public PythonInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        this.logger.info("Starting Python interpreter .....");
        this.logger.info("Python path is set to:" + this.property.getProperty(ZEPPELIN_PYTHON));
        this.process = this.getPythonProcess();
        try {
            this.process.open();
        }
        catch (IOException e) {
            this.logger.error("Can't start the python process", (Throwable)e);
        }
        try {
            this.logger.info("python PID : " + this.process.getPid());
        }
        catch (Exception e) {
            this.logger.warn("Can't find python pid process", (Throwable)e);
        }
        try {
            this.logger.info("Bootstrap interpreter with /bootstrap.py");
            this.bootStrapInterpreter(BOOTSTRAP_PY);
        }
        catch (IOException e) {
            this.logger.error("Can't execute /bootstrap.py to initiate python process", (Throwable)e);
        }
        this.py4J = this.isPy4jInstalled();
        if (this.py4J.booleanValue()) {
            this.port = this.findRandomOpenPortOnAllLocalInterfaces();
            this.logger.info("Py4j gateway port : " + this.port);
            try {
                this.gatewayServer = new GatewayServer((Object)this, this.port.intValue());
                this.gatewayServer.start();
                this.logger.info("Bootstrap inputs with /bootstrap_input.py");
                this.bootStrapInterpreter(BOOTSTRAP_INPUT_PY);
            }
            catch (IOException e) {
                this.logger.error("Can't execute /bootstrap_input.py to initialize Zeppelin inputs in python process", (Throwable)e);
            }
        }
    }

    public void close() {
        this.logger.info("closing Python interpreter .....");
        try {
            if (this.process != null) {
                this.process.close();
            }
            if (this.gatewayServer != null) {
                this.gatewayServer.shutdown();
            }
        }
        catch (IOException e) {
            this.logger.error("Can't close the interpreter", (Throwable)e);
        }
    }

    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        this.context = contextInterpreter;
        if (cmd == null || cmd.isEmpty()) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, "");
        }
        String output = this.sendCommandToPython(cmd);
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, output.replaceAll(">>>", "").replaceAll("\\.\\.\\.", "").trim());
    }

    public void cancel(InterpreterContext context) {
        try {
            this.process.interrupt();
        }
        catch (IOException e) {
            this.logger.error("Can't interrupt the python interpreter", (Throwable)e);
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(PythonInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public List<InterpreterCompletion> completion(String buf, int cursor) {
        return null;
    }

    public PythonProcess getPythonProcess() {
        if (this.process == null) {
            return new PythonProcess(this.getProperty(ZEPPELIN_PYTHON));
        }
        return this.process;
    }

    private Job getRunningJob(String paragraphId) {
        Job foundJob = null;
        Collection jobsRunning = this.getScheduler().getJobsRunning();
        for (Job job : jobsRunning) {
            if (!job.getId().equals(paragraphId)) continue;
            foundJob = job;
            break;
        }
        return foundJob;
    }

    private String sendCommandToPython(String cmd) {
        String output = "";
        this.logger.info("Sending : \n" + (cmd.length() > 200 ? cmd.substring(0, 200) + "..." : cmd));
        try {
            output = this.process.sendAndGetResult(cmd);
        }
        catch (IOException e) {
            this.logger.error("Error when sending commands to python process", (Throwable)e);
        }
        return output;
    }

    private void bootStrapInterpreter(String file) throws IOException {
        BufferedReader bootstrapReader = new BufferedReader(new InputStreamReader(PythonInterpreter.class.getResourceAsStream(file)));
        String line = null;
        String bootstrapCode = "";
        while ((line = bootstrapReader.readLine()) != null) {
            bootstrapCode = bootstrapCode + line + "\n";
        }
        if (this.py4J.booleanValue() && this.port != null && this.port != -1) {
            bootstrapCode = bootstrapCode.replaceAll("\\%PORT\\%", this.port.toString());
        }
        this.logger.info("Bootstrap python interpreter with code from \n " + file);
        this.sendCommandToPython(bootstrapCode);
    }

    public GUI getGui() {
        return this.context.getGui();
    }

    public Integer getPy4JPort() {
        return this.port;
    }

    public Boolean isPy4jInstalled() {
        String output = this.sendCommandToPython("\n\nimport py4j\n");
        if (output.contains("ImportError")) {
            return false;
        }
        return true;
    }

    private int findRandomOpenPortOnAllLocalInterfaces() {
        Integer port = -1;
        try (ServerSocket socket = new ServerSocket(0);){
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            this.logger.error("Can't find an open port", (Throwable)e);
        }
        return port;
    }

    static {
        Interpreter.register((String)DEFAULT_ZEPPELIN_PYTHON, (String)DEFAULT_ZEPPELIN_PYTHON, (String)PythonInterpreter.class.getName(), (Map)new InterpreterPropertyBuilder().add(ZEPPELIN_PYTHON, DEFAULT_ZEPPELIN_PYTHON, "Python directory. Default : python (assume python is in your $PATH)").build());
    }
}

