/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.apache.zeppelin.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonCondaInterpreter
extends Interpreter {
    Logger logger = LoggerFactory.getLogger(PythonCondaInterpreter.class);
    public static final String ZEPPELIN_PYTHON = "zeppelin.python";
    public static final String CONDA_PYTHON_PATH = "/bin/python";
    public static final String DEFAULT_ZEPPELIN_PYTHON = "python";
    public static final Pattern PATTERN_OUTPUT_ENV_LIST = Pattern.compile("([^\\s]*)[\\s*]*\\s(.*)");
    public static final Pattern PATTERN_COMMAND_ENV_LIST = Pattern.compile("env\\s*list\\s?");
    public static final Pattern PATTERN_COMMAND_ENV = Pattern.compile("env\\s*(.*)");
    public static final Pattern PATTERN_COMMAND_LIST = Pattern.compile("list");
    public static final Pattern PATTERN_COMMAND_CREATE = Pattern.compile("create\\s*(.*)");
    public static final Pattern PATTERN_COMMAND_ACTIVATE = Pattern.compile("activate\\s*(.*)");
    public static final Pattern PATTERN_COMMAND_DEACTIVATE = Pattern.compile("deactivate");
    public static final Pattern PATTERN_COMMAND_INSTALL = Pattern.compile("install\\s*(.*)");
    public static final Pattern PATTERN_COMMAND_UNINSTALL = Pattern.compile("uninstall\\s*(.*)");
    public static final Pattern PATTERN_COMMAND_HELP = Pattern.compile("help");
    public static final Pattern PATTERN_COMMAND_INFO = Pattern.compile("info");

    public PythonCondaInterpreter(Properties property) {
        super(property);
    }

    public void open() {
    }

    public void close() {
    }

    public InterpreterResult interpret(String st, InterpreterContext context) {
        InterpreterOutput out = context.out;
        Matcher activateMatcher = PATTERN_COMMAND_ACTIVATE.matcher(st);
        Matcher createMatcher = PATTERN_COMMAND_CREATE.matcher(st);
        Matcher installMatcher = PATTERN_COMMAND_INSTALL.matcher(st);
        Matcher uninstallMatcher = PATTERN_COMMAND_UNINSTALL.matcher(st);
        Matcher envMatcher = PATTERN_COMMAND_ENV.matcher(st);
        try {
            if (PATTERN_COMMAND_ENV_LIST.matcher(st).matches()) {
                String result = this.runCondaEnvList();
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.HTML, result);
            }
            if (envMatcher.matches()) {
                String result = this.runCondaEnv(PythonCondaInterpreter.getRestArgsFromMatcher(envMatcher));
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.HTML, result);
            }
            if (PATTERN_COMMAND_LIST.matcher(st).matches()) {
                String result = this.runCondaList();
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.HTML, result);
            }
            if (createMatcher.matches()) {
                String result = this.runCondaCreate(PythonCondaInterpreter.getRestArgsFromMatcher(createMatcher));
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.HTML, result);
            }
            if (activateMatcher.matches()) {
                String envName = activateMatcher.group(1).trim();
                return this.runCondaActivate(envName);
            }
            if (PATTERN_COMMAND_DEACTIVATE.matcher(st).matches()) {
                return this.runCondaDeactivate();
            }
            if (installMatcher.matches()) {
                String result = this.runCondaInstall(PythonCondaInterpreter.getRestArgsFromMatcher(installMatcher));
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.HTML, result);
            }
            if (uninstallMatcher.matches()) {
                String result = this.runCondaUninstall(PythonCondaInterpreter.getRestArgsFromMatcher(uninstallMatcher));
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.HTML, result);
            }
            if (st == null || PATTERN_COMMAND_HELP.matcher(st).matches()) {
                this.runCondaHelp(out);
                return new InterpreterResult(InterpreterResult.Code.SUCCESS);
            }
            if (PATTERN_COMMAND_INFO.matcher(st).matches()) {
                String result = this.runCondaInfo();
                return new InterpreterResult(InterpreterResult.Code.SUCCESS, InterpreterResult.Type.HTML, result);
            }
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Not supported command: " + st);
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            throw new InterpreterException((Throwable)e);
        }
    }

    private void changePythonEnvironment(String envName) throws IOException, InterruptedException {
        String binPath;
        PythonInterpreter python;
        block2: {
            block1: {
                python = this.getPythonInterpreter();
                binPath = null;
                if (envName != null) break block1;
                binPath = this.getProperty(ZEPPELIN_PYTHON);
                if (binPath != null) break block2;
                binPath = DEFAULT_ZEPPELIN_PYTHON;
                break block2;
            }
            Map<String, String> envList = this.getCondaEnvs();
            for (String name : envList.keySet()) {
                if (!envName.equals(name)) continue;
                binPath = envList.get(name) + CONDA_PYTHON_PATH;
                break;
            }
        }
        python.setPythonCommand(binPath);
    }

    private void restartPythonProcess() {
        PythonInterpreter python = this.getPythonInterpreter();
        python.close();
        python.open();
    }

    protected PythonInterpreter getPythonInterpreter() {
        LazyOpenInterpreter lazy = null;
        PythonInterpreter python = null;
        Interpreter p = this.getInterpreterInTheSameSessionByClassName(PythonInterpreter.class.getName());
        while (p instanceof WrappedInterpreter) {
            if (p instanceof LazyOpenInterpreter) {
                lazy = (LazyOpenInterpreter)p;
            }
            p = ((WrappedInterpreter)p).getInnerInterpreter();
        }
        python = (PythonInterpreter)p;
        if (lazy != null) {
            lazy.open();
        }
        return python;
    }

    public static String runCondaCommandForTextOutput(String title, List<String> commands) throws IOException, InterruptedException {
        String result = PythonCondaInterpreter.runCommand(commands);
        return PythonCondaInterpreter.wrapCondaBasicOutputStyle(title, result);
    }

    private String runCondaCommandForTableOutput(String title, List<String> commands) throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        String result = PythonCondaInterpreter.runCommand(commands);
        Map<String, String> envPerName = PythonCondaInterpreter.parseCondaCommonStdout(result);
        return PythonCondaInterpreter.wrapCondaTableOutputStyle(title, envPerName);
    }

    protected Map<String, String> getCondaEnvs() throws IOException, InterruptedException {
        String result = PythonCondaInterpreter.runCommand("conda", "env", "list");
        Map<String, String> envList = PythonCondaInterpreter.parseCondaCommonStdout(result);
        return envList;
    }

    private String runCondaEnvList() throws IOException, InterruptedException {
        return PythonCondaInterpreter.wrapCondaTableOutputStyle("Environment List", this.getCondaEnvs());
    }

    private String runCondaEnv(List<String> restArgs) throws IOException, InterruptedException {
        restArgs.add(0, "conda");
        restArgs.add(1, "env");
        restArgs.add(3, "--yes");
        return PythonCondaInterpreter.runCondaCommandForTextOutput(null, restArgs);
    }

    private InterpreterResult runCondaActivate(String envName) throws IOException, InterruptedException {
        if (null == envName || envName.isEmpty()) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Env name should be specified");
        }
        this.changePythonEnvironment(envName);
        this.restartPythonProcess();
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, "'" + envName + "' is activated");
    }

    private InterpreterResult runCondaDeactivate() throws IOException, InterruptedException {
        this.changePythonEnvironment(null);
        this.restartPythonProcess();
        return new InterpreterResult(InterpreterResult.Code.SUCCESS, "Deactivated");
    }

    private String runCondaList() throws IOException, InterruptedException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("conda");
        commands.add("list");
        return this.runCondaCommandForTableOutput("Installed Package List", commands);
    }

    private void runCondaHelp(InterpreterOutput out) {
        try {
            out.setType(InterpreterResult.Type.HTML);
            out.writeResource("output_templates/conda_usage.html");
        }
        catch (IOException e) {
            this.logger.error("Can't print usage", (Throwable)e);
        }
    }

    private String runCondaInfo() throws IOException, InterruptedException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("conda");
        commands.add("info");
        return PythonCondaInterpreter.runCondaCommandForTextOutput("Conda Information", commands);
    }

    private String runCondaCreate(List<String> restArgs) throws IOException, InterruptedException {
        restArgs.add(0, "conda");
        restArgs.add(1, "create");
        restArgs.add(2, "--yes");
        return PythonCondaInterpreter.runCondaCommandForTextOutput("Environment Creation", restArgs);
    }

    private String runCondaInstall(List<String> restArgs) throws IOException, InterruptedException {
        restArgs.add(0, "conda");
        restArgs.add(1, "install");
        restArgs.add(2, "--yes");
        return PythonCondaInterpreter.runCondaCommandForTextOutput("Package Installation", restArgs);
    }

    private String runCondaUninstall(List<String> restArgs) throws IOException, InterruptedException {
        restArgs.add(0, "conda");
        restArgs.add(1, "uninstall");
        restArgs.add(2, "--yes");
        return PythonCondaInterpreter.runCondaCommandForTextOutput("Package Uninstallation", restArgs);
    }

    public static String wrapCondaBasicOutputStyle(String title, String content) {
        StringBuilder sb = new StringBuilder();
        if (null != title && !title.isEmpty()) {
            sb.append("<h4>").append(title).append("</h4>\n").append("</div><br />\n");
        }
        sb.append("<div style=\"white-space:pre-wrap;\">\n").append(content).append("</div>");
        return sb.toString();
    }

    public static String wrapCondaTableOutputStyle(String title, Map<String, String> kv) {
        StringBuilder sb = new StringBuilder();
        if (null != title && !title.isEmpty()) {
            sb.append("<h4>").append(title).append("</h4>\n");
        }
        sb.append("<div style=\"display:table;white-space:pre-wrap;\">\n");
        for (String name : kv.keySet()) {
            String path = kv.get(name);
            sb.append(String.format("<div style=\"display:table-row\"><div style=\"display:table-cell;width:150px\">%s</div><div style=\"display:table-cell;\">%s</div></div>\n", name, path));
        }
        sb.append("</div>\n");
        return sb.toString();
    }

    public static Map<String, String> parseCondaCommonStdout(String out) throws IOException, InterruptedException {
        String[] lines;
        LinkedHashMap<String, String> kv = new LinkedHashMap<String, String>();
        for (String s : lines = out.split("\n")) {
            Matcher match;
            if (s == null || s.isEmpty() || s.startsWith("#") || !(match = PATTERN_OUTPUT_ENV_LIST.matcher(s)).matches()) continue;
            kv.put(match.group(1), match.group(2));
        }
        return kv;
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NONE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        PythonInterpreter pythonInterpreter = this.getPythonInterpreter();
        if (pythonInterpreter != null) {
            return pythonInterpreter.getScheduler();
        }
        return null;
    }

    public static String runCommand(List<String> commands) throws IOException, InterruptedException {
        String line;
        StringBuilder sb = new StringBuilder();
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        InputStream stdout = process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        int r = process.waitFor();
        if (r != 0) {
            throw new RuntimeException("Failed to execute `" + StringUtils.join(commands, (String)" ") + "` exited with " + r);
        }
        return sb.toString();
    }

    public static String runCommand(String ... command) throws IOException, InterruptedException {
        ArrayList<String> list = new ArrayList<String>(command.length);
        for (String arg : command) {
            list.add(arg);
        }
        return PythonCondaInterpreter.runCommand(list);
    }

    public static List<String> getRestArgsFromMatcher(Matcher m) {
        return new ArrayList<String>(Arrays.asList(m.group(1).split(" ")));
    }
}

