/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonProcess {
    private static final Logger logger = LoggerFactory.getLogger(PythonProcess.class);
    private static final String STATEMENT_END = "*!?flush reader!?*";
    InputStream stdout;
    OutputStream stdin;
    PrintWriter writer;
    BufferedReader reader;
    Process process;
    private String binPath;
    private String pythonPath;
    private long pid;

    public PythonProcess(String binPath, String pythonPath) {
        this.binPath = binPath;
        this.pythonPath = pythonPath;
    }

    public void open() throws IOException {
        ProcessBuilder builder;
        boolean hasParams;
        boolean bl = hasParams = this.binPath.split(" ").length > 1;
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            builder = hasParams ? new ProcessBuilder(this.binPath.split(" ")) : new ProcessBuilder(this.binPath, "-iu");
        } else {
            String cmd = hasParams ? this.binPath : this.binPath + " -iu";
            builder = new ProcessBuilder("bash", "-c", cmd);
            if (this.pythonPath != null) {
                builder.environment().put("PYTHONPATH", this.pythonPath);
            }
        }
        builder.redirectErrorStream(true);
        this.process = builder.start();
        this.stdout = this.process.getInputStream();
        this.stdin = this.process.getOutputStream();
        this.writer = new PrintWriter(this.stdin, true);
        this.reader = new BufferedReader(new InputStreamReader(this.stdout));
        try {
            this.pid = this.findPid();
        }
        catch (Exception e) {
            logger.warn("Can't find python pid process", (Throwable)e);
            this.pid = -1L;
        }
    }

    public void close() throws IOException {
        this.process.destroy();
        this.reader.close();
        this.writer.close();
        this.stdin.close();
        this.stdout.close();
    }

    public void interrupt() throws IOException {
        if (this.pid > -1L) {
            logger.info("Sending SIGINT signal to PID : " + this.pid);
            Runtime.getRuntime().exec("kill -SIGINT " + this.pid);
        } else {
            logger.warn("Non UNIX/Linux system, close the interpreter");
            this.close();
        }
    }

    public String sendAndGetResult(String cmd) throws IOException {
        this.writer.println(cmd);
        this.writer.println();
        this.writer.println("\"*!?flush reader!?*\"");
        StringBuilder output = new StringBuilder();
        String line = null;
        while ((line = this.reader.readLine()) != null && !line.contains(STATEMENT_END)) {
            logger.debug("Read line from python shell : " + line);
            output.append(line + "\n");
        }
        return output.toString();
    }

    private long findPid() throws NoSuchFieldException, IllegalAccessException {
        long pid = -1L;
        if (this.process.getClass().getName().equals("java.lang.UNIXProcess")) {
            Field f = this.process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            pid = f.getLong(this.process);
            f.setAccessible(false);
        }
        return pid;
    }

    public long getPid() {
        return this.pid;
    }
}

