/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.apache.zeppelin.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonDockerInterpreter
extends Interpreter {
    Logger logger = LoggerFactory.getLogger(PythonDockerInterpreter.class);
    Pattern activatePattern = Pattern.compile("activate\\s*(.*)");
    Pattern deactivatePattern = Pattern.compile("deactivate");
    Pattern helpPattern = Pattern.compile("help");
    private File zeppelinHome;

    public PythonDockerInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        this.zeppelinHome = System.getenv("ZEPPELIN_HOME") != null ? new File(System.getenv("ZEPPELIN_HOME")) : Paths.get("..", new String[0]).toAbsolutePath().toFile();
    }

    public void close() {
    }

    public InterpreterResult interpret(String st, InterpreterContext context) {
        File pythonScript = new File(this.getPythonInterpreter().getScriptPath());
        InterpreterOutput out = context.out;
        Matcher activateMatcher = this.activatePattern.matcher(st);
        Matcher deactivateMatcher = this.deactivatePattern.matcher(st);
        Matcher helpMatcher = this.helpPattern.matcher(st);
        if (st == null || st.isEmpty() || helpMatcher.matches()) {
            this.printUsage(out);
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        if (activateMatcher.matches()) {
            String image = activateMatcher.group(1);
            this.pull(out, image);
            String mountPythonScript = "-v " + pythonScript.getParentFile().getAbsolutePath() + ":/_zeppelin_tmp ";
            String mountPy4j = "-v " + this.zeppelinHome.getAbsolutePath() + ":/_zeppelin ";
            String pythonPath = ":/_zeppelin/interpreter/python/py4j-0.9.2/src::/_zeppelin/interpreter/lib/python";
            this.setPythonCommand("docker run -i --rm " + mountPythonScript + mountPy4j + "-e PYTHONPATH=\"" + pythonPath + "\" " + image + " " + this.getPythonInterpreter().getPythonBindPath() + " " + "/_zeppelin_tmp/" + pythonScript.getName());
            this.restartPythonProcess();
            out.clear();
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, "\"" + image + "\" activated");
        }
        if (deactivateMatcher.matches()) {
            this.setPythonCommand(null);
            this.restartPythonProcess();
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, "Deactivated");
        }
        return new InterpreterResult(InterpreterResult.Code.ERROR, "Not supported command: " + st);
    }

    public void setPythonCommand(String cmd) {
        PythonInterpreter python = this.getPythonInterpreter();
        python.setPythonCommand(cmd);
    }

    private void printUsage(InterpreterOutput out) {
        try {
            out.setType(InterpreterResult.Type.HTML);
            out.writeResource("output_templates/docker_usage.html");
        }
        catch (IOException e) {
            this.logger.error("Can't print usage", (Throwable)e);
        }
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NONE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        PythonInterpreter pythonInterpreter = this.getPythonInterpreter();
        if (pythonInterpreter != null) {
            return pythonInterpreter.getScheduler();
        }
        return null;
    }

    private void restartPythonProcess() {
        PythonInterpreter python = this.getPythonInterpreter();
        python.close();
        python.open();
    }

    protected PythonInterpreter getPythonInterpreter() {
        LazyOpenInterpreter lazy = null;
        PythonInterpreter python = null;
        Interpreter p = this.getInterpreterInTheSameSessionByClassName(PythonInterpreter.class.getName());
        while (p instanceof WrappedInterpreter) {
            if (p instanceof LazyOpenInterpreter) {
                lazy = (LazyOpenInterpreter)p;
            }
            p = ((WrappedInterpreter)p).getInnerInterpreter();
        }
        python = (PythonInterpreter)p;
        if (lazy != null) {
            lazy.open();
        }
        return python;
    }

    public boolean pull(InterpreterOutput out, String image) {
        int exit = 0;
        try {
            exit = this.runCommand(out, "docker", "pull", image);
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InterpreterException((Throwable)e);
        }
        return exit == 0;
    }

    protected int runCommand(InterpreterOutput out, String ... command) throws IOException, InterruptedException {
        String line;
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        InputStream stdout = process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
        while ((line = br.readLine()) != null) {
            out.write(line + "\n");
        }
        int r = process.waitFor();
        return r;
    }
}

