/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.ui.CheckBox;
import org.apache.zeppelin.display.ui.Select;
import org.apache.zeppelin.display.ui.TextBox;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPythonInterpreterTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPythonInterpreterTest.class);
    private IPythonInterpreter interpreter;

    public void startInterpreter(Properties properties) throws InterpreterException {
        this.interpreter = new IPythonInterpreter(properties);
        InterpreterGroup mockInterpreterGroup = (InterpreterGroup)Mockito.mock(InterpreterGroup.class);
        this.interpreter.setInterpreterGroup(mockInterpreterGroup);
        this.interpreter.open();
    }

    @After
    public void close() throws InterpreterException {
        this.interpreter.close();
    }

    @Test
    public void testIPython() throws IOException, InterruptedException, InterpreterException {
        this.startInterpreter(new Properties());
        IPythonInterpreterTest.testInterpreter((Interpreter)this.interpreter);
    }

    @Test
    public void testGrpcFrameSize() throws InterpreterException, IOException {
        Properties properties = new Properties();
        properties.setProperty("zeppelin.ipython.grpc.message_size", "4");
        this.startInterpreter(properties);
        InterpreterResult result = this.interpreter.interpret("from __future__ import print_function", IPythonInterpreterTest.getInterpreterContext());
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        InterpreterContext context = IPythonInterpreterTest.getInterpreterContext();
        result = this.interpreter.interpret("print(11111111111111111111111111111)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("Frame size 32 exceeds maximum: 4"));
        result = this.interpreter.interpret("print(1)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        this.close();
        properties.setProperty("zeppelin.ipython.grpc.message_size", "40");
        this.startInterpreter(properties);
        result = this.interpreter.interpret("from __future__ import print_function", IPythonInterpreterTest.getInterpreterContext());
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = this.interpreter.interpret("print(11111111111111111111111111111)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
    }

    public static void testInterpreter(final Interpreter interpreter) throws IOException, InterruptedException, InterpreterException {
        InterpreterResult result = interpreter.interpret("from __future__ import print_function", IPythonInterpreterTest.getInterpreterContext());
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        InterpreterContext context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("import sys\nprint(sys.version[0])", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Thread.sleep(100L);
        List interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        boolean isPython2 = ((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().equals("2\n");
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("'hello world'", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"'hello world'", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("print(u'\u4f60\u597d')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"\u4f60\u597d\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("'hello world'\n'hello world2'", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"'hello world2'", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("print('hello world')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"hello world\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("print('hello world')\nprint('hello world2')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"hello world\nhello world2\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("abc=1", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)0L, (long)interpreterResultMessages.size());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("if abc > 0:\n\tprint('True')\nelse:\n\tprint('False')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"True\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("for i in range(3):\n\tprint(i)", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"0\n1\n2\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("print(unknown)", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("name 'unknown' is not defined"));
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("1/0", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("ZeroDivisionError"));
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("def greet(name):\n    print('Hello', name)\ngreet('Jack')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"Hello Jack\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("print('there is no Error: ok')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)1L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)"there is no Error: ok\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        List completions = interpreter.completion("ab", 2, context);
        Assert.assertEquals((long)2L, (long)completions.size());
        Assert.assertEquals((Object)"abc", (Object)((InterpreterCompletion)completions.get(0)).getValue());
        Assert.assertEquals((Object)"abs", (Object)((InterpreterCompletion)completions.get(1)).getValue());
        context = IPythonInterpreterTest.getInterpreterContext();
        interpreter.interpret("import sys", context);
        completions = interpreter.completion("sys.", 4, context);
        Assert.assertFalse((boolean)completions.isEmpty());
        context = IPythonInterpreterTest.getInterpreterContext();
        completions = interpreter.completion("sys.std", 7, context);
        for (InterpreterCompletion completion : completions) {
            System.out.println(completion.getValue());
        }
        Assert.assertEquals((long)3L, (long)completions.size());
        Assert.assertEquals((Object)"stderr", (Object)((InterpreterCompletion)completions.get(0)).getValue());
        Assert.assertEquals((Object)"stdin", (Object)((InterpreterCompletion)completions.get(1)).getValue());
        Assert.assertEquals((Object)"stdout", (Object)((InterpreterCompletion)completions.get(2)).getValue());
        context = IPythonInterpreterTest.getInterpreterContext();
        String st = "a='hello'\na.";
        completions = interpreter.completion(st, st.length(), context);
        Assert.assertEquals((long)0L, (long)completions.size());
        context = IPythonInterpreterTest.getInterpreterContext();
        st = "a='hello'";
        result = interpreter.interpret(st, context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)0L, (long)interpreterResultMessages.size());
        context = IPythonInterpreterTest.getInterpreterContext();
        st = "a.";
        completions = interpreter.completion(st, st.length(), context);
        TestCase.assertTrue((completions.size() > 20 ? 1 : 0) != 0);
        context = IPythonInterpreterTest.getInterpreterContext();
        st = "a.co";
        completions = interpreter.completion(st, st.length(), context);
        Assert.assertEquals((long)1L, (long)completions.size());
        Assert.assertEquals((Object)"count", (Object)((InterpreterCompletion)completions.get(0)).getValue());
        context = IPythonInterpreterTest.getInterpreterContext();
        st = "a.co\b='hello";
        completions = interpreter.completion(st, 4, context);
        Assert.assertEquals((long)1L, (long)completions.size());
        Assert.assertEquals((Object)"count", (Object)((InterpreterCompletion)completions.get(0)).getValue());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("range?", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("range(stop)"));
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("%timeit range(100)", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("loops"));
        final InterpreterContext context2 = IPythonInterpreterTest.getInterpreterContext();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    interpreter.cancel(context2);
                }
                catch (InterpreterException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        result = interpreter.interpret("import time\ntime.sleep(10)", context2);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)result.code());
        interpreterResultMessages = context2.out.toInterpreterResultMessage();
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("KeyboardInterrupt"));
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("%matplotlib inline\nimport matplotlib.pyplot as plt\ndata=[1,1,2,3,4]\nplt.figure()\nplt.plot(data)", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        boolean hasImageOutput = false;
        boolean hasLineText = false;
        boolean hasFigureText = false;
        for (InterpreterResultMessage msg : interpreterResultMessages) {
            if (msg.getType() == InterpreterResult.Type.IMG) {
                hasImageOutput = true;
            }
            if (msg.getType() == InterpreterResult.Type.TEXT && msg.getData().contains("matplotlib.lines.Line2D")) {
                hasLineText = true;
            }
            if (msg.getType() != InterpreterResult.Type.TEXT || !msg.getData().contains("matplotlib.figure.Figure")) continue;
            hasFigureText = true;
        }
        TestCase.assertTrue((String)"No Image Output", (boolean)hasImageOutput);
        TestCase.assertTrue((String)"No Line Text", (boolean)hasLineText);
        TestCase.assertTrue((String)"No Figure Text", (boolean)hasFigureText);
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("from bokeh.io import output_notebook, show\nfrom bokeh.plotting import figure\nimport bkzep\noutput_notebook(notebook_type='zeppelin')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)2L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("Loading BokehJS"));
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(1)).getData().contains("BokehJS is being loaded"));
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("from bokeh.plotting import figure, output_file, show\nx = [1, 2, 3, 4, 5]\ny = [6, 7, 2, 4, 5]\np = figure(title=\"simple line example\", x_axis_label='x', y_axis_label='y')\np.line(x, y, legend=\"Temp.\", line_width=2)\nshow(p)", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((long)2L, (long)interpreterResultMessages.size());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
        Assert.assertEquals((Object)InterpreterResult.Type.HTML, (Object)((InterpreterResultMessage)interpreterResultMessages.get(1)).getType());
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(1)).getData().contains("docs_json"));
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("from ggplot import *\nggplot(diamonds, aes(x='price', fill='cut')) +\\\n    geom_density(alpha=0.25) +\\\n    facet_wrap(\"clarity\")", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        hasImageOutput = false;
        for (InterpreterResultMessage msg : interpreterResultMessages) {
            if (msg.getType() != InterpreterResult.Type.IMG) continue;
            hasImageOutput = true;
        }
        TestCase.assertTrue((String)"No Image Output", (boolean)hasImageOutput);
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("z.input(name='text_1', defaultValue='value_1')", context);
        Thread.sleep(100L);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        TestCase.assertTrue((boolean)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData().contains("'value_1'"));
        Assert.assertEquals((long)1L, (long)context.getGui().getForms().size());
        TestCase.assertTrue((boolean)(context.getGui().getForms().get("text_1") instanceof TextBox));
        TextBox textbox = (TextBox)context.getGui().getForms().get("text_1");
        Assert.assertEquals((Object)"text_1", (Object)textbox.getName());
        Assert.assertEquals((Object)"value_1", (Object)textbox.getDefaultValue());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("z.select(name='select_1', options=[('value_1', 'name_1'), ('value_2', 'name_2')])", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assert.assertEquals((long)1L, (long)context.getGui().getForms().size());
        TestCase.assertTrue((boolean)(context.getGui().getForms().get("select_1") instanceof Select));
        Select select = (Select)context.getGui().getForms().get("select_1");
        Assert.assertEquals((Object)"select_1", (Object)select.getName());
        Assert.assertEquals((long)2L, (long)select.getOptions().length);
        Assert.assertEquals((Object)"name_1", (Object)select.getOptions()[0].getDisplayName());
        Assert.assertEquals((Object)"value_1", (Object)select.getOptions()[0].getValue());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("z.checkbox(name='checkbox_1', options=[('value_1', 'name_1'), ('value_2', 'name_2')])", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assert.assertEquals((long)1L, (long)context.getGui().getForms().size());
        TestCase.assertTrue((boolean)(context.getGui().getForms().get("checkbox_1") instanceof CheckBox));
        CheckBox checkbox = (CheckBox)context.getGui().getForms().get("checkbox_1");
        Assert.assertEquals((Object)"checkbox_1", (Object)checkbox.getName());
        Assert.assertEquals((long)2L, (long)checkbox.getOptions().length);
        Assert.assertEquals((Object)"name_1", (Object)checkbox.getOptions()[0].getDisplayName());
        Assert.assertEquals((Object)"value_1", (Object)checkbox.getOptions()[0].getValue());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("import pandas as pd\ndf = pd.DataFrame({'id':[1,2,3], 'name':['a','b','c']})\nz.show(df)", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        interpreterResultMessages = context.out.toInterpreterResultMessage();
        Assert.assertEquals((Object)InterpreterResult.Type.TABLE, (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getType());
        Assert.assertEquals((Object)"id\tname\n1\ta\n2\tb\n3\tc\n", (Object)((InterpreterResultMessage)interpreterResultMessages.get(0)).getData());
        context = IPythonInterpreterTest.getInterpreterContext();
        result = interpreter.interpret("import time\nprint(\"Hello\")\ntime.sleep(0.5)\nz.getInterpreterContext().out().clear()\nprint(\"world\")\n", context);
        Assert.assertEquals((Object)"%text world\n", (Object)context.out.getCurrentOutput().toString());
    }

    private static InterpreterContext getInterpreterContext() {
        return new InterpreterContext("noteId", "paragraphId", "replName", "paragraphTitle", "paragraphText", new AuthenticationInfo(), new HashMap(), new GUI(), new GUI(), null, null, null, new InterpreterOutput(null));
    }
}

