/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.python.PythonInterpreter;
import org.apache.zeppelin.resource.LocalResourcePool;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PythonInterpreterTest
implements InterpreterOutputListener {
    PythonInterpreter pythonInterpreter = null;
    String cmdHistory;
    private InterpreterContext context;
    InterpreterOutput out;

    public static Properties getPythonTestProperties() {
        Properties p = new Properties();
        p.setProperty("python/zeppelin_python.py", "python");
        p.setProperty("zeppelin.python.maxResult", "1000");
        p.setProperty("zeppelin.python.useIPython", "false");
        return p;
    }

    @Before
    public void beforeTest() throws IOException, InterpreterException {
        this.cmdHistory = "";
        this.pythonInterpreter = new PythonInterpreter(PythonInterpreterTest.getPythonTestProperties());
        InterpreterGroup group = new InterpreterGroup();
        group.put("note", new LinkedList());
        group.get("note").add(this.pythonInterpreter);
        this.pythonInterpreter.setInterpreterGroup(group);
        this.out = new InterpreterOutput((InterpreterOutputListener)this);
        this.context = new InterpreterContext("note", "id", null, "title", "text", new AuthenticationInfo(), new HashMap(), new GUI(), new GUI(), new AngularObjectRegistry(group.getId(), null), (ResourcePool)new LocalResourcePool("id"), new LinkedList(), this.out);
        InterpreterContext.set((InterpreterContext)this.context);
        this.pythonInterpreter.open();
    }

    @After
    public void afterTest() throws IOException, InterpreterException {
        this.pythonInterpreter.close();
    }

    @Test
    public void testInterpret() throws InterruptedException, IOException, InterpreterException {
        InterpreterResult result = this.pythonInterpreter.interpret("print (\"hi\")", this.context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
    }

    @Test
    public void testInterpretInvalidSyntax() throws IOException, InterpreterException {
        InterpreterResult result = this.pythonInterpreter.interpret("for x in range(0,3):  print (\"hi\")\n", this.context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assert.assertTrue((boolean)new String(this.out.getOutputAt(0).toByteArray()).contains("hi\nhi\nhi"));
    }

    @Test
    public void testRedefinitionZeppelinContext() throws InterpreterException {
        String pyRedefinitionCode = "z = 1\n";
        String pyRestoreCode = "z = __zeppelin__\n";
        String pyValidCode = "z.input(\"test\")\n";
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.pythonInterpreter.interpret(pyValidCode, this.context).code());
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.pythonInterpreter.interpret(pyRedefinitionCode, this.context).code());
        Assert.assertEquals((Object)InterpreterResult.Code.ERROR, (Object)this.pythonInterpreter.interpret(pyValidCode, this.context).code());
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.pythonInterpreter.interpret(pyRestoreCode, this.context).code());
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.pythonInterpreter.interpret(pyValidCode, this.context).code());
    }

    @Test
    public void testOutputClear() throws InterpreterException {
        InterpreterResult result = this.pythonInterpreter.interpret("print(\"Hello\")\nz.getInterpreterContext().out().clear()\nprint(\"world\")\n", this.context);
        Assert.assertEquals((Object)"%text world\n", (Object)this.out.getCurrentOutput().toString());
    }

    public void onUpdateAll(InterpreterOutput out) {
    }

    public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
    }

    public void onUpdate(int index, InterpreterResultMessageOutput out) {
    }
}

