/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InvalidHookException;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.util.InterpreterOutputStream;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.python.PythonZeppelinContext;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class PythonInterpreter
extends Interpreter
implements ExecuteResultHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PythonInterpreter.class);
    public static final String ZEPPELIN_PYTHON = "python/zeppelin_python.py";
    public static final String ZEPPELIN_PY4JPATH = "interpreter/python/py4j-0.9.2/src";
    public static final String ZEPPELIN_PYTHON_LIBS = "interpreter/lib/python";
    public static final String DEFAULT_ZEPPELIN_PYTHON = "python";
    public static final String MAX_RESULT = "zeppelin.python.maxResult";
    private PythonZeppelinContext zeppelinContext;
    private InterpreterContext context;
    private Pattern errorInLastLine = Pattern.compile(".*(Error|Exception): .*$");
    private String pythonPath;
    private int maxResult;
    private String py4jLibPath;
    private String pythonLibPath;
    private String pythonCommand;
    private GatewayServer gatewayServer;
    private DefaultExecutor executor;
    private int port;
    private InterpreterOutputStream outputStream;
    private BufferedWriter ins;
    private PipedInputStream in;
    private ByteArrayOutputStream input;
    private String scriptPath;
    boolean pythonscriptRunning = false;
    private static final int MAX_TIMEOUT_SEC = 10;
    private long pythonPid = 0L;
    private IPythonInterpreter iPythonInterpreter;
    Integer statementSetNotifier = new Integer(0);
    PythonInterpretRequest pythonInterpretRequest = null;
    String statementOutput = null;
    boolean statementError = false;
    Integer statementFinishedNotifier = new Integer(0);
    boolean pythonScriptInitialized = false;
    Integer pythonScriptInitializeNotifier = new Integer(0);

    public PythonInterpreter(Properties property) {
        super(property);
        try {
            File scriptFile = File.createTempFile("zeppelin_python-", ".py", new File("/tmp"));
            this.scriptPath = scriptFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String workingDir() {
        URL myURL = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
        URI myURI = null;
        try {
            myURI = myURL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String path = Paths.get(myURI).toFile().toString();
        return path;
    }

    private void createPythonScript() throws InterpreterException {
        File out = new File(this.scriptPath);
        if (out.exists() && out.isDirectory()) {
            throw new InterpreterException("Can't create python script " + out.getAbsolutePath());
        }
        this.copyFile(out, ZEPPELIN_PYTHON);
        logger.info("File {} created", (Object)this.scriptPath);
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    private void copyFile(File out, String sourceFile) throws InterpreterException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            FileOutputStream outStream = new FileOutputStream(out);
            IOUtils.copy((InputStream)classLoader.getResourceAsStream(sourceFile), (OutputStream)outStream);
            outStream.close();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
    }

    private void createGatewayServerAndStartScript() throws UnknownHostException, InterpreterException {
        this.createPythonScript();
        if (System.getenv("ZEPPELIN_HOME") != null) {
            this.py4jLibPath = System.getenv("ZEPPELIN_HOME") + File.separator + ZEPPELIN_PY4JPATH;
            this.pythonLibPath = System.getenv("ZEPPELIN_HOME") + File.separator + ZEPPELIN_PYTHON_LIBS;
        } else {
            Path workingPath = Paths.get("..", new String[0]).toAbsolutePath();
            this.py4jLibPath = workingPath + File.separator + ZEPPELIN_PY4JPATH;
            this.pythonLibPath = workingPath + File.separator + ZEPPELIN_PYTHON_LIBS;
        }
        this.port = this.findRandomOpenPortOnAllLocalInterfaces();
        this.gatewayServer = new GatewayServer((Object)this, this.port, 25334, InetAddress.getByName("0.0.0.0"), InetAddress.getByName("0.0.0.0"), 0, 0, (List)null);
        this.gatewayServer.start();
        String pythonCmd = this.getPythonCommand();
        CommandLine cmd = CommandLine.parse((String)pythonCmd);
        if (!pythonCmd.endsWith(".py")) {
            cmd.addArgument(this.getScriptPath(), false);
        }
        cmd.addArgument(Integer.toString(this.port), false);
        cmd.addArgument(this.getLocalIp(), false);
        this.executor = new DefaultExecutor();
        this.outputStream = new InterpreterOutputStream(logger);
        PipedOutputStream ps = new PipedOutputStream();
        this.in = null;
        try {
            this.in = new PipedInputStream(ps);
        }
        catch (IOException e1) {
            throw new InterpreterException((Throwable)e1);
        }
        this.ins = new BufferedWriter(new OutputStreamWriter(ps));
        this.input = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)this.outputStream, (OutputStream)this.outputStream, (InputStream)this.in);
        this.executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        this.executor.setWatchdog(new ExecuteWatchdog(-1L));
        try {
            Map env = EnvironmentUtils.getProcEnvironment();
            if (!env.containsKey("PYTHONPATH")) {
                env.put("PYTHONPATH", this.py4jLibPath + File.pathSeparator + this.pythonLibPath);
            } else {
                env.put("PYTHONPATH", env.get("PYTHONPATH") + File.pathSeparator + this.py4jLibPath + File.pathSeparator + this.pythonLibPath);
            }
            logger.info("cmd = {}", (Object)cmd.toString());
            this.executor.execute(cmd, env, (ExecuteResultHandler)this);
            this.pythonscriptRunning = true;
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
        try {
            this.input.write("import sys, getopt\n".getBytes());
            this.ins.flush();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
    }

    public void open() throws InterpreterException {
        this.iPythonInterpreter = this.getIPythonInterpreter();
        this.zeppelinContext = new PythonZeppelinContext(this.getInterpreterGroup().getInterpreterHookRegistry(), Integer.parseInt(this.getProperty(MAX_RESULT, "1000")));
        if (this.getProperty("zeppelin.python.useIPython", "true").equals("true") && StringUtils.isEmpty((String)this.iPythonInterpreter.checkIPythonPrerequisite(this.getPythonBindPath()))) {
            try {
                this.iPythonInterpreter.open();
                LOG.info("IPython is available, Use IPythonInterpreter to replace PythonInterpreter");
                return;
            }
            catch (Exception e) {
                this.iPythonInterpreter = null;
                LOG.warn("Fail to open IPythonInterpreter", (Throwable)e);
            }
        }
        this.iPythonInterpreter = null;
        LOG.info("IPython is not available, use the native PythonInterpreter");
        InterpreterGroup intpGroup = this.getInterpreterGroup();
        if (intpGroup != null && intpGroup.getInterpreterHookRegistry() != null) {
            try {
                this.registerHook(InterpreterHookRegistry.HookType.POST_EXEC_DEV.getName(), "__zeppelin__._displayhook()");
            }
            catch (InvalidHookException e) {
                throw new InterpreterException((Throwable)e);
            }
        }
        try {
            this.createGatewayServerAndStartScript();
        }
        catch (UnknownHostException e) {
            throw new InterpreterException((Throwable)e);
        }
    }

    private IPythonInterpreter getIPythonInterpreter() {
        LazyOpenInterpreter lazy = null;
        IPythonInterpreter ipython = null;
        Interpreter p = this.getInterpreterInTheSameSessionByClassName(IPythonInterpreter.class.getName());
        while (p instanceof WrappedInterpreter) {
            if (p instanceof LazyOpenInterpreter) {
                lazy = (LazyOpenInterpreter)p;
            }
            p = ((WrappedInterpreter)p).getInnerInterpreter();
        }
        ipython = (IPythonInterpreter)p;
        return ipython;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterpreterException {
        if (this.iPythonInterpreter != null) {
            this.iPythonInterpreter.close();
            return;
        }
        this.pythonscriptRunning = false;
        this.pythonScriptInitialized = false;
        try {
            this.ins.flush();
            this.ins.close();
            this.input.flush();
            this.input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.executor.getWatchdog().destroyProcess();
        new File(this.scriptPath).delete();
        this.gatewayServer.shutdown();
        Integer n = this.statementSetNotifier;
        synchronized (n) {
            try {
                this.statementSetNotifier.wait(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.statementSetNotifier.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PythonInterpretRequest getStatements() {
        Integer n = this.statementSetNotifier;
        synchronized (n) {
            while (this.pythonInterpretRequest == null && this.pythonscriptRunning && this.pythonScriptInitialized) {
                try {
                    this.statementSetNotifier.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            PythonInterpretRequest req = this.pythonInterpretRequest;
            this.pythonInterpretRequest = null;
            return req;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatementsFinished(String out, boolean error) {
        Integer n = this.statementFinishedNotifier;
        synchronized (n) {
            this.statementOutput = out;
            this.statementError = error;
            this.statementFinishedNotifier.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPythonScriptInitialized(long pid) {
        this.pythonPid = pid;
        Integer n = this.pythonScriptInitializeNotifier;
        synchronized (n) {
            this.pythonScriptInitialized = true;
            this.pythonScriptInitializeNotifier.notifyAll();
        }
    }

    public void appendOutput(String message) throws IOException {
        this.outputStream.getInterpreterOutput().write(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) throws InterpreterException {
        List errorMessage;
        if (this.iPythonInterpreter != null) {
            return this.iPythonInterpreter.interpret(cmd, contextInterpreter);
        }
        if (cmd == null || cmd.isEmpty()) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, "");
        }
        this.context = contextInterpreter;
        this.zeppelinContext.setGui(this.context.getGui());
        this.zeppelinContext.setNoteGui(this.context.getNoteGui());
        this.zeppelinContext.setInterpreterContext(this.context);
        if (!this.pythonscriptRunning) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "python process not running" + this.outputStream.toString());
        }
        this.outputStream.setInterpreterOutput(this.context.out);
        Integer n = this.pythonScriptInitializeNotifier;
        synchronized (n) {
            long startTime = System.currentTimeMillis();
            while (!this.pythonScriptInitialized && this.pythonscriptRunning && System.currentTimeMillis() - startTime < 10000L) {
                try {
                    this.pythonScriptInitializeNotifier.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            this.context.out.flush();
            errorMessage = this.context.out.toInterpreterResultMessage();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
        if (!this.pythonscriptRunning) {
            errorMessage.add(new InterpreterResultMessage(InterpreterResult.Type.TEXT, "failed to start python"));
            return new InterpreterResult(InterpreterResult.Code.ERROR, errorMessage);
        }
        if (!this.pythonScriptInitialized) {
            errorMessage.add(new InterpreterResultMessage(InterpreterResult.Type.TEXT, "python is not responding"));
            return new InterpreterResult(InterpreterResult.Code.ERROR, errorMessage);
        }
        this.pythonInterpretRequest = new PythonInterpretRequest(cmd);
        this.statementOutput = null;
        Integer e = this.statementSetNotifier;
        synchronized (e) {
            this.statementSetNotifier.notify();
        }
        e = this.statementFinishedNotifier;
        synchronized (e) {
            while (this.statementOutput == null) {
                try {
                    this.statementFinishedNotifier.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.statementError) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, this.statementOutput);
        }
        try {
            this.context.out.flush();
        }
        catch (IOException e2) {
            throw new InterpreterException((Throwable)e2);
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS);
    }

    public InterpreterContext getCurrentInterpreterContext() {
        return this.context;
    }

    public void interrupt() throws IOException, InterpreterException {
        if (this.pythonPid > -1L) {
            logger.info("Sending SIGINT signal to PID : " + this.pythonPid);
            Runtime.getRuntime().exec("kill -SIGINT " + this.pythonPid);
        } else {
            logger.warn("Non UNIX/Linux system, close the interpreter");
            this.close();
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        if (this.iPythonInterpreter != null) {
            this.iPythonInterpreter.cancel(context);
        }
        try {
            this.interrupt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        if (this.iPythonInterpreter != null) {
            return this.iPythonInterpreter.getProgress(context);
        }
        return 0;
    }

    public Scheduler getScheduler() {
        if (this.iPythonInterpreter != null) {
            return this.iPythonInterpreter.getScheduler();
        }
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(PythonInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        if (this.iPythonInterpreter != null) {
            return this.iPythonInterpreter.completion(buf, cursor, interpreterContext);
        }
        return null;
    }

    public void setPythonCommand(String cmd) {
        logger.info("Set Python Command : {}", (Object)cmd);
        this.pythonCommand = cmd;
    }

    private String getPythonCommand() {
        if (this.pythonCommand == null) {
            return this.getPythonBindPath();
        }
        return this.pythonCommand;
    }

    public String getPythonBindPath() {
        String path = this.getProperty("zeppelin.python");
        if (path == null) {
            return DEFAULT_ZEPPELIN_PYTHON;
        }
        return path;
    }

    private Job getRunningJob(String paragraphId) {
        Job foundJob = null;
        Collection jobsRunning = this.getScheduler().getJobsRunning();
        for (Job job : jobsRunning) {
            if (!job.getId().equals(paragraphId)) continue;
            foundJob = job;
            break;
        }
        return foundJob;
    }

    void bootStrapInterpreter(String file) throws IOException {
        BufferedReader bootstrapReader = new BufferedReader(new InputStreamReader(PythonInterpreter.class.getResourceAsStream(file)));
        String line = null;
        String bootstrapCode = "";
        while ((line = bootstrapReader.readLine()) != null) {
            bootstrapCode = bootstrapCode + line + "\n";
        }
        try {
            this.interpret(bootstrapCode, InterpreterContext.get());
        }
        catch (InterpreterException e) {
            throw new IOException(e);
        }
    }

    public PythonZeppelinContext getZeppelinContext() {
        return this.zeppelinContext;
    }

    String getLocalIp() {
        try {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error("can't get local IP", (Throwable)e);
            return "127.0.0.1";
        }
    }

    private int findRandomOpenPortOnAllLocalInterfaces() {
        Integer port = -1;
        try (ServerSocket socket = new ServerSocket(0);){
            port = socket.getLocalPort();
            socket.close();
        }
        catch (IOException e) {
            LOG.error("Can't find an open port", (Throwable)e);
        }
        return port;
    }

    public int getMaxResult() {
        return this.maxResult;
    }

    public void onProcessComplete(int exitValue) {
        this.pythonscriptRunning = false;
        logger.info("python process terminated. exit code " + exitValue);
    }

    public void onProcessFailed(ExecuteException e) {
        this.pythonscriptRunning = false;
        logger.error("python process failed", (Throwable)e);
    }

    public class PythonInterpretRequest {
        public String statements;

        public PythonInterpretRequest(String statements) {
            this.statements = statements;
        }

        public String statements() {
            return this.statements;
        }
    }
}

