/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.python.PythonDockerInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PythonDockerInterpreterTest {
    private PythonDockerInterpreter docker;
    private PythonInterpreter python;

    @Before
    public void setUp() throws InterpreterException {
        this.docker = (PythonDockerInterpreter)Mockito.spy((Object)new PythonDockerInterpreter(new Properties()));
        this.python = (PythonInterpreter)Mockito.mock(PythonInterpreter.class);
        InterpreterGroup group = new InterpreterGroup();
        group.put("note", Arrays.asList(this.python, this.docker));
        this.python.setInterpreterGroup(group);
        this.docker.setInterpreterGroup(group);
        ((PythonDockerInterpreter)Mockito.doReturn((Object)true).when((Object)this.docker)).pull((InterpreterOutput)Matchers.any(InterpreterOutput.class), Matchers.anyString());
        ((PythonDockerInterpreter)Mockito.doReturn((Object)this.python).when((Object)this.docker)).getPythonInterpreter();
        ((PythonInterpreter)Mockito.doReturn((Object)"/scriptpath/zeppelin_python.py").when((Object)this.python)).getScriptPath();
        this.docker.open();
    }

    @Test
    public void testActivateEnv() throws InterpreterException {
        InterpreterContext context = this.getInterpreterContext();
        this.docker.interpret("activate env", context);
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).open();
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).close();
        ((PythonDockerInterpreter)Mockito.verify((Object)this.docker, (VerificationMode)Mockito.times((int)1))).pull((InterpreterOutput)Matchers.any(InterpreterOutput.class), Matchers.anyString());
        ((PythonInterpreter)Mockito.verify((Object)this.python)).setPythonCommand(Mockito.matches((String)"docker run -i --rm -v.*"));
    }

    @Test
    public void testDeactivate() throws InterpreterException {
        InterpreterContext context = this.getInterpreterContext();
        this.docker.interpret("deactivate", context);
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).open();
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).close();
        ((PythonInterpreter)Mockito.verify((Object)this.python)).setPythonCommand(null);
    }

    private InterpreterContext getInterpreterContext() {
        return new InterpreterContext("noteId", "paragraphId", "replName", "paragraphTitle", "paragraphText", new AuthenticationInfo(), new HashMap(), new GUI(), new GUI(), null, null, null, new InterpreterOutput(null));
    }
}

