/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.python.PythonCondaInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PythonCondaInterpreterTest {
    private PythonCondaInterpreter conda;
    private PythonInterpreter python;

    @Before
    public void setUp() throws InterpreterException {
        this.conda = (PythonCondaInterpreter)Mockito.spy((Object)new PythonCondaInterpreter(new Properties()));
        Mockito.when((Object)this.conda.getClassName()).thenReturn((Object)PythonCondaInterpreter.class.getName());
        this.python = (PythonInterpreter)Mockito.mock(PythonInterpreter.class);
        Mockito.when((Object)this.python.getClassName()).thenReturn((Object)PythonInterpreter.class.getName());
        InterpreterGroup group = new InterpreterGroup();
        group.put("note", Arrays.asList(this.python, this.conda));
        this.python.setInterpreterGroup(group);
        this.conda.setInterpreterGroup(group);
    }

    private void setMockCondaEnvList() throws IOException, InterruptedException {
        LinkedHashMap<String, String> envList = new LinkedHashMap<String, String>();
        envList.put("env1", "/path1");
        envList.put("env2", "/path2");
        ((PythonCondaInterpreter)Mockito.doReturn(envList).when((Object)this.conda)).getCondaEnvs();
    }

    @Test
    public void testListEnv() throws IOException, InterruptedException, InterpreterException {
        this.setMockCondaEnvList();
        InterpreterContext context = this.getInterpreterContext();
        InterpreterResult result = this.conda.interpret("env list", context);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)result.code());
        Assert.assertTrue((boolean)result.toString().contains(">env1<"));
        Assert.assertTrue((boolean)result.toString().contains("/path1<"));
        Assert.assertTrue((boolean)result.toString().contains(">env2<"));
        Assert.assertTrue((boolean)result.toString().contains("/path2<"));
    }

    @Test
    public void testActivateEnv() throws IOException, InterruptedException, InterpreterException {
        this.setMockCondaEnvList();
        String envname = "env1";
        InterpreterContext context = this.getInterpreterContext();
        this.conda.interpret("activate " + envname, context);
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).open();
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).close();
        ((PythonInterpreter)Mockito.verify((Object)this.python)).setPythonExec("/path1/bin/python");
        Assert.assertTrue((boolean)envname.equals(this.conda.getCurrentCondaEnvName()));
    }

    @Test
    public void testDeactivate() throws InterpreterException {
        InterpreterContext context = this.getInterpreterContext();
        this.conda.interpret("deactivate", context);
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).open();
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).close();
        ((PythonInterpreter)Mockito.verify((Object)this.python)).setPythonExec("python");
        Assert.assertTrue((boolean)this.conda.getCurrentCondaEnvName().isEmpty());
    }

    @Test
    public void testParseCondaCommonStdout() throws IOException, InterruptedException {
        StringBuilder sb = new StringBuilder().append("# comment1\n").append("# comment2\n").append("env1     /location1\n").append("env2     /location2\n");
        Map locationPerEnv = PythonCondaInterpreter.parseCondaCommonStdout((String)sb.toString());
        Assert.assertEquals((Object)"/location1", locationPerEnv.get("env1"));
        Assert.assertEquals((Object)"/location2", locationPerEnv.get("env2"));
    }

    @Test
    public void testGetRestArgsFromMatcher() {
        Matcher m = PythonCondaInterpreter.PATTERN_COMMAND_ENV.matcher("env remove --name test --yes");
        m.matches();
        List restArgs = PythonCondaInterpreter.getRestArgsFromMatcher((Matcher)m);
        List<String> expected = Arrays.asList("remove", "--name", "test", "--yes");
        Assert.assertEquals(expected, (Object)restArgs);
    }

    private InterpreterContext getInterpreterContext() {
        return InterpreterContext.builder().setInterpreterOut(new InterpreterOutput(null)).build();
    }
}

