/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.python.PythonInterpreter;
import org.apache.zeppelin.python.PythonInterpreterPandasSql;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PythonInterpreterPandasSqlTest
implements InterpreterOutputListener {
    private InterpreterGroup intpGroup;
    private PythonInterpreterPandasSql sql;
    private PythonInterpreter python;
    private InterpreterContext context;
    InterpreterOutput out;

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("zeppelin.python", "python");
        p.setProperty("zeppelin.python.maxResult", "100");
        p.setProperty("zeppelin.python.useIPython", "false");
        this.intpGroup = new InterpreterGroup();
        this.out = new InterpreterOutput((InterpreterOutputListener)this);
        this.context = InterpreterContext.builder().setInterpreterOut(this.out).build();
        InterpreterContext.set((InterpreterContext)this.context);
        this.python = new PythonInterpreter(p);
        this.python.setInterpreterGroup(this.intpGroup);
        this.python.open();
        this.sql = new PythonInterpreterPandasSql(p);
        this.sql.setInterpreterGroup(this.intpGroup);
        this.intpGroup.put("note", Arrays.asList(this.python, this.sql));
        InterpreterResult ret = this.python.interpret("print(\"python initialized\")\n", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        this.sql.open();
    }

    @After
    public void afterTest() throws IOException, InterpreterException {
        this.sql.close();
    }

    @Test
    public void dependenciesAreInstalled() throws InterpreterException {
        InterpreterResult ret = this.python.interpret("import pandas\nimport pandasql\nimport numpy\n", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
    }

    @Test
    public void errorMessageIfDependenciesNotInstalled() throws InterpreterException {
        InterpreterResult ret = this.sql.interpret("SELECT * from something", this.context);
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((String)((InterpreterResultMessage)ret.message().get(0)).getData(), (Object)InterpreterResult.Code.ERROR, (Object)ret.code());
        Assert.assertTrue((boolean)((InterpreterResultMessage)ret.message().get(0)).getData().contains("no such table: something"));
    }

    @Test
    public void sqlOverTestDataPrintsTable() throws IOException, InterpreterException {
        InterpreterResult ret = this.python.interpret("import pandas as pd", this.context);
        ret = this.python.interpret("import numpy as np", this.context);
        ret = this.python.interpret("df2 = pd.DataFrame({ 'age'  : np.array([33, 51, 51, 34]), 'name' : pd.Categorical(['moon','jobs','gates','park'])})", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        ret = this.sql.interpret("select name, age from df2 where age < 40", this.context);
        Assert.assertEquals((String)new String(this.out.getOutputAt(1).toByteArray()), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        Assert.assertEquals((String)new String(this.out.getOutputAt(1).toByteArray()), (Object)InterpreterResult.Type.TABLE, (Object)this.out.getOutputAt(1).getType());
        Assert.assertTrue((new String(this.out.getOutputAt(1).toByteArray()).indexOf("moon\t33") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((new String(this.out.getOutputAt(1).toByteArray()).indexOf("park\t34") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)InterpreterResult.Code.SUCCESS, (Object)this.sql.interpret("select case when name==\"aa\" then name else name end from df2", this.context).code());
    }

    @Test
    public void badSqlSyntaxFails() throws IOException, InterpreterException {
        InterpreterResult ret = this.sql.interpret("select wrong syntax", this.context);
        Assert.assertNotNull((String)"Interpreter returned 'null'", (Object)ret);
        Assert.assertEquals((String)ret.toString(), (Object)InterpreterResult.Code.ERROR, (Object)ret.code());
    }

    @Test
    public void showDataFrame() throws IOException, InterpreterException {
        InterpreterResult ret = this.python.interpret("import pandas as pd", this.context);
        ret = this.python.interpret("import numpy as np", this.context);
        ret = this.python.interpret("index = pd.Index([10, 11, 12, 13], name='index_name')", this.context);
        ret = this.python.interpret("d1 = {1 : [np.nan, 1, 2, 3], 'two' : [3., 4., 5., 6.7]}", this.context);
        ret = this.python.interpret("df1 = pd.DataFrame(d1, index=index)", this.context);
        Assert.assertEquals((String)ret.message().toString(), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        ret = this.python.interpret("z.show(df1, show_index=True)", this.context);
        Assert.assertEquals((String)new String(this.out.getOutputAt(0).toByteArray()), (Object)InterpreterResult.Code.SUCCESS, (Object)ret.code());
        Assert.assertEquals((String)new String(this.out.getOutputAt(1).toByteArray()), (Object)InterpreterResult.Type.TABLE, (Object)this.out.getOutputAt(1).getType());
        Assert.assertTrue((boolean)new String(this.out.getOutputAt(1).toByteArray()).contains("index_name"));
        Assert.assertTrue((boolean)new String(this.out.getOutputAt(1).toByteArray()).contains("nan"));
        Assert.assertTrue((boolean)new String(this.out.getOutputAt(1).toByteArray()).contains("6.7"));
    }

    public void onUpdateAll(InterpreterOutput out) {
    }

    public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
    }

    public void onUpdate(int index, InterpreterResultMessageOutput out) {
    }
}

