/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apithefire.sql.h2;

import org.apithefire.util.lang.Objects;

/**
 * A custom file access mode.
 * 
 * @see <a
 *      href="http://www.h2database.com/html/features.html#custom_access_mode">Custome
 *      File Access Mode</a>
 * @author <a href="mailto:bachew@gmail.com">Chew Boon Aik</a>
 */
public enum AccessMode {
	
	/** Read only. */
	READ("r"),
	
	/** Read/write. */
	READ_WRITE("rw"),
	
	/**
	 * Read/write and for every update to the file's content is written
	 * synchronously to the underlying storage device.
	 */
	READ_WRITE_D("rwd"),
	
	/**
	 * Read/write, in addition to {@link #READ_WRITE_D}, every update to the
	 * metadata is written synchronously.
	 */
	READ_WRITE_S("rws");
	
	private String parameterValue;
	
	private AccessMode(String parameterValue) {
		this.parameterValue = Objects.nonNull(parameterValue);
	}
	
	protected String getParameterValue() {
		return parameterValue;
	}
	
}
