/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apithefire.sql.h2;

import org.apithefire.util.lang.Objects;

/**
 * A database file locking.
 * 
 * @see <a
 *      href="http://www.h2database.com/html/features.html#database_file_locking">
 *      Database File Locking</a>
 * @author <a href="mailto:bachew@gmail.com">Chew Boon Aik</a>
 */
public enum FileLock {
	
	/**
	 * No locking.
	 */
	NO("NO"),
	
	/**
	 * A watchdog thread to protect the database file. The watchdog reads the
	 * lock file each second.
	 */
	FILE("FILE"),
	
	/**
	 * Opens a server socket. The socket method does not require reading the
	 * lock file every second. The socket method should only be used if the
	 * database files are only accessed by the one (and always the same)
	 * computer.
	 */
	SOCKET("SOCKET");

	private String parameterValue;
	
	private FileLock(String parameterValue) {
		this.parameterValue = Objects.nonNull(parameterValue);
	}
	
	protected String getParameterValue() {
		return parameterValue;
	}
	
}
