/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apithefire.sql.h2;

/**
 * A trace level.
 * 
 * @see <a href="http://www.h2database.com/html/features.html#trace_options">
 *      Using the Trace Options</a>
 * @author <a href="mailto:bachew@gmail.com">Chew Boon Aik</a>
 */
public enum TraceLevel {
	
	/**
	 * No tracing.
	 */
	OFF(0),
	
	/**
	 * Error trace level.
	 */
	ERROR(1),
	
	/**
	 * Info trace level.
	 */
	INFO(2),
	
	/**
	 * Debug trace level.
	 */
	DEBUG(3),
	
	/**
	 * Use <a href="http://www.slf4j.org/">SLF4J</a> logging.
	 */
	SLF4J(4);

	private int parameterValue;
	
	private TraceLevel(int parameterValue) {
		this.parameterValue = parameterValue;
	}
	
	protected int getParameterValue() {
		return parameterValue;
	}
	
}
