/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi;

import net.sf.asterisk.fastagi.AGIChannel;
import net.sf.asterisk.fastagi.AGIException;
import net.sf.asterisk.fastagi.AGIScript;
import net.sf.asterisk.fastagi.command.AnswerCommand;
import net.sf.asterisk.fastagi.command.ChannelStatusCommand;
import net.sf.asterisk.fastagi.command.ExecCommand;
import net.sf.asterisk.fastagi.command.GetDataCommand;
import net.sf.asterisk.fastagi.command.GetOptionCommand;
import net.sf.asterisk.fastagi.command.GetVariableCommand;
import net.sf.asterisk.fastagi.command.HangupCommand;
import net.sf.asterisk.fastagi.command.SayAlphaCommand;
import net.sf.asterisk.fastagi.command.SayDigitsCommand;
import net.sf.asterisk.fastagi.command.SayNumberCommand;
import net.sf.asterisk.fastagi.command.SayPhoneticCommand;
import net.sf.asterisk.fastagi.command.SayTimeCommand;
import net.sf.asterisk.fastagi.command.SetAutoHangupCommand;
import net.sf.asterisk.fastagi.command.SetCallerIdCommand;
import net.sf.asterisk.fastagi.command.SetContextCommand;
import net.sf.asterisk.fastagi.command.SetExtensionCommand;
import net.sf.asterisk.fastagi.command.SetMusicOffCommand;
import net.sf.asterisk.fastagi.command.SetMusicOnCommand;
import net.sf.asterisk.fastagi.command.SetPriorityCommand;
import net.sf.asterisk.fastagi.command.SetVariableCommand;
import net.sf.asterisk.fastagi.command.StreamFileCommand;
import net.sf.asterisk.fastagi.command.WaitForDigitCommand;
import net.sf.asterisk.fastagi.reply.AGIReply;

public abstract class AbstractAGIScript
implements AGIScript {
    protected void answer(AGIChannel channel) throws AGIException {
        channel.sendCommand(new AnswerCommand());
    }

    protected void hangup(AGIChannel channel) throws AGIException {
        channel.sendCommand(new HangupCommand());
    }

    protected void setAutoHangup(AGIChannel channel, int time) throws AGIException {
        channel.sendCommand(new SetAutoHangupCommand(time));
    }

    protected void setCallerId(AGIChannel channel, String callerId) throws AGIException {
        channel.sendCommand(new SetCallerIdCommand(callerId));
    }

    protected void playMusicOnHold(AGIChannel channel) throws AGIException {
        channel.sendCommand(new SetMusicOnCommand());
    }

    protected void playMusicOnHold(AGIChannel channel, String musicOnHoldClass) throws AGIException {
        channel.sendCommand(new SetMusicOnCommand(musicOnHoldClass));
    }

    protected void stopMusicOnHold(AGIChannel channel) throws AGIException {
        channel.sendCommand(new SetMusicOffCommand());
    }

    protected int getChannelStatus(AGIChannel channel) throws AGIException {
        AGIReply reply = channel.sendCommand(new ChannelStatusCommand());
        return reply.getResultCode();
    }

    protected String getData(AGIChannel channel, String file) throws AGIException {
        AGIReply reply = channel.sendCommand(new GetDataCommand(file));
        return reply.getResult();
    }

    protected String getData(AGIChannel channel, String file, int timeout) throws AGIException {
        AGIReply reply = channel.sendCommand(new GetDataCommand(file, timeout));
        return reply.getResult();
    }

    protected String getData(AGIChannel channel, String file, int timeout, int maxDigits) throws AGIException {
        AGIReply reply = channel.sendCommand(new GetDataCommand(file, timeout, maxDigits));
        return reply.getResult();
    }

    protected char getOption(AGIChannel channel, String file, String escapeDigits) throws AGIException {
        AGIReply reply = channel.sendCommand(new GetOptionCommand(file, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected char getOption(AGIChannel channel, String file, String escapeDigits, int timeout) throws AGIException {
        AGIReply reply = channel.sendCommand(new GetOptionCommand(file, escapeDigits, timeout));
        return reply.getResultCodeAsChar();
    }

    protected int exec(AGIChannel channel, String application) throws AGIException {
        AGIReply reply = channel.sendCommand(new ExecCommand(application));
        return reply.getResultCode();
    }

    protected int exec(AGIChannel channel, String application, String options) throws AGIException {
        AGIReply reply = channel.sendCommand(new ExecCommand(application, options));
        return reply.getResultCode();
    }

    protected int execCommand(AGIChannel channel, String application) throws AGIException {
        AGIReply reply = channel.sendCommand(new ExecCommand(application));
        return reply.getResultCode();
    }

    protected int execCommand(AGIChannel channel, String application, String options) throws AGIException {
        AGIReply reply = channel.sendCommand(new ExecCommand(application, options));
        return reply.getResultCode();
    }

    protected void setContext(AGIChannel channel, String context) throws AGIException {
        channel.sendCommand(new SetContextCommand(context));
    }

    protected void setExtension(AGIChannel channel, String extension) throws AGIException {
        channel.sendCommand(new SetExtensionCommand(extension));
    }

    protected void setPriority(AGIChannel channel, int priority) throws AGIException {
        channel.sendCommand(new SetPriorityCommand(priority));
    }

    protected void streamFile(AGIChannel channel, String file) throws AGIException {
        channel.sendCommand(new StreamFileCommand(file));
    }

    protected char streamFile(AGIChannel channel, String file, String escapeDigits) throws AGIException {
        AGIReply reply = channel.sendCommand(new StreamFileCommand(file, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayDigits(AGIChannel channel, String digits) throws AGIException {
        channel.sendCommand(new SayDigitsCommand(digits));
    }

    protected char sayDigits(AGIChannel channel, String digits, String escapeDigits) throws AGIException {
        AGIReply reply = channel.sendCommand(new SayDigitsCommand(digits, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayNumber(AGIChannel channel, String number) throws AGIException {
        channel.sendCommand(new SayNumberCommand(number));
    }

    protected char sayNumber(AGIChannel channel, String number, String escapeDigits) throws AGIException {
        AGIReply reply = channel.sendCommand(new SayNumberCommand(number, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayPhonetic(AGIChannel channel, String text) throws AGIException {
        channel.sendCommand(new SayPhoneticCommand(text));
    }

    protected char sayPhonetic(AGIChannel channel, String text, String escapeDigits) throws AGIException {
        AGIReply reply = channel.sendCommand(new SayPhoneticCommand(text, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayAlpha(AGIChannel channel, String text) throws AGIException {
        channel.sendCommand(new SayAlphaCommand(text));
    }

    protected char sayAlpha(AGIChannel channel, String text, String escapeDigits) throws AGIException {
        AGIReply reply = channel.sendCommand(new SayAlphaCommand(text, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayTime(AGIChannel channel, long time) throws AGIException {
        channel.sendCommand(new SayTimeCommand(time));
    }

    protected char sayTime(AGIChannel channel, long time, String escapeDigits) throws AGIException {
        AGIReply reply = channel.sendCommand(new SayTimeCommand(time, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected String getVariable(AGIChannel channel, String name) throws AGIException {
        AGIReply reply = channel.sendCommand(new GetVariableCommand(name));
        if (reply.getResultCode() != 1) {
            return null;
        }
        return reply.getExtra();
    }

    protected void setVariable(AGIChannel channel, String name, String value) throws AGIException {
        channel.sendCommand(new SetVariableCommand(name, value));
    }

    protected char waitForDigit(AGIChannel channel, int timeout) throws AGIException {
        AGIReply reply = channel.sendCommand(new WaitForDigitCommand(timeout));
        return reply.getResultCodeAsChar();
    }
}

