/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi;

import net.sf.asterisk.fastagi.AGIChannel;
import net.sf.asterisk.fastagi.AGIConnectionHandler;
import net.sf.asterisk.fastagi.AGIException;
import net.sf.asterisk.fastagi.AGIScript;
import net.sf.asterisk.fastagi.command.AGICommand;
import net.sf.asterisk.fastagi.command.AnswerCommand;
import net.sf.asterisk.fastagi.command.ChannelStatusCommand;
import net.sf.asterisk.fastagi.command.ExecCommand;
import net.sf.asterisk.fastagi.command.GetDataCommand;
import net.sf.asterisk.fastagi.command.GetOptionCommand;
import net.sf.asterisk.fastagi.command.GetVariableCommand;
import net.sf.asterisk.fastagi.command.HangupCommand;
import net.sf.asterisk.fastagi.command.SayAlphaCommand;
import net.sf.asterisk.fastagi.command.SayDigitsCommand;
import net.sf.asterisk.fastagi.command.SayNumberCommand;
import net.sf.asterisk.fastagi.command.SayPhoneticCommand;
import net.sf.asterisk.fastagi.command.SayTimeCommand;
import net.sf.asterisk.fastagi.command.SetAutoHangupCommand;
import net.sf.asterisk.fastagi.command.SetCallerIdCommand;
import net.sf.asterisk.fastagi.command.SetContextCommand;
import net.sf.asterisk.fastagi.command.SetExtensionCommand;
import net.sf.asterisk.fastagi.command.SetMusicOffCommand;
import net.sf.asterisk.fastagi.command.SetMusicOnCommand;
import net.sf.asterisk.fastagi.command.SetPriorityCommand;
import net.sf.asterisk.fastagi.command.SetVariableCommand;
import net.sf.asterisk.fastagi.command.StreamFileCommand;
import net.sf.asterisk.fastagi.command.WaitForDigitCommand;
import net.sf.asterisk.fastagi.reply.AGIReply;

public abstract class BaseAGIScript
implements AGIScript {
    protected void answer() throws AGIException {
        this.sendCommand(new AnswerCommand());
    }

    protected void hangup() throws AGIException {
        this.sendCommand(new HangupCommand());
    }

    protected void setAutoHangup(int time) throws AGIException {
        this.sendCommand(new SetAutoHangupCommand(time));
    }

    protected void setCallerId(String callerId) throws AGIException {
        this.sendCommand(new SetCallerIdCommand(callerId));
    }

    protected void playMusicOnHold() throws AGIException {
        this.sendCommand(new SetMusicOnCommand());
    }

    protected void playMusicOnHold(String musicOnHoldClass) throws AGIException {
        this.sendCommand(new SetMusicOnCommand(musicOnHoldClass));
    }

    protected void stopMusicOnHold() throws AGIException {
        this.sendCommand(new SetMusicOffCommand());
    }

    protected int getChannelStatus() throws AGIException {
        AGIReply reply = this.sendCommand(new ChannelStatusCommand());
        return reply.getResultCode();
    }

    protected String getData(String file) throws AGIException {
        AGIReply reply = this.sendCommand(new GetDataCommand(file));
        return reply.getResult();
    }

    protected String getData(String file, int timeout) throws AGIException {
        AGIReply reply = this.sendCommand(new GetDataCommand(file, timeout));
        return reply.getResult();
    }

    protected String getData(String file, int timeout, int maxDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new GetDataCommand(file, timeout, maxDigits));
        return reply.getResult();
    }

    protected char getOption(String file, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new GetOptionCommand(file, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected char getOption(String file, String escapeDigits, int timeout) throws AGIException {
        AGIReply reply = this.sendCommand(new GetOptionCommand(file, escapeDigits, timeout));
        return reply.getResultCodeAsChar();
    }

    protected int exec(String application) throws AGIException {
        AGIReply reply = this.sendCommand(new ExecCommand(application));
        return reply.getResultCode();
    }

    protected int exec(String application, String options) throws AGIException {
        AGIReply reply = this.sendCommand(new ExecCommand(application, options));
        return reply.getResultCode();
    }

    protected void setContext(String context) throws AGIException {
        this.sendCommand(new SetContextCommand(context));
    }

    protected void setExtension(String extension) throws AGIException {
        this.sendCommand(new SetExtensionCommand(extension));
    }

    protected void setPriority(int priority) throws AGIException {
        this.sendCommand(new SetPriorityCommand(priority));
    }

    protected void streamFile(String file) throws AGIException {
        this.sendCommand(new StreamFileCommand(file));
    }

    protected char streamFile(String file, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new StreamFileCommand(file, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayDigits(String digits) throws AGIException {
        this.sendCommand(new SayDigitsCommand(digits));
    }

    protected char sayDigits(String digits, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayDigitsCommand(digits, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayNumber(String number) throws AGIException {
        this.sendCommand(new SayNumberCommand(number));
    }

    protected char sayNumber(String number, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayNumberCommand(number, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayPhonetic(String text) throws AGIException {
        this.sendCommand(new SayPhoneticCommand(text));
    }

    protected char sayPhonetic(String text, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayPhoneticCommand(text, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayAlpha(String text) throws AGIException {
        this.sendCommand(new SayAlphaCommand(text));
    }

    protected char sayAlpha(String text, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayAlphaCommand(text, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected void sayTime(long time) throws AGIException {
        this.sendCommand(new SayTimeCommand(time));
    }

    protected char sayTime(long time, String escapeDigits) throws AGIException {
        AGIReply reply = this.sendCommand(new SayTimeCommand(time, escapeDigits));
        return reply.getResultCodeAsChar();
    }

    protected String getVariable(String name) throws AGIException {
        AGIReply reply = this.sendCommand(new GetVariableCommand(name));
        if (reply.getResultCode() != 1) {
            return null;
        }
        return reply.getExtra();
    }

    protected void setVariable(String name, String value) throws AGIException {
        this.sendCommand(new SetVariableCommand(name, value));
    }

    protected char waitForDigit(int timeout) throws AGIException {
        AGIReply reply = this.sendCommand(new WaitForDigitCommand(timeout));
        return reply.getResultCodeAsChar();
    }

    private AGIReply sendCommand(AGICommand command) throws AGIException {
        AGIChannel channel = AGIConnectionHandler.getChannel();
        if (channel == null) {
            throw new RuntimeException("Trying to send command from an invalid thread");
        }
        return channel.sendCommand(command);
    }
}

