/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.impl;

import net.sf.asterisk.fastagi.AGIChannel;
import net.sf.asterisk.fastagi.AGIException;
import net.sf.asterisk.fastagi.AGIReader;
import net.sf.asterisk.fastagi.AGIWriter;
import net.sf.asterisk.fastagi.InvalidCommandSyntaxException;
import net.sf.asterisk.fastagi.InvalidOrUnknownCommandException;
import net.sf.asterisk.fastagi.command.AGICommand;
import net.sf.asterisk.fastagi.impl.AGIReaderImpl;
import net.sf.asterisk.fastagi.impl.AGIWriterImpl;
import net.sf.asterisk.fastagi.reply.AGIReply;
import net.sf.asterisk.io.SocketConnectionFacade;

public class AGIChannelImpl
implements AGIChannel {
    private AGIWriter agiWriter;
    private AGIReader agiReader;

    public AGIChannelImpl(SocketConnectionFacade socket) {
        this.agiWriter = new AGIWriterImpl(socket);
        this.agiReader = new AGIReaderImpl(socket);
    }

    public AGIChannelImpl(AGIWriter agiWriter, AGIReader agiReader) {
        this.agiWriter = agiWriter;
        this.agiReader = agiReader;
    }

    public synchronized AGIReply sendCommand(AGICommand command) throws AGIException {
        this.agiWriter.sendCommand(command);
        AGIReply reply = this.agiReader.readReply();
        if (reply.getStatus() == 510) {
            throw new InvalidOrUnknownCommandException(command.buildCommand());
        }
        if (reply.getStatus() == 520) {
            throw new InvalidCommandSyntaxException(reply.getSynopsis(), reply.getUsage());
        }
        return reply;
    }
}

