/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.impl;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.asterisk.fastagi.AGIRequest;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class AGIRequestImpl
implements Serializable,
AGIRequest {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final Pattern SCRIPT_PATTERN = Pattern.compile("^([^\\?]*)\\?(.*)$");
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("^(.*)=(.*)$");
    private String rawCallerId;
    private static final long serialVersionUID = 3257001047145789496L;
    private Map request;
    private Map parameterMap;
    private String parameters;
    private String script;
    private boolean callerIdCreated;

    public AGIRequestImpl(Collection environment) {
        if (environment == null) {
            throw new IllegalArgumentException("Environment must not be null.");
        }
        this.request = this.buildMap(environment);
    }

    private Map buildMap(Collection lines) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator lineIterator = lines.iterator();
        while (lineIterator.hasNext()) {
            String line = (String)lineIterator.next();
            int colonPosition = line.indexOf(58);
            if (colonPosition < 0 || !line.startsWith("agi_") || line.length() < colonPosition + 2) continue;
            String key = line.substring(4, colonPosition).toLowerCase();
            String value = line.substring(colonPosition + 2);
            if (value.length() == 0) continue;
            map.put(key, value);
        }
        return map;
    }

    public Map getRequest() {
        return this.request;
    }

    public synchronized String getScript() {
        Matcher scriptMatcher;
        if (this.script != null) {
            return this.script;
        }
        this.script = (String)this.request.get("network_script");
        if (this.script != null && (scriptMatcher = SCRIPT_PATTERN.matcher(this.script)).matches()) {
            this.script = scriptMatcher.group(1);
            this.parameters = scriptMatcher.group(2);
        }
        return this.script;
    }

    public String getRequestURL() {
        return (String)this.request.get("request");
    }

    public String getChannel() {
        return (String)this.request.get("channel");
    }

    public String getUniqueId() {
        return (String)this.request.get("uniqueid");
    }

    public String getType() {
        return (String)this.request.get("type");
    }

    public String getLanguage() {
        return (String)this.request.get("language");
    }

    public String getCallerId() {
        if (!this.callerIdCreated) {
            this.rawCallerId = (String)this.request.get("callerid");
            this.callerIdCreated = true;
        }
        if (this.rawCallerId == null) {
            return null;
        }
        int lbPosition = this.rawCallerId.indexOf(60);
        int rbPosition = this.rawCallerId.indexOf(62);
        if (lbPosition < 0 || rbPosition < 0) {
            return this.rawCallerId;
        }
        return this.rawCallerId.substring(lbPosition + 1, rbPosition);
    }

    public String getCallerIdName() {
        if (!this.callerIdCreated) {
            this.rawCallerId = (String)this.request.get("callerid");
            this.callerIdCreated = true;
        }
        if (this.rawCallerId == null) {
            return null;
        }
        int lbPosition = this.rawCallerId.indexOf(60);
        if (lbPosition < 0) {
            return null;
        }
        String callerIdName = this.rawCallerId.substring(0, lbPosition).trim();
        if (callerIdName.startsWith("\"") && callerIdName.endsWith("\"")) {
            callerIdName = callerIdName.substring(1, callerIdName.length() - 1);
        }
        if (callerIdName.length() == 0) {
            return null;
        }
        return callerIdName;
    }

    public String getDnid() {
        return (String)this.request.get("dnid");
    }

    public String getRdnis() {
        return (String)this.request.get("rdnis");
    }

    public String getContext() {
        return (String)this.request.get("context");
    }

    public String getExtension() {
        return (String)this.request.get("extension");
    }

    public Integer getPriority() {
        if (this.request.get("priority") != null) {
            return new Integer((String)this.request.get("priority"));
        }
        return null;
    }

    public Boolean getEnhanced() {
        if (this.request.get("enhanced") != null) {
            if ("1.0".equals((String)this.request.get("enhanced"))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public String getAccountCode() {
        return (String)this.request.get("accountCode");
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        if (this.getParameterMap().isEmpty()) {
            return null;
        }
        return (String[])this.parameterMap.get(name);
    }

    public synchronized Map getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = this.parseParameters(this.parameters);
        }
        return this.parameterMap;
    }

    private synchronized Map parseParameters(String s) {
        HashMap parameterMap = new HashMap();
        if (s == null) {
            return parameterMap;
        }
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            List<String> values;
            String value;
            String name;
            block9: {
                String parameter = st.nextToken();
                Matcher parameterMatcher = PARAMETER_PATTERN.matcher(parameter);
                if (parameterMatcher.matches()) {
                    try {
                        name = URLDecoder.decode(parameterMatcher.group(1), "UTF-8");
                        value = URLDecoder.decode(parameterMatcher.group(2), "UTF-8");
                        break block9;
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.error("Unable to decode parameter '" + parameter + "'", e);
                        continue;
                    }
                }
                try {
                    name = URLDecoder.decode(parameter, "UTF-8");
                    value = "";
                }
                catch (UnsupportedEncodingException e) {
                    this.logger.error("Unable to decode parameter '" + parameter + "'", e);
                    continue;
                }
            }
            if (parameterMap.get(name) == null) {
                values = new ArrayList<String>();
                values.add(value);
                parameterMap.put(name, values);
                continue;
            }
            values = (List)parameterMap.get(name);
            values.add(value);
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Iterator parameterIterator = parameterMap.keySet().iterator();
        while (parameterIterator.hasNext()) {
            String name = (String)parameterIterator.next();
            List values = (List)parameterMap.get(name);
            String[] valueArray = new String[values.size()];
            result.put(name, values.toArray(valueArray));
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append("script='" + this.getScript() + "'; ");
        sb.append("requestURL='" + this.getRequestURL() + "'; ");
        sb.append("channel='" + this.getChannel() + "'; ");
        sb.append("uniqueId='" + this.getUniqueId() + "'; ");
        sb.append("type='" + this.getType() + "'; ");
        sb.append("language='" + this.getLanguage() + "'; ");
        sb.append("callerId='" + this.getCallerId() + "'; ");
        sb.append("callerIdName='" + this.getCallerIdName() + "'; ");
        sb.append("dnid='" + this.getDnid() + "'; ");
        sb.append("rdnis='" + this.getRdnis() + "'; ");
        sb.append("context='" + this.getContext() + "'; ");
        sb.append("extension='" + this.getExtension() + "'; ");
        sb.append("priority='" + this.getPriority() + "'; ");
        sb.append("enhanced='" + this.getEnhanced() + "'; ");
        sb.append("accountCode='" + this.getAccountCode() + "'; ");
        sb.append("systemHashcode=" + System.identityHashCode(this));
        return sb.toString();
    }
}

