/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager;

import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.asterisk.io.SocketConnectionFacade;
import net.sf.asterisk.io.SocketConnectionFacadeImpl;
import net.sf.asterisk.manager.AsteriskServer;
import net.sf.asterisk.manager.AuthenticationFailedException;
import net.sf.asterisk.manager.Dispatcher;
import net.sf.asterisk.manager.EventTimeoutException;
import net.sf.asterisk.manager.ManagerConnection;
import net.sf.asterisk.manager.ManagerEventHandler;
import net.sf.asterisk.manager.ManagerReader;
import net.sf.asterisk.manager.ManagerResponseHandler;
import net.sf.asterisk.manager.ManagerWriter;
import net.sf.asterisk.manager.ResponseEvents;
import net.sf.asterisk.manager.TimeoutException;
import net.sf.asterisk.manager.Util;
import net.sf.asterisk.manager.action.ChallengeAction;
import net.sf.asterisk.manager.action.EventGeneratingAction;
import net.sf.asterisk.manager.action.LoginAction;
import net.sf.asterisk.manager.action.LogoffAction;
import net.sf.asterisk.manager.action.ManagerAction;
import net.sf.asterisk.manager.event.ConnectEvent;
import net.sf.asterisk.manager.event.DisconnectEvent;
import net.sf.asterisk.manager.event.ManagerEvent;
import net.sf.asterisk.manager.event.ResponseEvent;
import net.sf.asterisk.manager.impl.ManagerReaderImpl;
import net.sf.asterisk.manager.impl.ManagerWriterImpl;
import net.sf.asterisk.manager.impl.ResponseEventsImpl;
import net.sf.asterisk.manager.response.ChallengeResponse;
import net.sf.asterisk.manager.response.ManagerError;
import net.sf.asterisk.manager.response.ManagerResponse;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class DefaultManagerConnection
implements ManagerConnection,
Dispatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private long actionIdCount = 0L;
    private AsteriskServer asteriskServer = new AsteriskServer();
    protected String username;
    protected String password;
    private long defaultResponseTimeout = 2000L;
    private long defaultEventTimeout = 5000L;
    private long sleepTime = 50L;
    private boolean keepAliveAfterAuthenticationFailure = false;
    private SocketConnectionFacade socket;
    private Thread readerThread;
    private ManagerReader reader;
    private ManagerWriter writer;
    private String protocolIdentifier;
    private final Map responseHandlers = new HashMap();
    private final Map responseEventHandlers = new HashMap();
    private final List eventHandlers = new ArrayList();
    protected boolean keepAlive = false;
    static /* synthetic */ Class class$net$sf$asterisk$manager$event$ResponseEvent;

    public DefaultManagerConnection() {
    }

    public DefaultManagerConnection(String hostname, int port, String username, String password) {
        this();
        this.setHostname(hostname);
        this.setPort(port);
        this.setUsername(username);
        this.setPassword(password);
    }

    protected ManagerReader createReader(Dispatcher dispatcher, AsteriskServer server) {
        return new ManagerReaderImpl(dispatcher, server);
    }

    protected ManagerWriter createWriter() {
        return new ManagerWriterImpl();
    }

    public void setHostname(String hostname) {
        this.asteriskServer.setHostname(hostname);
    }

    public void setPort(int port) {
        this.asteriskServer.setPort(port);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.setDefaultResponseTimeout(defaultTimeout);
    }

    public void setDefaultResponseTimeout(long defaultResponseTimeout) {
        this.defaultResponseTimeout = defaultResponseTimeout;
    }

    public void setDefaultEventTimeout(long defaultEventTimeout) {
        this.defaultEventTimeout = defaultEventTimeout;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setKeepAliveAfterAuthenticationFailure(boolean keepAliveAfterAuthenticationFailure) {
        this.keepAliveAfterAuthenticationFailure = keepAliveAfterAuthenticationFailure;
    }

    public void registerUserEventClass(Class userEventClass) {
        if (this.reader == null) {
            this.reader = this.createReader(this, this.asteriskServer);
        }
        this.reader.registerEventClass(userEventClass);
    }

    public void login() throws IOException, AuthenticationFailedException, TimeoutException {
        this.login(this.defaultResponseTimeout);
    }

    private void login(long timeout) throws IOException, AuthenticationFailedException, TimeoutException {
        String key;
        if (this.socket == null) {
            this.connect();
        }
        long start = System.currentTimeMillis();
        while (this.getProtocolIdentifier() == null) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long timeSpent = System.currentTimeMillis() - start;
            if (this.getProtocolIdentifier() != null || timeSpent <= timeout) continue;
            this.disconnect();
            throw new TimeoutException("Timeout waiting for protocol identifier");
        }
        ChallengeAction challengeAction = new ChallengeAction("MD5");
        ChallengeResponse challengeResponse = (ChallengeResponse)this.sendAction(challengeAction);
        String challenge = challengeResponse.getChallenge();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (challenge != null) {
                md.update(challenge.getBytes());
            }
            if (this.password != null) {
                md.update(this.password.getBytes());
            }
            key = Util.toHexString(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to create login key using MD5 Message Digest", ex);
        }
        LoginAction loginAction = new LoginAction(this.username, "MD5", key);
        ManagerResponse loginResponse = this.sendAction(loginAction);
        if (loginResponse instanceof ManagerError) {
            this.disconnect();
            throw new AuthenticationFailedException(loginResponse.getMessage());
        }
        this.keepAlive = true;
        this.logger.info("Successfully logged in");
    }

    protected synchronized void connect() throws IOException {
        this.logger.info("Connecting to " + this.asteriskServer.getHostname() + " port " + this.asteriskServer.getPort());
        if (this.reader == null) {
            this.reader = this.createReader(this, this.asteriskServer);
        }
        if (this.writer == null) {
            this.writer = this.createWriter();
        }
        this.socket = this.createSocket();
        this.reader.setSocket(this.socket);
        this.readerThread = new Thread((Runnable)this.reader, "ManagerReader");
        this.readerThread.start();
        this.writer.setSocket(this.socket);
    }

    protected SocketConnectionFacade createSocket() throws IOException {
        return new SocketConnectionFacadeImpl(this.asteriskServer.getHostname(), this.asteriskServer.getPort());
    }

    public synchronized boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public synchronized void logoff() throws IOException, TimeoutException {
        this.keepAlive = false;
        LogoffAction logoffAction = new LogoffAction();
        if (this.socket != null) {
            this.sendAction(logoffAction);
            this.disconnect();
        }
    }

    private synchronized void disconnect() {
        if (this.socket != null) {
            this.logger.info("Closing socket.");
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.logger.warn("Unable to close socket: " + ex.getMessage());
            }
            this.socket = null;
        }
    }

    public ManagerResponse sendAction(ManagerAction action) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendAction(action, this.defaultResponseTimeout);
    }

    public ManagerResponse sendAction(ManagerAction action, long timeout) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        ResponseHandlerResult result = new ResponseHandlerResult();
        DefaultResponseHandler callbackHandler = new DefaultResponseHandler(result, Thread.currentThread());
        this.sendAction(action, callbackHandler);
        long start = System.currentTimeMillis();
        long timeSpent = 0L;
        while (result.getResponse() == null) {
            try {
                Thread.sleep(timeout - timeSpent);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            timeSpent = System.currentTimeMillis() - start;
            if (result.getResponse() != null || timeSpent <= timeout) continue;
            throw new TimeoutException("Timeout waiting for response to " + action.getAction());
        }
        return result.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAction(ManagerAction action, ManagerResponseHandler callbackHandler) throws IOException, IllegalArgumentException, IllegalStateException {
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (this.socket == null) {
            throw new IllegalStateException("Unable to send " + action.getAction() + " action: not connected.");
        }
        String internalActionId = this.createInternalActionId();
        action.setActionId(Util.addInternalActionId(action.getActionId(), internalActionId));
        if (callbackHandler != null) {
            Map map = this.responseHandlers;
            synchronized (map) {
                this.responseHandlers.put(internalActionId, callbackHandler);
            }
        }
        this.writer.sendAction(action);
    }

    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendEventGeneratingAction(action, this.defaultEventTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action, long timeout) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (action.getActionCompleteEventClass() == null) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass is null.");
        }
        if (!(class$net$sf$asterisk$manager$event$ResponseEvent == null ? (class$net$sf$asterisk$manager$event$ResponseEvent = DefaultManagerConnection.class$("net.sf.asterisk.manager.event.ResponseEvent")) : class$net$sf$asterisk$manager$event$ResponseEvent).isAssignableFrom(action.getActionCompleteEventClass())) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass is not a ResponseEvent.");
        }
        if (this.socket == null) {
            throw new IllegalStateException("Unable to send " + action.getAction() + " action: not connected.");
        }
        ResponseEventsImpl responseEvents = new ResponseEventsImpl();
        ResponseEventHandler responseEventHandler = new ResponseEventHandler(responseEvents, action.getActionCompleteEventClass(), Thread.currentThread());
        String internalActionId = this.createInternalActionId();
        action.setActionId(Util.addInternalActionId(action.getActionId(), internalActionId));
        Map map = this.responseHandlers;
        synchronized (map) {
            this.responseHandlers.put(internalActionId, responseEventHandler);
        }
        map = this.responseEventHandlers;
        synchronized (map) {
            this.responseEventHandlers.put(internalActionId, responseEventHandler);
        }
        this.writer.sendAction(action);
        long start = System.currentTimeMillis();
        long timeSpent = 0L;
        while (responseEvents.getResponse() == null || !responseEvents.isComplete()) {
            try {
                Thread.sleep(timeout - timeSpent);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            timeSpent = System.currentTimeMillis() - start;
            if (responseEvents.getResponse() != null && responseEvents.isComplete() || timeSpent <= timeout) continue;
            map = this.responseEventHandlers;
            synchronized (map) {
                this.responseEventHandlers.remove(internalActionId);
            }
            throw new EventTimeoutException("Timeout waiting for response or response events to " + action.getAction(), responseEvents);
        }
        map = this.responseEventHandlers;
        synchronized (map) {
            this.responseEventHandlers.remove(internalActionId);
        }
        return responseEvents;
    }

    private String createInternalActionId() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.hashCode());
        sb.append("_");
        sb.append(this.actionIdCount++);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandler(ManagerEventHandler eventHandler) {
        List list = this.eventHandlers;
        synchronized (list) {
            if (!this.eventHandlers.contains(eventHandler)) {
                this.eventHandlers.add(eventHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventHandler(ManagerEventHandler eventHandler) {
        List list = this.eventHandlers;
        synchronized (list) {
            if (this.eventHandlers.contains(eventHandler)) {
                this.eventHandlers.remove(eventHandler);
            }
        }
    }

    public String getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    public AsteriskServer getAsteriskServer() {
        return this.asteriskServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchResponse(ManagerResponse response) {
        if (response == null) {
            this.logger.error("Unable to dispatch null response");
            return;
        }
        String actionId = response.getActionId();
        String internalActionId = null;
        ManagerResponseHandler responseHandler = null;
        if (actionId != null) {
            internalActionId = Util.getInternalActionId(actionId);
            response.setActionId(Util.stripInternalActionId(actionId));
        }
        this.logger.debug("Dispatching response with internalActionId '" + internalActionId + "':\n" + response);
        if (internalActionId != null) {
            Map map = this.responseHandlers;
            synchronized (map) {
                responseHandler = (ManagerResponseHandler)this.responseHandlers.get(internalActionId);
                if (responseHandler != null) {
                    this.responseHandlers.remove(internalActionId);
                } else {
                    this.logger.debug("No response handler registered for internalActionId '" + internalActionId + "'");
                }
            }
        } else {
            this.logger.error("Unable to retrieve internalActionId from response: actionId '" + actionId + "':\n" + response);
        }
        if (responseHandler != null) {
            try {
                responseHandler.handleResponse(response);
            }
            catch (RuntimeException e) {
                this.logger.warn("Unexpected exception in responseHandler " + responseHandler.getClass().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(ManagerEvent event) {
        Object responseEvent;
        if (event == null) {
            this.logger.error("Unable to dispatch null event");
            return;
        }
        this.logger.debug("Dispatching event:\n" + event.toString());
        if (event instanceof ResponseEvent) {
            responseEvent = (ResponseEvent)event;
            String internalActionId = ((ResponseEvent)responseEvent).getInternalActionId();
            if (internalActionId != null) {
                Map map = this.responseEventHandlers;
                synchronized (map) {
                    ManagerEventHandler eventHandler = (ManagerEventHandler)this.responseEventHandlers.get(internalActionId);
                    if (eventHandler != null) {
                        try {
                            eventHandler.handleEvent(event);
                        }
                        catch (RuntimeException e) {
                            this.logger.warn("Unexpected exception in eventHandler " + eventHandler.getClass().getName(), e);
                        }
                    }
                }
            }
            this.logger.error("Unable to handle ResponseEvent without internalActionId:\n" + responseEvent);
        }
        responseEvent = this.eventHandlers;
        synchronized (responseEvent) {
            Iterator i = this.eventHandlers.iterator();
            while (i.hasNext()) {
                ManagerEventHandler eventHandler = (ManagerEventHandler)i.next();
                try {
                    eventHandler.handleEvent(event);
                }
                catch (RuntimeException e) {
                    this.logger.warn("Unexpected exception in eventHandler " + eventHandler.getClass().getName(), e);
                }
            }
        }
        if (event instanceof ConnectEvent) {
            ConnectEvent connectEvent = (ConnectEvent)event;
            String protocolIdentifier = connectEvent.getProtocolIdentifier();
            this.setProtocolIdentifier(protocolIdentifier);
        } else if (event instanceof DisconnectEvent) {
            this.reconnect();
        }
    }

    private void setProtocolIdentifier(String protocolIdentifier) {
        this.logger.info("Connected via " + protocolIdentifier);
        if (!"Asterisk Call Manager/1.0".equals(protocolIdentifier)) {
            this.logger.warn("Unsupported protocol version '" + protocolIdentifier + "'. Use at your own risk.");
        }
        this.protocolIdentifier = protocolIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        this.disconnect();
        int numTries = 0;
        while (this.keepAlive) {
            try {
                if (numTries < 10) {
                    Thread.sleep(50L);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            try {
                this.connect();
                try {
                    this.login();
                    this.logger.info("Successfully reconnected.");
                    break;
                }
                catch (AuthenticationFailedException e1) {
                    if (this.keepAliveAfterAuthenticationFailure) {
                        this.logger.error("Unable to log in after reconnect.");
                    } else {
                        this.logger.error("Unable to log in after reconnect. Giving up.");
                        this.keepAlive = false;
                    }
                }
                catch (TimeoutException e1) {
                    this.logger.error("TimeoutException while trying to log in after reconnect.");
                    DefaultManagerConnection defaultManagerConnection = this;
                    synchronized (defaultManagerConnection) {
                        this.socket.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn("Exception while trying to reconnect: " + e.getMessage());
            }
            ++numTries;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResponseEventHandler
    implements ManagerEventHandler,
    ManagerResponseHandler,
    Serializable {
        private static final long serialVersionUID = 2926598671855316803L;
        private final ResponseEventsImpl events;
        private final Class actionCompleteEventClass;
        private final Thread thread;

        public ResponseEventHandler(ResponseEventsImpl events, Class actionCompleteEventClass, Thread thread) {
            this.events = events;
            this.actionCompleteEventClass = actionCompleteEventClass;
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ManagerEvent event) {
            if (event instanceof ResponseEvent) {
                ResponseEvent responseEvent = (ResponseEvent)event;
                this.events.addEvent(responseEvent);
            }
            if (this.actionCompleteEventClass.isAssignableFrom(event.getClass())) {
                ResponseEventsImpl responseEventsImpl = this.events;
                synchronized (responseEventsImpl) {
                    this.events.setComplete(true);
                    if (this.events.getResponse() != null) {
                        this.thread.interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleResponse(ManagerResponse response) {
            ResponseEventsImpl responseEventsImpl = this.events;
            synchronized (responseEventsImpl) {
                this.events.setRepsonse(response);
                if (response instanceof ManagerError) {
                    this.events.setComplete(true);
                }
                if (this.events.isComplete()) {
                    this.thread.interrupt();
                }
            }
        }
    }

    private class DefaultResponseHandler
    implements ManagerResponseHandler,
    Serializable {
        private static final long serialVersionUID = 2926598671855316803L;
        private ResponseHandlerResult result;
        private final Thread thread;

        public DefaultResponseHandler(ResponseHandlerResult result, Thread thread) {
            this.result = result;
            this.thread = thread;
        }

        public void handleResponse(ManagerResponse response) {
            this.result.setResponse(response);
            this.thread.interrupt();
        }
    }

    private class ResponseHandlerResult
    implements Serializable {
        private static final long serialVersionUID = 7831097958568769220L;
        private ManagerResponse response;

        public ManagerResponse getResponse() {
            return this.response;
        }

        public void setResponse(ManagerResponse response) {
            this.response = response;
        }
    }
}

