/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.asterisk.manager.ActionBuilder;
import net.sf.asterisk.manager.action.ManagerAction;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class ActionBuilderImpl
implements ActionBuilder {
    private final Log logger = LogFactory.getLog(this.getClass());

    public final String buildAction(ManagerAction action) {
        StringBuffer sb = new StringBuffer();
        Map getters = this.getGetters(action.getClass());
        Iterator i = getters.keySet().iterator();
        while (i.hasNext()) {
            Object value;
            String name = (String)i.next();
            if ("class".equals(name)) continue;
            Method getter = (Method)getters.get(name);
            try {
                value = getter.invoke((Object)action, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                this.logger.error("Unable to retrieve property '" + name + "' of " + action.getClass(), ex);
                continue;
            }
            catch (InvocationTargetException ex) {
                this.logger.error("Unable to retrieve property '" + name + "' of " + action.getClass(), ex);
                continue;
            }
            if (value == null || value instanceof Class) continue;
            String stringValue = value instanceof String ? (String)value : value.toString();
            sb.append(name);
            sb.append(": ");
            sb.append(stringValue);
            sb.append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private Map getGetters(Class clazz) {
        HashMap<String, Method> accessors = new HashMap<String, Method>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("get") || method.getParameterTypes().length != 0 || (name = methodName.substring("get".length()).toLowerCase()).length() == 0) continue;
            accessors.put(name, method);
        }
        return accessors;
    }
}

