/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.util.ArrayList;
import java.util.List;

public class AstUtil {
    private static final List<String> TRUE_LITERALS = new ArrayList<String>(20);
    private static final List<String> NULL_LITERALS;

    private AstUtil() {
    }

    public static boolean isTrue(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (String literal : TRUE_LITERALS) {
            if (!literal.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static String[] parseCallerId(String s) {
        String name;
        String[] result = new String[2];
        if (s == null) {
            return result;
        }
        int lbPosition = s.lastIndexOf(60);
        int rbPosition = s.lastIndexOf(62);
        if (lbPosition < 0 || rbPosition < 0) {
            String name2 = s.trim();
            if (name2.length() == 0) {
                name2 = null;
            }
            result[0] = name2;
            return result;
        }
        String number = s.substring(lbPosition + 1, rbPosition).trim();
        if (number.length() == 0) {
            number = null;
        }
        if ((name = s.substring(0, lbPosition).trim()).startsWith("\"") && name.endsWith("\"") && name.length() > 1) {
            name = name.substring(1, name.length() - 1).trim();
        }
        if (name.length() == 0) {
            name = null;
        }
        result[0] = name;
        result[1] = number;
        return result;
    }

    public static boolean isNull(String s) {
        if (s == null) {
            return true;
        }
        for (String literal : NULL_LITERALS) {
            if (!literal.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    static {
        TRUE_LITERALS.add("yes");
        TRUE_LITERALS.add("true");
        TRUE_LITERALS.add("y");
        TRUE_LITERALS.add("t");
        TRUE_LITERALS.add("1");
        TRUE_LITERALS.add("on");
        TRUE_LITERALS.add("Enabled");
        NULL_LITERALS = new ArrayList<String>(20);
        NULL_LITERALS.add("<unknown>");
        NULL_LITERALS.add("unknown");
        NULL_LITERALS.add("<none>");
        NULL_LITERALS.add("(None)");
        NULL_LITERALS.add("<Not set>");
        NULL_LITERALS.add("(not set)");
        NULL_LITERALS.add("<no name>");
        NULL_LITERALS.add("n/a");
    }
}

