/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.asteriskjava.config.Category;
import org.asteriskjava.config.ConfigElement;
import org.asteriskjava.config.ConfigFile;
import org.asteriskjava.config.ConfigVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFileImpl
implements ConfigFile {
    private final String filename;
    private final Map<String, Category> categories;

    public ConfigFileImpl(String filename, Map<String, Category> categories) {
        this.filename = filename;
        this.categories = categories;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getCategories() {
        TreeMap<String, List<String>> c = new TreeMap<String, List<String>>();
        Map<String, Category> map = this.categories;
        synchronized (map) {
            for (Category category : this.categories.values()) {
                ArrayList<String> lines = new ArrayList<String>();
                for (ConfigElement element : category.getElements()) {
                    if (!(element instanceof ConfigVariable)) continue;
                    ConfigVariable cv = (ConfigVariable)element;
                    lines.add(cv.getName() + "=" + cv.getValue());
                }
                c.put(category.getName(), lines);
            }
        }
        return c;
    }

    @Override
    public String getValue(String categoryName, String key) {
        Category category = this.getCategory(categoryName);
        if (category == null) {
            return null;
        }
        for (ConfigElement element : category.getElements()) {
            ConfigVariable cv;
            if (!(element instanceof ConfigVariable) || !(cv = (ConfigVariable)element).getName().equals(key)) continue;
            return cv.getValue();
        }
        return null;
    }

    @Override
    public List<String> getValues(String categoryName, String key) {
        Category category = this.getCategory(categoryName);
        ArrayList<String> result = new ArrayList<String>();
        if (category == null) {
            return result;
        }
        for (ConfigElement element : category.getElements()) {
            ConfigVariable cv;
            if (!(element instanceof ConfigVariable) || !(cv = (ConfigVariable)element).getName().equals(key)) continue;
            result.add(cv.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Category getCategory(String name) {
        Map<String, Category> map = this.categories;
        synchronized (map) {
            return this.categories.get(name);
        }
    }
}

