/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.io.IOException;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.command.VerboseCommand;
import org.asteriskjava.fastagi.internal.AgiChannelImpl;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiReaderImpl;
import org.asteriskjava.fastagi.internal.AgiWriter;
import org.asteriskjava.fastagi.internal.AgiWriterImpl;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;

public class AgiConnectionHandler
implements Runnable {
    private static final String AJ_AGISTATUS_VARIABLE = "AJ_AGISTATUS";
    private static final String AJ_AGISTATUS_NOT_FOUND = "NOT_FOUND";
    private static final String AJ_AGISTATUS_SUCCESS = "SUCCESS";
    private static final String AJ_AGISTATUS_FAILED = "FAILED";
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final ThreadLocal<AgiChannel> channel = new ThreadLocal();
    private final SocketConnectionFacade socket;
    private final MappingStrategy mappingStrategy;

    public AgiConnectionHandler(SocketConnectionFacade socket, MappingStrategy mappingStrategy) {
        this.socket = socket;
        this.mappingStrategy = mappingStrategy;
    }

    protected AgiReader createReader() {
        return new AgiReaderImpl(this.socket);
    }

    protected AgiWriter createWriter() {
        return new AgiWriterImpl(this.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AgiChannelImpl channel = null;
        try {
            AgiReader reader = this.createReader();
            AgiWriter writer = this.createWriter();
            AgiRequest request = reader.readRequest();
            channel = new AgiChannelImpl(request, writer, reader);
            AgiConnectionHandler.channel.set(channel);
            AgiScript script = this.mappingStrategy.determineScript(request);
            if (script == null) {
                String errorMessage = "No script configured for URL '" + request.getRequestURL() + "' (script '" + request.getScript() + "')";
                this.logger.error(errorMessage);
                this.setStatusVariable(channel, AJ_AGISTATUS_NOT_FOUND);
                this.logToAsterisk(channel, errorMessage);
            } else {
                this.runScript(script, request, channel);
            }
        }
        catch (AgiException e) {
            this.setStatusVariable(channel, AJ_AGISTATUS_FAILED);
            this.logger.error("AgiException while handling request", e);
        }
        catch (Exception e) {
            this.setStatusVariable(channel, AJ_AGISTATUS_FAILED);
            this.logger.error("Unexpected Exception while handling request", e);
        }
        finally {
            AgiConnectionHandler.channel.set(null);
            try {
                this.socket.close();
            }
            catch (IOException e) {}
        }
    }

    private void runScript(AgiScript script, AgiRequest request, AgiChannel channel) {
        String threadName = Thread.currentThread().getName();
        this.logger.info("Begin AgiScript " + script.getClass().getName() + " on " + threadName);
        try {
            script.service(request, channel);
            this.setStatusVariable(channel, AJ_AGISTATUS_SUCCESS);
        }
        catch (AgiException e) {
            this.logger.error("AgiException running AgiScript " + script.getClass().getName() + " on " + threadName, e);
            this.setStatusVariable(channel, AJ_AGISTATUS_FAILED);
        }
        catch (Exception e) {
            this.logger.error("Exception running AgiScript " + script.getClass().getName() + " on " + threadName, e);
            this.setStatusVariable(channel, AJ_AGISTATUS_FAILED);
        }
        this.logger.info("End AgiScript " + script.getClass().getName() + " on " + threadName);
    }

    private void setStatusVariable(AgiChannel channel, String value) {
        if (channel == null) {
            return;
        }
        try {
            channel.setVariable(AJ_AGISTATUS_VARIABLE, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logToAsterisk(AgiChannel channel, String message) {
        if (channel == null) {
            return;
        }
        try {
            channel.sendCommand(new VerboseCommand(message, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static AgiChannel getChannel() {
        return channel.get();
    }
}

