/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.io.IOException;
import java.util.ArrayList;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiHangupException;
import org.asteriskjava.fastagi.AgiNetworkException;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiReplyImpl;
import org.asteriskjava.fastagi.internal.AgiRequestImpl;
import org.asteriskjava.fastagi.reply.AgiReply;
import org.asteriskjava.util.SocketConnectionFacade;

class AgiReaderImpl
implements AgiReader {
    private final SocketConnectionFacade socket;

    AgiReaderImpl(SocketConnectionFacade socket) {
        this.socket = socket;
    }

    public AgiRequest readRequest() throws AgiException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = this.socket.readLine()) != null && line.length() != 0) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new AgiNetworkException("Unable to read request from Asterisk: " + e.getMessage(), e);
        }
        AgiRequestImpl request = new AgiRequestImpl(lines);
        request.setLocalAddress(this.socket.getLocalAddress());
        request.setLocalPort(this.socket.getLocalPort());
        request.setRemoteAddress(this.socket.getRemoteAddress());
        request.setRemotePort(this.socket.getRemotePort());
        return request;
    }

    public AgiReply readReply() throws AgiException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            line = this.socket.readLine();
        }
        catch (IOException e) {
            throw new AgiNetworkException("Unable to read reply from Asterisk: " + e.getMessage(), e);
        }
        if (line == null) {
            throw new AgiHangupException();
        }
        lines.add(line);
        if (line.startsWith(Integer.toString(520))) {
            try {
                while ((line = this.socket.readLine()) != null) {
                    lines.add(line);
                    if (!line.startsWith(Integer.toString(520))) continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new AgiNetworkException("Unable to read reply from Asterisk: " + e.getMessage(), e);
            }
        }
        AgiReplyImpl reply = new AgiReplyImpl(lines);
        return reply;
    }
}

