/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.fastagi.reply.AgiReply;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgiReplyImpl
implements Serializable,
AgiReply {
    private static final Pattern STATUS_PATTERN = Pattern.compile("^(\\d{3})[ -]");
    private static final Pattern RESULT_PATTERN = Pattern.compile("^200 result= *(\\S+)");
    private static final Pattern PARENTHESIS_PATTERN = Pattern.compile("^200 result=\\S* +\\((.*)\\)");
    private static final Pattern ADDITIONAL_ATTRIBUTES_PATTERN = Pattern.compile("^200 result=\\S* +(\\(.*\\) )?(.+)$");
    private static final Pattern ADDITIONAL_ATTRIBUTE_PATTERN = Pattern.compile("(\\S+)=(\\S+)");
    private static final Pattern SYNOPSIS_PATTERN = Pattern.compile("^\\s*Usage:\\s*(.*)\\s*$");
    private static final String END_OF_PROPER_USAGE = "520 End of proper usage.";
    private Matcher matcher;
    private static final long serialVersionUID = 3256727294671337012L;
    private List<String> lines;
    private String firstLine;
    private String result;
    private int status;
    private Map<String, String> attributes;
    private String extra;
    private String synopsis;
    private String usage;
    private boolean resultCreated;
    private boolean statusCreated;
    private boolean attributesCreated;
    private boolean extraCreated;
    private boolean synopsisCreated;

    AgiReplyImpl() {
    }

    AgiReplyImpl(List<String> lines) {
        if (lines != null) {
            this.lines = new ArrayList<String>(lines);
            if (!lines.isEmpty()) {
                this.firstLine = lines.get(0);
            }
        }
    }

    @Override
    public String getFirstLine() {
        return this.firstLine;
    }

    @Override
    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public int getResultCode() {
        String result = this.getResult();
        if (result == null) {
            return -1;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public char getResultCodeAsChar() {
        int resultCode = this.getResultCode();
        if (resultCode < 0) {
            return '\u0000';
        }
        return (char)resultCode;
    }

    @Override
    public String getResult() {
        if (this.resultCreated) {
            return this.result;
        }
        this.matcher = RESULT_PATTERN.matcher(this.firstLine);
        if (this.matcher.find()) {
            this.result = this.matcher.group(1);
        }
        this.resultCreated = true;
        return this.result;
    }

    @Override
    public int getStatus() {
        if (this.statusCreated) {
            return this.status;
        }
        this.matcher = STATUS_PATTERN.matcher(this.firstLine);
        if (this.matcher.find()) {
            this.status = Integer.parseInt(this.matcher.group(1));
        }
        this.statusCreated = true;
        return this.status;
    }

    @Override
    public String getAttribute(String name) {
        if (this.getStatus() != 200) {
            return null;
        }
        if ("result".equalsIgnoreCase(name)) {
            return this.getResult();
        }
        if (!this.attributesCreated) {
            this.matcher = ADDITIONAL_ATTRIBUTES_PATTERN.matcher(this.firstLine);
            if (this.matcher.find()) {
                this.attributes = new HashMap<String, String>();
                String s = this.matcher.group(2);
                Matcher attributeMatcher = ADDITIONAL_ATTRIBUTE_PATTERN.matcher(s);
                while (attributeMatcher.find()) {
                    String key = attributeMatcher.group(1);
                    String value = attributeMatcher.group(2);
                    this.attributes.put(key.toLowerCase(Locale.ENGLISH), value);
                }
            }
            this.attributesCreated = true;
        }
        if (this.attributes == null || this.attributes.isEmpty()) {
            return null;
        }
        return this.attributes.get(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getExtra() {
        if (this.getStatus() != 200) {
            return null;
        }
        if (this.extraCreated) {
            return this.extra;
        }
        this.matcher = PARENTHESIS_PATTERN.matcher(this.firstLine);
        if (this.matcher.find()) {
            this.extra = this.matcher.group(1);
        }
        this.extraCreated = true;
        return this.extra;
    }

    @Override
    public String getSynopsis() {
        if (this.getStatus() != 520) {
            return null;
        }
        if (!this.synopsisCreated) {
            String line;
            String secondLine;
            Matcher synopsisMatcher;
            if (this.lines.size() > 1 && (synopsisMatcher = SYNOPSIS_PATTERN.matcher(secondLine = this.lines.get(1))).find()) {
                this.synopsis = synopsisMatcher.group(1);
            }
            this.synopsisCreated = true;
            StringBuffer usageSB = new StringBuffer();
            for (int i = 2; i < this.lines.size() && !END_OF_PROPER_USAGE.equals(line = this.lines.get(i)); ++i) {
                usageSB.append(line.trim());
                usageSB.append(" ");
            }
            this.usage = usageSB.toString().trim();
        }
        return this.synopsis;
    }

    @Override
    public String getUsage() {
        return this.usage;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AgiReply[");
        sb.append("status='" + this.getStatus() + "',");
        if (this.status == 200) {
            sb.append("result='" + this.getResult() + "',");
            sb.append("extra='" + this.getExtra() + "',");
            sb.append("attributes=" + this.attributes + ",");
        }
        if (this.status == 520) {
            sb.append("synopsis='" + this.getSynopsis() + "',");
        }
        sb.append("systemHashcode=" + System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }
}

