/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live;

import java.io.Serializable;
import org.asteriskjava.util.AstUtil;

public class CallerId
implements Serializable {
    private static final long serialVersionUID = 6498024163374551005L;
    private final String name;
    private final String number;

    public CallerId(String name, String number) {
        this.name = AstUtil.isNull(name) ? null : name;
        this.number = AstUtil.isNull(number) ? null : number;
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public static CallerId valueOf(String s) {
        String[] parsedCallerId = AstUtil.parseCallerId(s);
        return new CallerId(parsedCallerId[0], parsedCallerId[1]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append("\"");
            sb.append(this.name);
            sb.append("\"");
            if (this.number != null) {
                sb.append(" ");
            }
        }
        if (this.number != null) {
            sb.append("<");
            sb.append(this.number);
            sb.append(">");
        }
        return sb.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallerId other = (CallerId)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.number == null ? other.number != null : !this.number.equals(other.number));
    }
}

