/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.Date;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.QueueEntryState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;

class AsteriskQueueEntryImpl
extends AbstractLiveObject
implements AsteriskQueueEntry {
    private final AsteriskQueueImpl queue;
    private final AsteriskChannelImpl channel;
    private final Date dateJoined;
    private Date dateLeft;
    private QueueEntryState state;
    private int reportedPosition;
    private int position = -1;

    AsteriskQueueEntryImpl(AsteriskServerImpl server, AsteriskQueueImpl queue, AsteriskChannelImpl channel, int reportedPosition, Date dateJoined) {
        super(server);
        this.queue = queue;
        this.channel = channel;
        this.dateJoined = dateJoined;
        this.state = QueueEntryState.JOINED;
        this.reportedPosition = reportedPosition;
    }

    public String getChannelName() {
        return this.channel.getName();
    }

    public AsteriskQueueImpl getQueue() {
        return this.queue;
    }

    public AsteriskChannelImpl getChannel() {
        return this.channel;
    }

    public Date getDateJoined() {
        return this.dateJoined;
    }

    public Date getDateLeft() {
        return this.dateLeft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void left(Date dateLeft) {
        QueueEntryState oldState;
        AsteriskQueueEntryImpl asteriskQueueEntryImpl = this;
        synchronized (asteriskQueueEntryImpl) {
            oldState = this.state;
            this.dateLeft = dateLeft;
            this.state = QueueEntryState.LEFT;
        }
        this.firePropertyChange("state", (Object)oldState, (Object)this.state);
    }

    public QueueEntryState getState() {
        return this.state;
    }

    public int getReportedPosition() {
        return this.reportedPosition;
    }

    public int getPosition() {
        return this.position;
    }

    void setPosition(int position) {
        int oldPosition = this.position;
        this.position = position;
        this.firePropertyChange("position", oldPosition, position);
    }

    void setReportedPosition(int reportedPosition) {
        int oldPosition = this.reportedPosition;
        this.reportedPosition = reportedPosition;
        this.firePropertyChange("reportedPosition", oldPosition, reportedPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int systemHashcode;
        StringBuffer sb = new StringBuffer("AsteriskQueueEntry[");
        AbstractLiveObject abstractLiveObject = this;
        synchronized (abstractLiveObject) {
            sb.append("dateJoined='").append(this.getDateJoined()).append("',");
            sb.append("postition='").append(this.getPosition()).append("',");
            sb.append("dateLeft='").append(this.getDateLeft()).append("',");
            systemHashcode = System.identityHashCode(this);
        }
        sb.append("channel=AsteriskChannel[");
        abstractLiveObject = this.channel;
        synchronized (abstractLiveObject) {
            sb.append("id='").append(this.channel.getId()).append("',");
            sb.append("name='").append(this.channel.getName()).append("'],");
        }
        sb.append("systemHashcode=").append(systemHashcode);
        sb.append("]");
        return sb.toString();
    }
}

