/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueMember;
import org.asteriskjava.live.InvalidPenaltyException;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.live.QueueMemberState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.manager.action.QueuePenaltyAction;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;

class AsteriskQueueMemberImpl
extends AbstractLiveObject
implements AsteriskQueueMember {
    private AsteriskQueue queue;
    private QueueMemberState state;
    private String location;
    private Integer penalty;

    AsteriskQueueMemberImpl(AsteriskServerImpl server, AsteriskQueueImpl queue, String location, QueueMemberState state, Integer penalty) {
        super(server);
        this.queue = queue;
        this.location = location;
        this.state = state;
        this.penalty = penalty;
    }

    public AsteriskQueue getQueue() {
        return this.queue;
    }

    public String getLocation() {
        return this.location;
    }

    public QueueMemberState getState() {
        return this.state;
    }

    public Integer getPenalty() {
        return this.penalty;
    }

    public void setPenalty(int penalty) throws IllegalArgumentException, ManagerCommunicationException, InvalidPenaltyException {
        if (penalty < 0) {
            throw new IllegalArgumentException("Penalty must not be negative");
        }
        ManagerResponse response = this.server.sendAction(new QueuePenaltyAction(this.location, penalty, this.queue.getName()));
        if (response instanceof ManagerError) {
            throw new InvalidPenaltyException("Unable to set penalty for '" + this.location + "' on '" + this.queue.getName() + "': " + response.getMessage());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AsteriskQueueMember[");
        sb.append("location='").append(this.location).append("'");
        sb.append("state='").append((Object)this.state).append("'");
        sb.append("queue='").append(this.queue.getName()).append("'");
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }

    synchronized void stateChanged(QueueMemberState state) {
        QueueMemberState oldState = this.state;
        this.state = state;
        this.firePropertyChange("state", (Object)oldState, (Object)state);
    }

    synchronized void penaltyChanged(Integer penalty) {
        Integer oldPenalty = this.penalty;
        this.penalty = penalty;
        this.firePropertyChange("penalty", oldPenalty, penalty);
    }
}

