/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.event;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.manager.event.ManagerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAgiEvent
extends ManagerEvent {
    static final long serialVersionUID = 0L;
    public static final String SUB_EVENT_START = "Start";
    public static final String SUB_EVENT_EXEC = "Exec";
    public static final String SUB_EVENT_END = "End";
    private String channel;
    private String subEvent;
    private String commandId;
    private String result;
    private String env;

    public AsyncAgiEvent(Object source) {
        super(source);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getSubEvent() {
        return this.subEvent;
    }

    public void setSubEvent(String subEvent) {
        this.subEvent = subEvent;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getResult() {
        return this.result;
    }

    public String decodeResult() {
        if (this.result == null) {
            return null;
        }
        try {
            return URLDecoder.decode(this.result, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getEnv() {
        return this.env;
    }

    public Map<String, String> decodeEnv() {
        HashMap<String, String> decodedEnv = new HashMap<String, String>();
        if (this.env == null) {
            return decodedEnv;
        }
        try {
            for (String line : this.env.split("\n")) {
                String decodedLine = URLDecoder.decode(line, "ISO-8859-1");
                String[] nv = decodedLine.split(": ");
                if (nv.length != 2) continue;
                decodedEnv.put(nv[0], nv[1]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedEnv;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public boolean isStart() {
        return this.isSubEvent(SUB_EVENT_START);
    }

    public boolean isExec() {
        return this.isSubEvent(SUB_EVENT_EXEC);
    }

    public boolean isEnd() {
        return this.isSubEvent(SUB_EVENT_END);
    }

    protected boolean isSubEvent(String subEvent) {
        return this.subEvent != null && this.subEvent.equalsIgnoreCase(subEvent);
    }
}

